/*
 * Decompiled with CFR 0.152.
 */
package rero.dck;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import rero.dck.DCapabilities;
import rero.dck.DGroup;
import rero.dck.DItem;
import rero.dck.DParent;
import rero.dck.items.BlankInput;
import rero.dck.items.CharsetInput;
import rero.dck.items.CheckboxInput;
import rero.dck.items.ColorInput;
import rero.dck.items.DirectoryInput;
import rero.dck.items.FileInput;
import rero.dck.items.FloatInput;
import rero.dck.items.FontInput;
import rero.dck.items.LabelInput;
import rero.dck.items.ListInput;
import rero.dck.items.NetworkSelect;
import rero.dck.items.NormalInput;
import rero.dck.items.OptionInput;
import rero.dck.items.OtherInput;
import rero.dck.items.SelectInput;
import rero.dck.items.StringInput;
import rero.dck.items.TabbedInput;
import rero.dck.items.TextInput;

public abstract class DContainer {
    protected LinkedList itemList;
    protected JComponent dialog;
    protected GridBagConstraints constraints = new GridBagConstraints();
    protected DCapabilities capabilities;

    public DContainer() {
        this.itemList = new LinkedList();
        this.constraints.gridwidth = 0;
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.insets = new Insets(0, 0, 2, 0);
    }

    public void installCapabilities(DCapabilities c) {
        this.capabilities = c;
    }

    public DCapabilities getCapabilities() {
        return this.capabilities;
    }

    public JComponent getDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new JPanel();
        JComponent child = this.setupLayout(this.dialog);
        this.setupDialog();
        int maxWidth = 0;
        Iterator i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            if (temp.getEstimatedWidth() <= maxWidth) continue;
            maxWidth = temp.getEstimatedWidth();
        }
        GridBagLayout layout = new GridBagLayout();
        child.setLayout(layout);
        i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            temp.setAlignWidth(maxWidth);
            JComponent blah = temp.getComponent();
            layout.setConstraints(blah, this.constraints);
            child.add(blah);
        }
        return this.dialog;
    }

    public void setEnabled(boolean b) {
        Iterator i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            temp.setEnabled(b);
        }
        this.dialog.setEnabled(b);
    }

    public void setParent(DParent parent) {
        Iterator i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            temp.setParent(parent);
        }
    }

    public void save() {
        Iterator i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            temp.save();
        }
    }

    public void refresh() {
        Iterator i = this.itemList.iterator();
        while (i.hasNext()) {
            DItem temp = (DItem)i.next();
            temp.refresh();
        }
    }

    public abstract JComponent setupLayout(JComponent var1);

    public abstract void setupDialog();

    public abstract String getTitle();

    public StringInput addStringInput(String var, String defValue, String label, char Mn) {
        StringInput temp = new StringInput(var, defValue, label, 0, Mn);
        this.itemList.add(temp);
        return temp;
    }

    public StringInput addStringInput(String var, String defValue, String label, char Mn, int gap) {
        StringInput temp = new StringInput(var, defValue, label, gap, Mn);
        this.itemList.add(temp);
        return temp;
    }

    public CheckboxInput addCheckboxInput(String variable, boolean defValue, String label, char Mn) {
        CheckboxInput temp = new CheckboxInput(variable, defValue, label, Mn);
        this.itemList.add(temp);
        return temp;
    }

    public CheckboxInput addCheckboxInput(String variable, boolean defValue, String label, char Mn, int alignment) {
        CheckboxInput temp = new CheckboxInput(variable, defValue, label, Mn, alignment);
        this.itemList.add(temp);
        return temp;
    }

    public FileInput addFileInput(String variable, String defValue, String label, char Mn, int inset) {
        FileInput temp = new FileInput(variable, defValue, label, Mn, false, inset);
        this.itemList.add(temp);
        return temp;
    }

    public DirectoryInput addDirectoryInput(String variable, String defValue, String label, char Mn, int inset) {
        DirectoryInput temp = new DirectoryInput(variable, defValue, label, Mn, inset);
        this.itemList.add(temp);
        return temp;
    }

    public ListInput addListInput(String variable, String title, String desc, int width, int height) {
        ListInput temp = new ListInput(variable, title, desc, width, height);
        this.itemList.add(temp);
        return temp;
    }

    public FontInput addFontInput(String variable, Font defaultf) {
        FontInput temp = new FontInput(variable, defaultf);
        this.itemList.add(temp);
        return temp;
    }

    public CharsetInput addCharsetInput(String variable, String label, char Mnemonic, int gap) {
        CharsetInput temp = new CharsetInput(variable, label, Mnemonic, gap);
        this.itemList.add(temp);
        return temp;
    }

    public SelectInput addSelectInput(String variable, int defaultV, String[] values, String label, char Mnemonic, int gap) {
        SelectInput temp = new SelectInput(variable, defaultV, values, label, Mnemonic, gap);
        this.itemList.add(temp);
        return temp;
    }

    public OptionInput addOptionInput(String variable, String defaultV, String[] values, String label, char Mnemonic, int gap) {
        OptionInput temp = new OptionInput(variable, defaultV, values, label, Mnemonic, gap);
        this.itemList.add(temp);
        return temp;
    }

    public NetworkSelect addNetworkSelector(String variable, String variable2) {
        NetworkSelect temp = new NetworkSelect(variable, variable2);
        this.itemList.add(temp);
        return temp;
    }

    public TextInput addTextInput(String variable, int gap) {
        TextInput temp = new TextInput(variable, gap);
        this.itemList.add(temp);
        return temp;
    }

    public ColorInput addColorInput(String variable, Color defaultColor, String text, char mnemonic) {
        ColorInput temp = new ColorInput(variable, defaultColor, text, mnemonic);
        this.itemList.add(temp);
        return temp;
    }

    public FloatInput addFloatInput(String variable, float defaultf, String text) {
        FloatInput temp = new FloatInput(variable, defaultf, text);
        this.itemList.add(temp);
        return temp;
    }

    public DGroup addDialogGroup(DGroup g) {
        this.itemList.add(g);
        return g;
    }

    public BlankInput addBlankSpace() {
        BlankInput temp = new BlankInput();
        this.itemList.add(temp);
        return temp;
    }

    public LabelInput addLabel(String text, int gap) {
        LabelInput temp = new LabelInput(text, gap);
        this.itemList.add(temp);
        return temp;
    }

    public NormalInput addLabelNormal(String text, int align) {
        NormalInput temp = new NormalInput(text, align);
        this.itemList.add(temp);
        return temp;
    }

    public DItem addComponent(JComponent component) {
        OtherInput temp = new OtherInput(component);
        this.itemList.add(temp);
        return temp;
    }

    public TabbedInput addTabbedInput() {
        TabbedInput temp = new TabbedInput();
        this.itemList.add(temp);
        return temp;
    }

    public DItem addOther(DItem item) {
        this.itemList.add(item);
        return item;
    }
}

