/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import rero.dcc.ProtocolDCC;

public class Send
extends ProtocolDCC {
    protected static int PACKET_SIZE = 4096;
    protected File dumpFrom;
    protected FileInputStream fileStream;
    protected long sentSize;
    protected long ackSize;
    protected long finalSize;
    protected long startSize;

    public boolean resume(long size) {
        if (size < this.dumpFrom.length()) {
            this.sentSize = size;
            this.startSize = size;
            return true;
        }
        return false;
    }

    public Send(String _nickname, File _dumpFrom) {
        this.nickname = _nickname;
        this.dumpFrom = _dumpFrom;
        this.finalSize = _dumpFrom.length();
        this.ackSize = 0L;
        this.sentSize = 0L;
        this.startSize = 0L;
        this.eventData = new HashMap();
    }

    public long getBytesSent() {
        return this.sentSize;
    }

    public long getAcknowledgedSize() {
        return this.ackSize;
    }

    public File getFile() {
        return this.dumpFrom;
    }

    public long getStartOffset() {
        return this.startSize;
    }

    public long getTimeRemaining() {
        long totalSizeLeft = this.getFile().length() - this.getBytesSent();
        long transferRate = this.getTransferRate();
        if (transferRate == 0L) {
            transferRate = 1000L;
        }
        return totalSizeLeft / transferRate;
    }

    public int getTransferRate() {
        if (this.getTotalTime() < 1000L) {
            return 1000;
        }
        return (int)((this.getBytesSent() - this.getStartOffset()) / (this.getTotalTime() / 1000L));
    }

    public int getTypeOfDCC() {
        return 1;
    }

    private static void skipFully(InputStream in, long nBytes) throws IOException {
        long skipped;
        for (long remaining = nBytes; remaining != 0L; remaining -= skipped) {
            skipped = in.skip(remaining);
            if (skipped != 0L) continue;
            throw new EOFException();
        }
    }

    public void run() {
        block13: {
            if (this.socket == null || !this.socket.isConnected()) {
                return;
            }
            try {
                this.socket.setSoTimeout(120000);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.fireEvent("SEND_START", null);
            DataInputStream istream = null;
            OutputStream ostream = null;
            byte[] data = new byte[PACKET_SIZE];
            try {
                this.fileStream = new FileInputStream(this.dumpFrom);
                Send.skipFully(this.fileStream, this.sentSize);
                istream = new DataInputStream(this.socket.getInputStream());
                ostream = this.socket.getOutputStream();
                while (this.socket.isConnected() && this.sentSize < this.finalSize) {
                    int thisRead = this.finalSize - this.sentSize < (long)PACKET_SIZE ? this.fileStream.read(data, 0, (int)(this.finalSize - this.sentSize)) : this.fileStream.read(data, 0, PACKET_SIZE);
                    if (thisRead > 0) {
                        ostream.write(data, 0, thisRead);
                        ostream.flush();
                        this.sentSize += (long)thisRead;
                    }
                    if (istream.available() < 4) continue;
                    this.ackSize = 0L;
                    this.ackSize += (long)(istream.readUnsignedByte() << 24);
                    this.ackSize += (long)(istream.readUnsignedByte() << 16);
                    this.ackSize += (long)(istream.readUnsignedByte() << 8);
                    this.ackSize += (long)(istream.readUnsignedByte() << 0);
                    this.idleTime = System.currentTimeMillis();
                }
                while (this.socket.isConnected() && this.ackSize < this.finalSize && this.getIdleTime() < 10000L) {
                    if (istream.available() >= 4) {
                        this.ackSize = 0L;
                        this.ackSize += (long)(istream.readUnsignedByte() << 24);
                        this.ackSize += (long)(istream.readUnsignedByte() << 16);
                        this.ackSize += (long)(istream.readUnsignedByte() << 8);
                        this.ackSize += (long)(istream.readUnsignedByte() << 0);
                        this.idleTime = System.currentTimeMillis();
                        continue;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception ex) {
                if (this.sentSize == this.finalSize) break block13;
                ex.printStackTrace();
                this.fireError(ex.getMessage());
                return;
            }
        }
        try {
            this.fileStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.sentSize == this.finalSize) {
            this.fireEvent("SEND_COMPLETE", null);
        } else {
            this.fireError("incomplete");
        }
    }

    public void fireError(String description) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "SEND_FAILED");
        this.eventData.put("$data", this.getNickname() + " " + description);
        this.eventData.put("$parms", description);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireEvent(String event, String description) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", event);
        this.eventData.put("$data", this.getNickname() + " " + description);
        this.eventData.put("$parms", description);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

