/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import rero.dcc.ProtocolDCC;

public class Receive
extends ProtocolDCC {
    protected static int PACKET_SIZE = 4096;
    protected File dumpTo;
    protected FileOutputStream fileStream;
    protected long receivedSize;
    protected long finalSize;
    protected long startSize;

    public Receive(String _nickname, File _dumpTo, long _finalSize) {
        this.nickname = _nickname;
        this.dumpTo = _dumpTo;
        this.finalSize = _finalSize;
        this.receivedSize = 0L;
        this.startSize = 0L;
    }

    public long getBytesReceived() {
        return this.receivedSize;
    }

    public long getExpectedSize() {
        return this.finalSize;
    }

    public File getFile() {
        return this.dumpTo;
    }

    public long getTimeRemaining() {
        long toGo = this.getExpectedSize() - this.getFile().length();
        long transferRate = this.getTransferRate();
        if (transferRate == 0L) {
            transferRate = 1000L;
        }
        return toGo / transferRate;
    }

    public void setFile(File f) {
        this.dumpTo = f;
    }

    public void pleaseResume() {
        this.receivedSize = this.dumpTo.length();
        this.startSize = this.dumpTo.length();
    }

    public long getStartOffset() {
        return this.startSize;
    }

    public int getTransferRate() {
        if (this.getTotalTime() < 1000L) {
            return 1000;
        }
        return (int)((this.getBytesReceived() - this.getStartOffset()) / (this.getTotalTime() / 1000L));
    }

    public int getTypeOfDCC() {
        return 2;
    }

    public void run() {
        Exception transferError;
        block13: {
            if (this.socket == null || !this.socket.isConnected()) {
                return;
            }
            try {
                this.socket.setSoTimeout(120000);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.fireEvent("RECEIVE_START", null);
            this.startTime = System.currentTimeMillis();
            InputStream istream = null;
            OutputStream ostream = null;
            byte[] data = new byte[PACKET_SIZE];
            byte[] ackPacket = new byte[4];
            transferError = null;
            try {
                boolean appendToFile;
                boolean bl = appendToFile = this.startSize != 0L;
                if (!this.dumpTo.getParentFile().exists()) {
                    this.dumpTo.getParentFile().mkdirs();
                }
                this.fileStream = new FileOutputStream(this.dumpTo, appendToFile);
                istream = this.socket.getInputStream();
                ostream = this.socket.getOutputStream();
                while (this.receivedSize < this.finalSize && this.socket.isConnected()) {
                    int thisRead = this.finalSize - this.receivedSize < (long)PACKET_SIZE ? istream.read(data, 0, (int)(this.finalSize - this.receivedSize)) : istream.read(data, 0, PACKET_SIZE);
                    if (thisRead <= 0) continue;
                    this.fileStream.write(data, 0, thisRead);
                    this.receivedSize += (long)thisRead;
                    ackPacket[0] = (byte)((this.receivedSize & 0xFFFFFFFFFF000000L) >> 24 | 0L);
                    ackPacket[1] = (byte)((this.receivedSize & 0xFF0000L) >> 16 | 0L);
                    ackPacket[2] = (byte)((this.receivedSize & 0xFF00L) >> 8 | 0L);
                    ackPacket[3] = (byte)((this.receivedSize & 0xFFL) >> 0 | 0L);
                    ostream.write(ackPacket, 0, 4);
                    ostream.flush();
                }
            }
            catch (Exception ex) {
                if (this.receivedSize == this.finalSize) break block13;
                ex.printStackTrace();
                transferError = ex;
            }
        }
        try {
            this.fileStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.receivedSize == this.finalSize) {
            this.fireEvent("RECEIVE_COMPLETE", null);
        } else if (transferError != null) {
            this.fireError(transferError.getMessage());
        } else {
            this.fireError("incomplete");
        }
    }

    public void fireEvent(String event, String description) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", event);
        this.eventData.put("$data", this.getNickname() + " " + description);
        this.eventData.put("$parms", description);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireError(String description) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "RECEIVE_FAILED");
        this.eventData.put("$data", this.getNickname() + " " + description);
        this.eventData.put("$parms", description);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

