/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.net.Socket;
import java.util.HashMap;
import rero.ircfw.ChatFramework;
import rero.ircfw.ProtocolDispatcher;

public abstract class ProtocolDCC {
    public static final int DCC_SEND = 1;
    public static final int DCC_RECEIVE = 2;
    public static final int DCC_CHAT = 3;
    public static final int STATE_WAIT = 401;
    public static final int STATE_OPEN = 402;
    public static final int STATE_CLOSED = 403;
    public static final int DCC_TIMEOUT = 120000;
    protected String nickname;
    protected Socket socket;
    protected long idleTime;
    protected long startTime;
    protected HashMap eventData = new HashMap();
    protected ProtocolDispatcher dispatcher;
    protected int state = 401;

    public abstract int getTypeOfDCC();

    public void close() {
        try {
            this.socket.close();
            this.state = 403;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getState() {
        if (this.state == 402 && !this.isConnected()) {
            this.state = 403;
        }
        return this.state;
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public void announceFramework(ChatFramework f) {
        this.dispatcher = f.getProtocolDispatcher();
    }

    public abstract void run();

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public String getNickname() {
        return this.nickname;
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.idleTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void setDCCSocket(Socket _socket) {
        this.socket = _socket;
        this.startTime = System.currentTimeMillis();
        this.idleTime = System.currentTimeMillis();
        this.state = 402;
    }

    public abstract void fireError(String var1);
}

