/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import rero.config.ClientState;
import rero.dcc.GenericDCC;

public class ListenDCC
extends GenericDCC {
    protected ServerSocket server = null;
    protected static int offset = 0;
    protected static int timeout = 60000;

    public static int getNextPort() {
        int rangeStart = ClientState.getClientState().getInteger("dcc.low", 4096);
        int rangeStop = ClientState.getClientState().getInteger("dcc.high", 8192);
        ++offset;
        return rangeStart + (offset %= rangeStop - rangeStart);
    }

    public int getListenerPort() {
        try {
            this.server = new ServerSocket(ListenDCC.getNextPort());
            return this.server.getLocalPort();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public Socket establishConnection() {
        try {
            this.server.setSoTimeout(timeout);
            return this.server.accept();
        }
        catch (SocketTimeoutException stex) {
            this.getImplementation().fireError("timed out waiting for connection");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.getImplementation().fireError(ex.getMessage());
        }
        return null;
    }
}

