/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rero.dcc.GenericDCC;
import rero.dcc.ProtocolDCC;

public class DataDCC {
    protected static List dccList;
    protected static HashMap resumeData;
    protected HashMap connectionCache = new HashMap();

    public DataDCC() {
        if (dccList == null) {
            dccList = Collections.synchronizedList(new LinkedList());
        }
        if (resumeData == null) {
            resumeData = new HashMap();
        }
    }

    public void addConnection(String port, GenericDCC dcc) {
        dccList.add(dcc);
        resumeData.put(port, dcc);
    }

    public LinkedList getConnections(int type, int state) {
        return this.getConnections(dccList, type, state);
    }

    public LinkedList getConnections(Collection dccCollection, int type, int state) {
        LinkedList<GenericDCC> rv = new LinkedList<GenericDCC>();
        Iterator iter = dccCollection.iterator();
        while (iter.hasNext()) {
            GenericDCC temp = (GenericDCC)iter.next();
            if (type != -1 && temp.getTypeOfDCC() != type || state != -1 && temp.getState() != state) continue;
            rv.add(temp);
        }
        return rv;
    }

    public List getAllConnections() {
        return dccList;
    }

    public GenericDCC getConnectionFromHash(String hash2) {
        Iterator i = this.getAllConnections().iterator();
        while (i.hasNext()) {
            GenericDCC temp = (GenericDCC)i.next();
            if (!temp.getImplementation().toString().equals(hash2)) continue;
            return temp;
        }
        return null;
    }

    public Iterator getActiveConnections() {
        return this.getConnections(-1, 402).iterator();
    }

    public Iterator getWaitingConnections() {
        return this.getConnections(-1, 401).iterator();
    }

    public Iterator getClosedConnections() {
        return this.getConnections(-1, 403).iterator();
    }

    public GenericDCC getUserConnection(Collection dccCollection, String nickname) {
        Iterator i = dccCollection.iterator();
        while (i.hasNext()) {
            GenericDCC temp = (GenericDCC)i.next();
            if (!temp.getNickname().equals(nickname)) continue;
            return temp;
        }
        return null;
    }

    public GenericDCC getConnection(String port) {
        return (GenericDCC)resumeData.get(port);
    }

    public GenericDCC getConnectionToAccept(String nickname) {
        return this.getUserConnection(this.getConnections(-1, 401), nickname);
    }

    public void closeConnection(String nickname) {
        this.closeConnection(nickname, -1);
    }

    public void closeConnection(String nickname, int type) {
        GenericDCC temp = this.getUserConnection(this.getConnections(type, 402), nickname);
        if (temp != null) {
            temp.getImplementation().close();
        }
    }

    public void closeChat(String nickname) {
        ProtocolDCC temp = this.getSpecificConnection(nickname, 3);
        if (temp != null) {
            temp.close();
        }
    }

    public void removeConnection(GenericDCC dcc) {
        dccList.remove(dcc.getImplementation());
        this.connectionCache.remove(dcc.getNickname());
    }

    public ProtocolDCC getSpecificConnection(String nickname, int type) {
        if (this.connectionCache.containsKey(nickname)) {
            ProtocolDCC connection = (ProtocolDCC)this.connectionCache.get(nickname);
            if (connection.getState() == 402 && connection.getTypeOfDCC() == type) {
                return connection;
            }
            this.connectionCache.remove(nickname);
        }
        Iterator i = this.getActiveConnections();
        while (i.hasNext()) {
            ProtocolDCC connection = ((GenericDCC)i.next()).getImplementation();
            if (connection.getTypeOfDCC() != type || !connection.getNickname().equals(nickname)) continue;
            this.connectionCache.put(nickname, connection);
            return connection;
        }
        return null;
    }
}

