/*
 * Decompiled with CFR 0.152.
 */
package rero.dcc;

import java.io.BufferedReader;
import java.io.PrintStream;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.dcc.ProtocolDCC;

public class Chat
extends ProtocolDCC
implements ClientStateListener {
    protected BufferedReader input;
    protected PrintStream output;

    public Chat(String _nickname) {
        this.nickname = _nickname;
        ClientState.getClientState().addClientStateListener("client.encoding", this);
    }

    public void propertyChanged(String property, String value) {
        try {
            if (this.input != null && this.socket.isConnected()) {
                ClientState.getClientState();
                this.input = new BufferedReader(ClientState.getProperInputStream(this.socket.getInputStream()));
                ClientState.getClientState();
                this.output = ClientState.getProperPrintStream(this.socket.getOutputStream());
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to switch encodings...");
            ex.printStackTrace();
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void sendln(String text) {
        this.output.println(text);
    }

    public int getTypeOfDCC() {
        return 3;
    }

    public void run() {
        if (this.socket == null || !this.socket.isConnected()) {
            return;
        }
        try {
            this.socket.setKeepAlive(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fireEvent("CHAT_OPEN", null);
        try {
            ClientState.getClientState();
            this.output = ClientState.getProperPrintStream(this.socket.getOutputStream());
            ClientState.getClientState();
            this.input = new BufferedReader(ClientState.getProperInputStream(this.socket.getInputStream()));
            while (this.socket.isConnected()) {
                String text = this.input.readLine();
                if (text == null) {
                    this.fireEvent("CHAT_CLOSE", "closed");
                    return;
                }
                this.idleTime = System.currentTimeMillis();
                this.fireEvent("CHAT", text);
            }
            this.fireEvent("CHAT_CLOSE", "closed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.fireError(ex.getMessage());
        }
    }

    public void fireEvent(String event, String description) {
        this.eventData.clear();
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", event);
        this.eventData.put("$this", this.toString());
        if (description != null) {
            this.eventData.put("$data", this.getNickname() + " " + description);
            this.eventData.put("$parms", description);
        }
        this.dispatcher.dispatchEvent(this.eventData);
    }

    public void fireError(String description) {
        this.eventData.put("$nick", this.getNickname());
        this.eventData.put("$event", "CHAT_CLOSE");
        this.eventData.put("$data", this.getNickname() + " " + description);
        this.eventData.put("$parms", description);
        this.eventData.put("$this", this.toString());
        this.dispatcher.dispatchEvent(this.eventData);
    }
}

