/*
 * Decompiled with CFR 0.152.
 */
package rero.config;

import java.util.LinkedList;
import java.util.ListIterator;
import rero.config.ClientState;

public class StringList {
    protected LinkedList values;
    protected String key;

    public StringList(String _key) {
        this.key = _key;
        this.load();
    }

    public void load() {
        String value = ClientState.getClientState().getString(this.key, null);
        LinkedList<String> rv = new LinkedList<String>();
        if (value != null) {
            String[] temp = value.split("::");
            for (int x = 0; x < temp.length; ++x) {
                if (temp[x].length() <= 0) continue;
                rv.add(temp[x]);
            }
        }
        this.values = rv;
    }

    public boolean isValue(String value) {
        return this.values.contains(value);
    }

    public LinkedList getList() {
        return this.values;
    }

    public void save() {
        StringBuffer value = new StringBuffer();
        if (this.values.size() > 0) {
            value.append(this.values.getFirst());
            ListIterator i = this.values.listIterator(1);
            while (i.hasNext()) {
                value.append("::");
                value.append(i.next().toString());
            }
        }
        ClientState.getClientState().setString(this.key, value.toString());
    }

    public void add(String element) {
        this.values.add(element);
    }

    public void remove(String element) {
        ListIterator i = this.values.listIterator();
        while (i.hasNext()) {
            if (!i.next().toString().equals(element)) continue;
            i.remove();
        }
        this.save();
        ClientState.getClientState().fireChange(this.key, element);
    }

    public void clear() {
        this.values = new LinkedList();
        this.save();
        ClientState.getClientState().fireChange(this.key);
    }
}

