/*
 * Decompiled with CFR 0.152.
 */
package rero.config;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.util.ClientUtils;

public class ClientState {
    protected static HashMap listeners = new HashMap();
    protected Set changes;
    protected Properties backup;
    protected static File baseDirectory = new File(System.getProperty("user.home"), ".jIRC");
    protected Properties state = new Properties();
    protected static ClientState clientState = null;

    public static void setBaseDirectory(String directory) {
        baseDirectory = new File(directory);
    }

    public void fireChange(String property) {
        this.fireChange(property, null);
    }

    public void addClientStateListener(String property, ClientStateListener l) {
        LinkedList<WeakReference<ClientStateListener>> temp = (LinkedList<WeakReference<ClientStateListener>>)listeners.get(property);
        if (temp == null) {
            temp = new LinkedList<WeakReference<ClientStateListener>>();
            listeners.put(property, temp);
        }
        temp.add(new WeakReference<ClientStateListener>(l));
    }

    public void fireChange(String property, String parameter) {
        if (listeners.get(property) == null) {
            return;
        }
        Iterator i = ((LinkedList)listeners.get(property)).iterator();
        while (i.hasNext()) {
            WeakReference temp = (WeakReference)i.next();
            if (temp.get() == null) {
                i.remove();
                continue;
            }
            ClientStateListener l = (ClientStateListener)temp.get();
            l.propertyChanged(property, parameter);
        }
    }

    public static InputStreamReader getProperInputStream(InputStream stream) {
        if (ClientState.getClientState().getString("client.encoding", "Platform Default").equals("Platform Default")) {
            return new InputStreamReader(stream);
        }
        try {
            return new InputStreamReader(stream, ClientState.getClientState().getString("client.encoding", "Platform Default"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new InputStreamReader(stream);
        }
    }

    public static PrintStream getProperPrintStream(OutputStream stream) {
        if (ClientState.getClientState().getString("client.encoding", "Platform Default").equals("Platform Default")) {
            return new PrintStream(stream, true);
        }
        try {
            return new PrintStream(stream, true, ClientState.getClientState().getString("client.encoding", "Platform Default"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new PrintStream(stream, true);
        }
    }

    public static File getBaseDirectory() {
        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
            baseDirectory.delete();
            baseDirectory.mkdirs();
        }
        return baseDirectory;
    }

    public static ClientState getClientState() {
        if (clientState == null) {
            clientState = new ClientState();
        }
        return clientState;
    }

    public ClientState() {
        try {
            FileInputStream istream = new FileInputStream(new File(ClientState.getBaseDirectory(), "jirc.prop"));
            this.state.load(istream);
            istream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changes = new HashSet();
    }

    public void backup() {
        this.backup = (Properties)this.state.clone();
        this.changes.clear();
    }

    public void restore() {
        this.state = this.backup;
        this.sync();
        Iterator i = this.changes.iterator();
        while (i.hasNext()) {
            String temp = (String)i.next();
            this.fireChange(temp);
        }
    }

    public void sync() {
        try {
            FileOutputStream ostream = new FileOutputStream(new File(ClientState.getBaseDirectory(), "jirc.prop"));
            this.state.save(ostream, "Java IRC Configuration");
            ostream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Properties getProperties() {
        return this.state;
    }

    public void setString(String key, String value) {
        this.state.setProperty(key, value);
        this.fireChange(key);
    }

    public String getString(String key, String defaultValue) {
        String temp = this.state.getProperty(key);
        if (temp == null || temp.length() == 0) {
            return defaultValue;
        }
        return temp;
    }

    public Rectangle getBounds(String key, Dimension areaSize, Dimension mySize) {
        String temp = this.state.getProperty(key);
        if (temp == null) {
            int x = (int)(areaSize.getWidth() - mySize.getWidth()) / 2;
            int y = (int)(areaSize.getHeight() - mySize.getHeight()) / 2;
            if (x <= 0 || y <= 0) {
                x = 0;
                y = 0;
            }
            return new Rectangle(x, y, (int)mySize.getWidth(), (int)mySize.getHeight());
        }
        String[] values = temp.split("x");
        Rectangle tempr = new Rectangle(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
        return tempr;
    }

    public float getFloat(String key, float defaultValue) {
        String temp = this.state.getProperty(key);
        if (temp == null || temp.length() == 0) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(temp);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public void setFloat(String key, float value) {
        this.setString(key, value + "");
    }

    public int getInteger(String key, int defaultValue) {
        String temp = this.state.getProperty(key);
        if (temp == null || temp.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(temp);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public void setInteger(String key, int value) {
        this.setString(key, value + "");
    }

    public void setOption(String key, boolean value) {
        if (value) {
            this.setString(key, "true");
        } else {
            this.setString(key, "false");
        }
        this.fireChange(key);
    }

    public boolean isOption(String key, boolean defaultBoolean) {
        String temp = this.getString(key, null);
        if (temp == null) {
            return defaultBoolean;
        }
        return temp.equals("true");
    }

    public Color getColor(String key, Color defaultColor) {
        String temp = this.getString(key, null);
        if (temp == null) {
            return defaultColor;
        }
        return Color.decode(temp);
    }

    public void setColor(String key, Color color) {
        this.setString(key, color.getRGB() + "");
    }

    public StringList getStringList(String key) {
        return new StringList(key);
    }

    public boolean isValue(String key, String item) {
        return this.getStringList(key).isValue(item);
    }

    public static File getFile(String filename) {
        return new File(ClientState.getBaseDirectory(), filename);
    }

    public URL getResource(String fileName) {
        return this.getPackagedResource(fileName, "resource");
    }

    public String getHelpString(String topic) {
        topic = topic.replaceAll("\\'", "").replaceAll("\\?", "").replaceAll(" ", "_");
        try {
            String text;
            URL url = this.getPackagedResource(topic, "help");
            if (url == null) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer temp = new StringBuffer();
            while ((text = in.readLine()) != null) {
                temp.append(text);
                temp.append("\n");
            }
            return temp.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public URL getPackagedResource(String fileName, String subDir) {
        try {
            File check = new File(ClientState.getBaseDirectory(), fileName);
            if (check.exists()) {
                return check.toURL();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.getClass().getResource("/" + subDir + "/" + fileName);
    }

    public InputStream getResourceAsStream(String fileName) {
        try {
            File realf = new File(fileName);
            if (realf.exists()) {
                return realf.toURL().openStream();
            }
            File check = new File(ClientState.getBaseDirectory(), fileName);
            if (check.exists()) {
                return check.toURL().openStream();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        URL temp = this.getResource(fileName);
        if (temp == null) {
            return null;
        }
        try {
            return temp.openStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Font getFont(String key, Font defaultValue) {
        String fname = this.getString(key, null);
        if (fname == null) {
            return defaultValue;
        }
        return Font.decode(fname);
    }

    public void setFont(String key, Font value) {
        this.setString(key, ClientUtils.encodeFont(value));
    }

    public ImageIcon getIcon(String key, String defaultResource) {
        String temp = this.getString(key, null);
        if (temp == null) {
            return new ImageIcon(this.getResource(defaultResource));
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(temp));
    }

    public void setBounds(String key, Rectangle value) {
        StringBuffer bounds = new StringBuffer();
        bounds.append((int)value.getX());
        bounds.append('x');
        bounds.append((int)value.getY());
        bounds.append('x');
        bounds.append((int)value.getWidth());
        bounds.append('x');
        bounds.append((int)value.getHeight());
        this.setString(key, bounds.toString());
    }
}

