/*
 * Decompiled with CFR 0.152.
 */
package rero.client.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import rero.bridges.alias.AliasEnvironment;
import rero.bridges.alias.ScriptAlias;
import rero.client.Feature;
import rero.client.user.BuiltInCommands;
import rero.client.user.ClientCommand;
import rero.gui.input.InputListener;
import rero.gui.input.UserInputEvent;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import rero.util.StringParser;

public class UserHandler
extends Feature
implements InputListener {
    protected static Pattern commandParametersPattern = Pattern.compile("/(\\w*)\\s(.*)");
    protected AliasEnvironment scriptedAliases;
    protected HashMap commands = new HashMap();
    protected BuiltInCommands builtInCommands = new BuiltInCommands();
    protected InternalDataList ircData;

    public Collection getScriptedAliases() {
        return this.scriptedAliases.getAliasList();
    }

    public void storeDataStructures(WeakHashMap data) {
        data.put("commands", this);
    }

    public void init() {
        this.scriptedAliases = (AliasEnvironment)this.getCapabilities().getDataStructure("aliasBridge");
        this.ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        LinkedList temp = new LinkedList();
        this.getCapabilities().setupFeature(this.builtInCommands, temp);
        this.getCapabilities().finalizeFeatures(temp);
    }

    public boolean isNickComplete(String text) {
        int colonIndex = text.indexOf(58);
        return colonIndex > -1 && colonIndex == text.indexOf(32) - 1 && ClientUtils.isChannel(this.getQuery());
    }

    public void processNickCompletion(String text) {
        String pnick = text.substring(0, text.indexOf(58));
        text = text.substring(pnick.length() + 1, text.length());
        this.getCapabilities().getChatCapabilities().sendMessage(this.getQuery(), this.ircData.nickComplete(pnick, this.getQuery()) + ":" + text);
    }

    public String getQuery() {
        return this.getCapabilities().getUserInterface().getQuery();
    }

    public void onInput(UserInputEvent ev) {
        if (this.ircData.getMyUser() != null) {
            boolean wasIdle = this.ircData.getMyUser().isIdle();
            this.ircData.getMyUser().touch();
            if (wasIdle) {
                this.getCapabilities().getUserInterface().notifyWindow(this.getQuery());
            }
        }
        if (!ev.isConsumed() && ev.text.length() > 0) {
            this.processInput(ev.text);
        }
    }

    public void processInput(String text) {
        if (text.charAt(0) == '/') {
            this.processCommand(text);
        } else if (this.isNickComplete(text)) {
            this.processNickCompletion(text);
        } else if (this.getQuery().length() > 0 && (this.getCapabilities().isConnected() || this.getQuery().charAt(0) == '=')) {
            this.getCapabilities().getChatCapabilities().sendMessage(this.getQuery(), text);
        }
    }

    public void registerCommand(String name, ClientCommand command) {
        this.commands.put(name, command);
    }

    public void runAlias(String command, String parameters) {
        if (this.scriptedAliases.isAlias(command = command.toUpperCase())) {
            ScriptAlias runme = this.scriptedAliases.getAlias(command);
            runme.runAlias(command, parameters);
            return;
        }
        this.runAliasBuiltIn(command, parameters);
    }

    public void runAliasBuiltIn(String command, String parameters) {
        if (this.commands.get(command) != null) {
            ClientCommand runme = (ClientCommand)this.commands.get(command);
            runme.runAlias(command, parameters);
            return;
        }
        this.builtInCommands.runAlias(command, parameters);
    }

    public void processCommand(String text) {
        String parms;
        String command;
        StringParser parser = new StringParser(text = text.trim(), commandParametersPattern);
        if (parser.matches()) {
            command = parser.getParsedString(0);
            parms = parser.getParsedString(1);
        } else {
            command = text.substring(1, text.length());
            parms = "";
        }
        this.runAlias(command, parms);
    }

    public void processCommandBuiltIn(String text) {
        String parms;
        String command;
        StringParser parser = new StringParser(text = text.trim(), commandParametersPattern);
        if (parser.matches()) {
            command = parser.getParsedString(0);
            parms = parser.getParsedString(1);
        } else {
            command = text.substring(1, text.length());
            parms = "";
        }
        this.runAliasBuiltIn(command, parms);
    }
}

