/*
 * Decompiled with CFR 0.152.
 */
package rero.client.user;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rero.client.Feature;
import rero.client.notify.NotifyData;
import rero.client.output.ChatCapabilities;
import rero.client.script.ScriptManager;
import rero.client.server.ListFilter;
import rero.client.user.ClientCommand;
import rero.config.ClientState;
import rero.config.StringList;
import rero.dialogs.DialogUtilities;
import rero.gui.SessionManager;
import rero.gui.UICapabilities;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChatListener;
import rero.util.ClientUtils;
import rero.util.StringStack;
import rero.util.StringUtils;
import rero.util.TokenizedString;

public class BuiltInCommands
extends Feature
implements ClientCommand {
    public static final int AME = 64921;
    public static final int AWAY = 2022126;
    public static final int BACK = 2030823;
    public static final int BANSTAT = 381185731;
    public static final int CHAT = 2067288;
    public static final int CLEAR = 64208429;
    public static final int CLEARALL = 1572926516;
    public static final int CLOAK = 64218032;
    public static final int CLS = 66826;
    public static final int CPING = 64331829;
    public static final int CTCP = 2078878;
    public static final int CREPLY = 1996016743;
    public static final int CYCLE = 64594118;
    public static final int DEOP = 2094626;
    public static final int DESCRIBE = 1800840907;
    public static final int DEVOICE = -2016999119;
    public static final int DEBUG = 64921139;
    public static final int DH = 2180;
    public static final int DNS = 67849;
    public static final int DO = 2187;
    public static final int DOP = 67877;
    public static final int DV = 2194;
    public static final int EVAL = 2140316;
    public static final int EXEC = 2142353;
    public static final int EXIT = 2142494;
    public static final int HELP = 2213697;
    public static final int HO = 2311;
    public static final int HOP = 71721;
    public static final int IGNORE = -2137067054;
    public static final int INVITE = -2130369783;
    public static final int J = 74;
    public static final int JOIN = 2282794;
    public static final int K = 75;
    public static final int KB = 2391;
    public static final int KICK = 2306630;
    public static final int KILL = 2306910;
    public static final int L = 76;
    public static final int LEAVE = 72308375;
    public static final int LIST = 2336926;
    public static final int LL = 2432;
    public static final int LOAD = 2342118;
    public static final int M = 77;
    public static final int ME = 2456;
    public static final int MODE = 2372003;
    public static final int MSG = 76641;
    public static final int MSGLOG = -2011679709;
    public static final int N = 78;
    public static final int NEWSERVER = -1201786685;
    public static final int NOTICE = -1986360616;
    public static final int NOTIFY = -1986360503;
    public static final int O = 79;
    public static final int OP = 2529;
    public static final int OV = 2535;
    public static final int P = 80;
    public static final int PA = 2545;
    public static final int PART = 2448371;
    public static final int PING = 2455922;
    public static final int QUERY = 77406376;
    public static final int QUIT = 2497103;
    public static final int QUOTE = 77416028;
    public static final int RAW = 80904;
    public static final int REDIR = 77851994;
    public static final int RELOAD = -1881311847;
    public static final int RUN = 81515;
    public static final int SC = 2640;
    public static final int SEND = 2541448;
    public static final int SERVER = -1852497085;
    public static final int ST = 2657;
    public static final int UT = 2719;
    public static final int SM = 2650;
    public static final int SV = 2659;
    public static final int THEME = 79789481;
    public static final int TOPIC = 80008463;
    public static final int TSEND = 80117212;
    public static final int UNBAN = 80888502;
    public static final int UNIGNORE = 478733739;
    public static final int UNLOAD = -1787112705;
    public static final int V = 86;
    public static final int VER = 84867;
    public static final int VOICE = 81848594;
    public static final int WALL = 2656714;
    public static final int WALLEX = -1741862915;
    public static final int WALLOPS = 1836833928;
    public static final int WHOIS = 82569544;
    public static final int WHOLEFT = 2039998629;
    public static final int WI = 2770;
    public static final int WII = 85943;
    public static final int WINDOW = -1734422544;
    public static final int WW = 2784;
    public static final int LAGC = 2328849;
    UICapabilities gui;
    ChatCapabilities chatCommands;
    InternalDataList ircData;

    public void init() {
        this.gui = this.getCapabilities().getUserInterface();
        this.chatCommands = this.getCapabilities().getChatCapabilities();
        this.ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
    }

    public void runAlias(String command, String parms) {
        command = command.toUpperCase();
        TokenizedString tokens = new TokenizedString(parms);
        tokens.tokenize(" ");
        switch (command.hashCode()) {
            case 64921: {
                Iterator i = this.ircData.getMyUser().getChannels().iterator();
                while (i.hasNext()) {
                    this.chatCommands.sendAction(((Channel)i.next()).getName(), parms);
                }
                break;
            }
            case 2022126: {
                this.getCapabilities().sendln("AWAY :" + parms);
                break;
            }
            case 2030823: {
                this.getCapabilities().sendln("AWAY");
                break;
            }
            case 381185731: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = parms;
                }
                this.getCapabilities().sendln("MODE " + target + " +b");
                break;
            }
            case 66826: 
            case 64208429: {
                this.getCapabilities().getUserInterface().clearScreen(parms);
                break;
            }
            case 1572926516: {
                this.getCapabilities().getUserInterface().clearScreen("%ALL%");
                System.gc();
                break;
            }
            case 1996016743: {
                this.getCapabilities().getChatCapabilities().sendReply(tokens.getToken(0), tokens.getToken(1), tokens.getTokenFrom(2));
                break;
            }
            case 2078878: {
                if (tokens.getToken(1).equals("KOW1")) {
                    this.getCapabilities().getGlobalCapabilities().showCoolAbout();
                    return;
                }
                this.getCapabilities().getChatCapabilities().sendRequest(tokens.getToken(0), tokens.getToken(1), tokens.getTokenFrom(2));
                break;
            }
            case 64921139: {
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).setDebug(tokens.getToken(0), tokens.getTokenFrom(1));
                break;
            }
            case 2187: 
            case 67877: 
            case 2094626: {
                String temp = " -";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "o";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target.trim());
                break;
            }
            case -2016999119: 
            case 2194: {
                String temp = " -";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "v";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target);
                break;
            }
            case 2180: {
                String temp = " -";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "h";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target);
                break;
            }
            case 1800840907: {
                this.chatCommands.sendAction(tokens.getToken(0), tokens.getTokenFrom(1));
                break;
            }
            case 67849: {
                User userD = this.ircData.getUser(parms);
                if (userD != null && userD.getAddress().length() > 0) {
                    new Thread(new ResolveHost(userD.getAddress().substring(userD.getAddress().indexOf(64) + 1, userD.getAddress().length()))).start();
                    break;
                }
                new Thread(new ResolveHost(parms)).start();
                break;
            }
            case 81515: 
            case 2142353: {
                Thread athread = new Thread(new QuickProcess(parms));
                athread.start();
                break;
            }
            case 2140316: {
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).evalScript(parms);
                break;
            }
            case 2142494: {
                this.getCapabilities().getGlobalCapabilities().QuitClient();
                break;
            }
            case 2213697: {
                this.getCapabilities().getGlobalCapabilities().showHelpDialog(parms);
                break;
            }
            case 2311: {
                String temp = " +";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "h";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target);
                break;
            }
            case 71721: 
            case 64594118: {
                String target = this.gui.getQuery();
                String keych = "";
                if (this.ircData.getChannel(target).getKey() != null && this.ircData.getChannel(target).getKey().length() > 0) {
                    keych = " " + this.ircData.getChannel(target).getKey();
                }
                this.getCapabilities().sendln("PART " + target);
                this.getCapabilities().sendln("JOIN " + target + keych);
                break;
            }
            case -2137067054: {
                if (parms.length() < 1) break;
                if (!StringUtils.iswm("*!*@*", parms)) {
                    parms = parms + "!*@*";
                }
                StringList templ = ClientState.getClientState().getStringList("ignore.masks");
                templ.add(parms);
                templ.save();
                this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("add", parms), "SET_IGNORE");
                break;
            }
            case -2130369783: {
                if (parms.length() < 1) break;
                String target = this.gui.getQuery();
                if (tokens.getTotalTokens() > 1) {
                    target = tokens.getToken(1);
                }
                this.getCapabilities().sendln("INVITE " + tokens.getToken(0) + " " + target);
                break;
            }
            case 74: 
            case 2282794: {
                if (!ClientUtils.isChannel(parms)) {
                    parms = "#" + parms;
                }
                if (this.ircData.getChannel(parms) != null && this.ircData.isOn(this.ircData.getMyUser(), this.ircData.getChannel(parms))) {
                    this.getCapabilities().getUserInterface().setQuery(parms);
                    break;
                }
                this.getCapabilities().sendln("JOIN " + parms);
                break;
            }
            case 75: {
                String temp = ClientState.getClientState().getString("kick.message", "I know... I'm a \u0002jIRC\u0002");
                String target = this.ircData.nickComplete(tokens.getToken(0), this.gui.getQuery());
                if (tokens.getTotalTokens() > 1) {
                    temp = tokens.getTokenFrom(1);
                }
                this.getCapabilities().sendln("KICK " + this.gui.getQuery() + " " + target + " :" + temp);
                break;
            }
            case 2391: {
                User user;
                String temp = ClientState.getClientState().getString("kick.message", "I know... I'm a \u0002jIRC\u0002");
                String target = this.ircData.nickComplete(tokens.getToken(0), this.gui.getQuery());
                if (tokens.getTotalTokens() > 1) {
                    temp = tokens.getTokenFrom(1);
                }
                if ((user = this.ircData.getUser(target)) != null && user.getAddress().length() > 0) {
                    this.getCapabilities().sendln("MODE " + this.gui.getQuery() + " -o+b " + target + " " + ClientUtils.mask(user.getNick() + "!" + user.getAddress(), 2));
                    this.getCapabilities().sendln("KICK " + this.gui.getQuery() + " " + target + " :" + temp);
                    break;
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + " -o+b " + target + " " + target + "!*@*");
                this.getCapabilities().sendln("KICK " + this.gui.getQuery() + " " + target + " :" + temp);
                break;
            }
            case 2306630: {
                String temp = ClientState.getClientState().getString("kick.message", "I know... I'm a \u0002jIRC\u0002");
                if (tokens.getTotalTokens() > 2) {
                    temp = tokens.getTokenFrom(2);
                }
                this.getCapabilities().sendln("KICK " + tokens.getToken(0) + " " + tokens.getToken(1) + " :" + temp);
                break;
            }
            case 2306910: {
                String temp = ClientState.getClientState().getString("kill.message", "I know... I'm a \u0002jIRC\u0002");
                if (tokens.getTotalTokens() > 1) {
                    temp = tokens.getTokenFrom(1);
                }
                this.getCapabilities().sendln("KILL " + tokens.getToken(0) + " :" + temp);
                break;
            }
            case 2336926: {
                if (tokens.getTotalTokens() == 1) {
                    if (tokens.getToken(0).equals("-gui")) {
                        this.gui.openListWindow();
                    } else {
                        this.getCapabilities().addTemporaryListener(new ListFilter(tokens.getToken(0)));
                    }
                    this.getCapabilities().sendln("LIST");
                    break;
                }
                if (tokens.getTotalTokens() > 1) {
                    this.getCapabilities().sendln("LIST :" + parms);
                    break;
                }
                this.getCapabilities().sendln("LIST");
                break;
            }
            case 2328849: {
                long freememory = Runtime.getRuntime().freeMemory();
                System.gc();
                freememory = Runtime.getRuntime().freeMemory() - freememory;
                System.out.println("Profiler Output:");
                System.out.println("<=================> ");
                System.out.println("Free'd Memory     : " + ClientUtils.formatBytes(freememory));
                break;
            }
            case 2342118: {
                File tempf;
                if (parms.length() == 0 && (tempf = DialogUtilities.showFileDialog("Select a script", "Load", null)) != null) {
                    parms = tempf.getAbsolutePath();
                }
                if (parms == null) break;
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).addScript(parms);
                break;
            }
            case 77: 
            case 76641: {
                this.getCapabilities().getChatCapabilities().sendMessage(tokens.getToken(0), tokens.getTokenFrom(1));
                break;
            }
            case 2456: {
                this.chatCommands.sendAction(this.gui.getQuery(), parms);
                break;
            }
            case 2650: 
            case 2372003: {
                if (tokens.getTotalTokens() == 0) {
                    this.getCapabilities().sendln("MODE " + this.gui.getQuery());
                    break;
                }
                if (tokens.getTotalTokens() == 1) {
                    this.getCapabilities().sendln("MODE " + tokens.getToken(0));
                    break;
                }
                if (tokens.getTotalTokens() == 2) {
                    this.getCapabilities().sendln("MODE " + tokens.getToken(0) + " " + tokens.getToken(1));
                    break;
                }
                this.getCapabilities().sendln("MODE " + tokens.getToken(0) + " " + tokens.getToken(1) + " " + tokens.getTokenFrom(2));
                break;
            }
            case -1986360616: 
            case 78: {
                this.getCapabilities().getChatCapabilities().sendNotice(tokens.getToken(0), tokens.getTokenFrom(1));
                break;
            }
            case -1986360503: {
                if (tokens.getTotalTokens() <= 0) break;
                if (tokens.getTotalTokens() == 1) {
                    ((NotifyData)this.getCapabilities().getDataStructure("notify")).addUser(tokens.getToken(0));
                    this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("add", tokens.getToken(0)), "SET_NOTIFY");
                    break;
                }
                if (tokens.getToken(0).equals("add") && tokens.getTotalTokens() == 2) {
                    ((NotifyData)this.getCapabilities().getDataStructure("notify")).addUser(tokens.getToken(1));
                    this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("add", tokens.getToken(1)), "SET_NOTIFY");
                    break;
                }
                if (!tokens.getToken(0).equals("remove") && !tokens.getToken(1).equals("rem") || tokens.getTotalTokens() != 2) break;
                ((NotifyData)this.getCapabilities().getDataStructure("notify")).removeUser(tokens.getToken(1));
                this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("remove", tokens.getToken(1)), "SET_NOTIFY");
                break;
            }
            case -1201786685: {
                this.getCapabilities().getGlobalCapabilities().createNewServer();
                if (parms.length() <= 0) break;
                SessionManager.getGlobalCapabilities().getActiveSession().executeCommand("/server " + parms);
                break;
            }
            case 79: 
            case 2529: {
                String temp = " +";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "o";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target.trim());
                break;
            }
            case 2545: {
                this.getCapabilities().sendln("JOIN 0");
                break;
            }
            case 76: 
            case 2448371: 
            case 72308375: {
                String target = this.gui.getQuery();
                if (parms.length() > 0 && ClientUtils.isChannel(tokens.getToken(0))) {
                    target = tokens.getToken(0);
                    parms = tokens.getTokenFrom(1);
                }
                if (ClientState.getClientState().isOption("auto.part", true) && this.gui.isWindow(target)) {
                    this.getCapabilities().getUserInterface().closeWindow(target);
                    break;
                }
                this.getCapabilities().sendln("PART " + target + " :" + parms);
                break;
            }
            case 80: 
            case 2455922: 
            case 64331829: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = this.ircData.nickComplete(parms, this.gui.getQuery());
                }
                this.chatCommands.sendRequest(target, "PING", "");
                break;
            }
            case 77406376: {
                if (parms == null || parms.length() == 0) {
                    Set mychs = this.ircData.getMyUser().getChannels();
                    Iterator seti = mychs.iterator();
                    StringBuffer rv = new StringBuffer();
                    while (seti.hasNext()) {
                        rv.append(((Channel)seti.next()).getName());
                        rv.append(" ");
                    }
                    this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("-", rv.toString()), "ON_CHANNELS");
                    break;
                }
                this.getCapabilities().getUserInterface().setQuery(parms);
                break;
            }
            case 80904: 
            case 77416028: {
                this.getCapabilities().sendln(parms);
                break;
            }
            case 2497103: {
                if (parms.length() == 0) {
                    parms = ClientState.getClientState().getString("message.quit", this.ircData.getMyNick() + " has no reason");
                }
                if (!this.getCapabilities().isConnected()) break;
                this.getCapabilities().sendln("QUIT :" + parms);
                this.ircData.reset();
                ((NotifyData)this.getCapabilities().getDataStructure("notify")).reset();
                break;
            }
            case 77851994: {
                break;
            }
            case -1881311847: {
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).reloadScript(parms);
                break;
            }
            case 2640: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = parms;
                }
                this.getCapabilities().sendln("NAMES " + target);
                break;
            }
            case -1852497085: {
                this.connectToServer(parms);
                break;
            }
            case 2657: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = tokens.getToken(0);
                }
                this.getCapabilities().sendln("TOPIC " + target);
                break;
            }
            case 2659: {
                this.chatCommands.sendMessage(this.gui.getQuery(), ClientUtils.ShowVersion());
                break;
            }
            case 79789481: {
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).loadTheme(parms);
                break;
            }
            case 80008463: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = tokens.getToken(0);
                }
                if (tokens.getTotalTokens() > 1) {
                    this.getCapabilities().sendln("TOPIC " + target + " :" + tokens.getTokenFrom(1));
                    break;
                }
                this.getCapabilities().sendln("TOPIC " + target);
                break;
            }
            case 2719: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = tokens.getToken(0);
                }
                this.getCapabilities().sendln("TOPIC " + target + " :");
                break;
            }
            case 80888502: {
                User luser;
                String target = parms.indexOf(33) > -1 ? parms : ((luser = this.ircData.getUser(parms)) != null && luser.getAddress().length() > 0 ? luser.getNick() + "!" + luser.getAddress() : parms + "!*@*");
                this.getCapabilities().addTemporaryListener(new UnbanHandler(target, this.gui.getQuery()));
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + " +b");
                break;
            }
            case 478733739: {
                StringList templw = ClientState.getClientState().getStringList("ignore.masks");
                templw.remove(parms);
                templw.save();
                this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("remove", parms), "SET_IGNORE");
                break;
            }
            case -1787112705: {
                ((ScriptManager)this.getCapabilities().getDataStructure("scriptManager")).removeScript(parms);
                break;
            }
            case 84867: {
                String target = this.gui.getQuery();
                if (parms.length() > 0) {
                    target = this.ircData.nickComplete(parms, this.gui.getQuery());
                }
                this.chatCommands.sendRequest(target, "VERSION", "");
                break;
            }
            case 86: 
            case 81848594: {
                String temp = " +";
                String target = "";
                for (int x = 0; x < tokens.getTotalTokens(); ++x) {
                    target = this.ircData.nickComplete(tokens.getToken(x), this.gui.getQuery()) + " " + target;
                    temp = temp + "v";
                }
                this.getCapabilities().sendln("MODE " + this.gui.getQuery() + temp + " " + target);
                break;
            }
            case 2656714: {
                Set chops = this.ircData.getUsersWithMode(this.gui.getQuery(), 'o');
                chops.remove(this.ircData.getMyUser());
                String[] chopsZ = this.groupUsers(chops);
                for (int z = 0; z < chopsZ.length; ++z) {
                    this.getCapabilities().sendln("NOTICE " + chopsZ[z] + " :[" + '\u0002' + "wall" + '\u0002' + "/" + this.gui.getQuery() + "]: " + parms);
                }
                this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap(this.gui.getQuery(), parms), "SEND_WALL");
                break;
            }
            case -1741862915: {
                HashSet chops2 = new HashSet();
                chops2.addAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'o'));
                chops2.addAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'h'));
                chops2.addAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'v'));
                String[] removeUsers = tokens.getToken(0).split(",");
                for (int y = 0; y < removeUsers.length; ++y) {
                    if (removeUsers[y].equals("@")) {
                        chops2.removeAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'o'));
                        continue;
                    }
                    if (removeUsers[y].equals("+")) {
                        chops2.removeAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'v'));
                        continue;
                    }
                    if (removeUsers[y].equals("%")) {
                        chops2.removeAll(this.ircData.getUsersWithMode(this.gui.getQuery(), 'h'));
                        continue;
                    }
                    removeUsers[y] = this.ircData.nickComplete(removeUsers[y], this.gui.getQuery());
                    chops2.remove(this.ircData.getUser(removeUsers[y]));
                }
                chops2.remove(this.ircData.getMyUser());
                String boozer = BuiltInCommands.joinNicks(removeUsers);
                String[] chopsZZ = this.groupUsers(chops2);
                for (int z = 0; z < chopsZZ.length; ++z) {
                    this.getCapabilities().sendln("NOTICE " + chopsZZ[z] + " :[" + '\u0002' + "wall-x" + '\u0002' + "/" + boozer + "]" + tokens.getTokenFrom(1));
                }
                this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap(boozer, tokens.getTokenFrom(1)), "SEND_WALLEX");
                break;
            }
            case 1836833928: {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap("<ircops>", parms), "SEND_WALLOPS");
                this.getCapabilities().sendln("WALLOPS :" + parms);
                break;
            }
            case 2770: 
            case 82569544: {
                this.getCapabilities().sendln("WHOIS " + parms);
                break;
            }
            case 85943: {
                this.getCapabilities().sendln("WHOIS " + parms + " " + parms);
                break;
            }
            case -1734422544: {
                if (parms.length() == 0) break;
                if (this.getCapabilities().getUserInterface().getQuery().toUpperCase().equals(parms.toUpperCase())) {
                    this.getCapabilities().getOutputCapabilities().cycleQuery();
                }
                if (ClientUtils.isChannel(parms)) {
                    this.gui.openChannelWindow(this.ircData.getChannel(parms));
                    break;
                }
                this.gui.openQueryWindow(parms, true);
                break;
            }
            case 2784: {
                this.getCapabilities().sendln("WHOWAS " + parms);
                break;
            }
            default: {
                this.getCapabilities().sendln(command + " " + parms);
            }
        }
    }

    public void connectToServer(String parms) {
        boolean secure = false;
        String host = "";
        int port = 6667;
        String password = null;
        StringStack stack = new StringStack(parms);
        String temp = stack.pop();
        if (temp.equals("-ssl") || temp.equals("-s")) {
            secure = true;
            temp = stack.pop();
        }
        if (temp.equals("-pass") || temp.equals("-p")) {
            password = stack.pop();
            temp = stack.pop();
        }
        host = temp;
        if (!stack.isEmpty()) {
            port = Integer.parseInt(stack.pop());
        }
        if (this.getCapabilities().isConnected()) {
            this.ircData.reset();
            ((NotifyData)this.getCapabilities().getDataStructure("notify")).reset();
            this.getCapabilities().sendln("QUIT :switching servers");
        }
        this.getCapabilities().getSocketConnection().connect(host, port, 0L, password, secure);
        this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(host, host + " " + port + " " + password + " " + secure), "IRC_ATTEMPT_CONNECT");
    }

    private String[] groupUsers(Set users) {
        StringBuffer rv = new StringBuffer();
        int x = 1;
        Iterator i = users.iterator();
        while (i.hasNext()) {
            String temp = ((User)i.next()).getNick();
            rv.append(temp);
            if (x % 4 == 0 && x > 1) {
                rv.append("=");
            } else {
                rv.append(",");
            }
            ++x;
        }
        if (rv.toString().length() > 1) {
            return rv.toString().substring(0, rv.toString().length() - 1).split("=");
        }
        return new String[0];
    }

    private static String joinNicks(String[] stuff) {
        StringBuffer temp = new StringBuffer();
        for (int x = 0; x < stuff.length; ++x) {
            temp.append(stuff[x]);
            if (x + 1 >= stuff.length) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    private class UnbanHandler
    implements ChatListener {
        protected String channel;
        protected String target;

        public UnbanHandler(String _target, String _channel) {
            this.target = _target.toUpperCase();
            this.channel = _channel.toUpperCase();
        }

        public boolean isChatEvent(String event, HashMap eventId) {
            return event.equals("367") || event.equals("368");
        }

        public int fireChatEvent(HashMap eventDescription) {
            if (eventDescription.get("$event").toString().equals("368")) {
                return 6;
            }
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            if (data.getToken(0).toUpperCase().equals(this.channel) && StringUtils.iswm(data.getToken(1).toUpperCase(), this.target)) {
                BuiltInCommands.this.getCapabilities().sendln("MODE " + this.channel + " -b " + data.getToken(1));
            }
            return 2;
        }
    }

    private class ResolveHost
    implements Runnable {
        private String host;

        public ResolveHost(String _host) {
            this.host = _host;
        }

        public void run() {
            try {
                InetAddress info = InetAddress.getByName(this.host);
                HashMap<String, String> eventDescription = new HashMap<String, String>();
                eventDescription.put("$data", this.host + " " + info.getHostAddress() + " " + info.getHostName());
                eventDescription.put("$parms", info.getHostAddress() + " " + info.getHostName());
                BuiltInCommands.this.getCapabilities().getOutputCapabilities().fireSetActive(eventDescription, "RESOLVED_HOST");
            }
            catch (UnknownHostException ex) {
                HashMap<String, String> eventDescription = new HashMap<String, String>();
                eventDescription.put("$data", this.host);
                eventDescription.put("$parms", "");
                BuiltInCommands.this.getCapabilities().getOutputCapabilities().fireSetActive(eventDescription, "RESOLVED_HOST");
            }
        }
    }

    private class QuickProcess
    implements Runnable {
        private Process process;
        private BufferedReader reader = null;
        private String command;

        public QuickProcess(String parms) {
            this.command = parms;
        }

        public void run() {
            try {
                String data;
                this.process = Runtime.getRuntime().exec(this.command);
                this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                while ((data = this.reader.readLine()) != null) {
                    BuiltInCommands.this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("process", data), "PROCESS_DATA");
                }
            }
            catch (Exception ex) {
                BuiltInCommands.this.getCapabilities().getOutputCapabilities().fireSetActive(ClientUtils.getEventHashMap("error", ex.getMessage()), "PROCESS_DATA");
            }
        }
    }
}

