/*
 * Decompiled with CFR 0.152.
 */
package rero.client.server;

import java.util.HashMap;
import java.util.Iterator;
import rero.client.Feature;
import rero.client.notify.NotifyData;
import rero.client.server.IgnoreHandler;
import rero.config.ClientState;
import rero.ident.IdentDaemon;
import rero.ident.IdentListener;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.net.SocketConnection;
import rero.net.SocketEvent;
import rero.net.interfaces.SocketStatusListener;
import rero.test.QuickConnect;
import rero.util.ClientUtils;

public class ServerHandler
extends Feature
implements FrameworkConstants,
SocketStatusListener,
ChatListener,
IdentListener {
    protected NotifyData notify;
    protected InternalDataList data;
    protected SocketConnection socket;
    protected User restoreInformation = null;
    protected String restoreServer;
    protected IgnoreHandler ignoreHandler;
    protected NickInUseListener nickListener = null;

    public void init() {
        this.getCapabilities().getChatFramework().getProtocolDispatcher().setInternalListener(this);
        this.getCapabilities().getSocketConnection().addSocketStatusListener(this);
        this.socket = this.getCapabilities().getSocketConnection();
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.notify = (NotifyData)this.getCapabilities().getDataStructure("notify");
        this.ignoreHandler = new IgnoreHandler();
        IdentDaemon.getIdentDaemon().addIdentListener(this);
    }

    public void identRequest(String host, String text) {
        this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(host, text), "IDENT_REQUEST");
    }

    public void cleanup() {
        this.data.reset();
        this.notify.reset();
        this.data.setMyNick("<Unknown>");
        this.restoreInformation = null;
    }

    public int fireChatEvent(HashMap eventDescription) {
        String event = (String)eventDescription.get("$event");
        if (event.equals("376")) {
            if (this.restoreInformation != null) {
                Iterator i = this.restoreInformation.getChannels().iterator();
                while (i.hasNext()) {
                    Channel temp = (Channel)i.next();
                    this.getCapabilities().sendln("JOIN " + temp.getName() + " :" + temp.getKey());
                }
                this.restoreInformation = null;
            }
            return 1;
        }
        if (event.equals("PING")) {
            this.getCapabilities().sendln("PONG :" + eventDescription.get("$parms"));
            return 2;
        }
        if (this.ignoreHandler.isIgnore((String)eventDescription.get("$nick"), (String)eventDescription.get("$address"))) {
            return 2;
        }
        return 1;
    }

    public boolean isChatEvent(String eventId, HashMap eventDescription) {
        if (this.ignoreHandler.isCheckingIgnore() && (eventId.equals("NOTICE") || eventId.equals("PRIVMSG") || eventId.equals("REPLY") || eventId.equals("REQUEST") || eventId.equals("ACTION"))) {
            return true;
        }
        if (eventId.equals("376")) {
            return true;
        }
        return eventId.equals("PING");
    }

    public void socketStatusChanged(SocketEvent ev) {
        if (ev.data.isConnected) {
            String nick;
            String user;
            this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(ev.data.hostname, "connected"), "IRC_CONNECT");
            String[] parms = ClientState.getClientState().getString("user.email", "jircii@127.0.0.1").split("@");
            if (parms.length == 1 && (parms = new String[]{parms[0], "127.0.0.1"})[0].length() == 0) {
                parms[0] = "jircii";
            }
            if (ev.data.password != null) {
                this.getCapabilities().sendln("PASS " + ev.data.password);
            }
            if (QuickConnect.IsQuickConnect()) {
                user = ClientState.getClientState().getString("user.rname", "jIRCii Web User: http://jircii.hick.org/");
                nick = ClientState.getClientState().getString("user.nick", QuickConnect.GetInformation().getNickname());
            } else if (System.currentTimeMillis() % 5L == 0L) {
                user = ClientState.getClientState().getString("user.rname", "I'm to lame to read mIRC.hlp");
                nick = ClientState.getClientState().getString("user.nick", "madgoat");
            } else {
                user = ClientState.getClientState().getString("user.rname", ClientUtils.tagline());
                nick = ClientState.getClientState().getString("user.nick", "IRCFrEAK");
            }
            if (this.restoreInformation != null) {
                nick = this.restoreInformation.getNick();
            }
            this.getCapabilities().sendln("USER " + parms[0] + " " + parms[1] + " " + parms[1] + " :" + user);
            this.getCapabilities().sendln("NICK " + nick);
            if (this.nickListener == null || !this.nickListener.isArmed()) {
                this.nickListener = new NickInUseListener();
                this.getCapabilities().addTemporaryListener(this.nickListener);
            }
        } else {
            boolean isDone = false;
            this.getCapabilities().getOutputCapabilities().fireSetAll(ClientUtils.getEventHashMap(ev.data.hostname, ev.message), "IRC_DISCONNECT");
            if (this.data.getMyUser().getChannels().size() > 0 && ClientState.getClientState().isOption("option.reconnect", true)) {
                System.out.println("Reconnecting is an option");
                this.restoreInformation = this.data.getMyUser().copy();
                this.restoreServer = ev.data.hostname;
                this.getCapabilities().getOutputCapabilities().fireSetAll(ClientUtils.getEventHashMap(ev.data.hostname, ev.message), "IRC_RECONNECT");
                this.getCapabilities().getGlobalCapabilities().setTabTitle(this.getCapabilities(), "reconnecting");
                this.socket.connect(ev.data.hostname, ev.data.port, ClientState.getClientState().getInteger("reconnect.time", 5) * 1000, ev.data.password, ev.data.isSecure);
                isDone = true;
            }
            this.data.reset();
            this.notify.reset();
            this.data.setMyNick("<Unknown>");
            if (this.restoreInformation != null && !isDone) {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(ClientUtils.getEventHashMap(ev.data.hostname, ev.message), "IRC_RECONNECT");
                this.getCapabilities().getGlobalCapabilities().setTabTitle(this.getCapabilities(), "reconnecting");
                this.socket.connect(ev.data.hostname, ev.data.port, ClientState.getClientState().getInteger("reconnect.time", 5) * 1000, ev.data.password, ev.data.isSecure);
            }
        }
    }

    protected class NickInUseListener
    implements ChatListener {
        protected String altNick = ClientState.getClientState().getString("user.altnick", "lamer" + System.currentTimeMillis());
        protected boolean armed = true;

        protected NickInUseListener() {
        }

        public boolean isChatEvent(String event, HashMap data) {
            return event.equals("001") || event.equals("433");
        }

        public boolean isArmed() {
            return this.armed;
        }

        public int fireChatEvent(HashMap desc) {
            String event = (String)desc.get("$event");
            if (event.equals("433")) {
                if (QuickConnect.IsQuickConnect() && QuickConnect.GetInformation().getURL().getUserInfo() != null) {
                    this.altNick = ClientState.getClientState().getString("user.nick", QuickConnect.GetInformation().getNickname()) + System.currentTimeMillis();
                }
                ServerHandler.this.getCapabilities().sendln("NICK " + this.altNick);
            }
            this.armed = false;
            return 5;
        }
    }
}

