/*
 * Decompiled with CFR 0.152.
 */
package rero.client.server;

import java.util.HashMap;
import rero.client.Feature;
import rero.client.output.OutputCapabilities;
import rero.client.server.SyncCheck;
import rero.client.server.UpdateIAL;
import rero.config.ClientState;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.ircfw.interfaces.ChannelDataWatch;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.TokenizedString;

public class ProcessEvents
extends Feature
implements FrameworkConstants,
ChatListener {
    protected InternalDataList ircData;
    protected OutputCapabilities output;
    protected SyncCheck syncs = new SyncCheck();
    private ChatListener allowAway = new AllowAwayReply();

    public void init() {
        this.output = this.getCapabilities().getOutputCapabilities();
        this.ircData = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.getCapabilities().addChatListener(this);
    }

    public int fireChatEvent(HashMap eventDescription) {
        String target = (String)eventDescription.get("$target");
        String nick = (String)eventDescription.get("$nick");
        String channel = (String)eventDescription.get("$target");
        String event = (String)eventDescription.get("$event");
        if (event.equals("PRIVMSG")) {
            if (ClientUtils.isChannel(target)) {
                this.output.fireSetTarget(eventDescription, channel, this.output.chooseSet(channel, "CHANNEL_TEXT", "CHANNEL_TEXT_INACTIVE"));
                this.touchUser(nick, target);
            } else {
                if (ClientState.getClientState().isOption("auto.query", true)) {
                    boolean isSelected = !ClientState.getClientState().isOption("auto.hide", true);
                    this.getCapabilities().getUserInterface().openQueryWindow(nick, isSelected);
                }
                this.output.fireSetQuery(eventDescription, nick, target, "PRIVMSG");
            }
        } else if (event.equals("MODE")) {
            if (ClientUtils.isChannel(target)) {
                this.output.fireSetTarget(eventDescription, channel, "CHANNEL_MODE");
                this.getCapabilities().getUserInterface().notifyWindow(channel);
            } else {
                this.output.fireSetTarget(eventDescription, nick, "USER_MODE");
                this.getCapabilities().getUserInterface().notifyWindow(nick);
            }
        } else if (event.equals("NOTICE")) {
            if (nick == null || nick.length() == 0) {
                this.output.fireSetStatus(eventDescription, "NOTICE");
            } else if (ClientUtils.isChannel(target) || ClientState.getClientState().isOption("active.notice", true)) {
                this.output.fireSetConfused(eventDescription, target, "notice", "NOTICE");
            } else {
                this.output.fireSetAllTarget2(eventDescription, nick, "NOTICE");
            }
        } else if (event.equals("ACTION")) {
            if (ClientUtils.isChannel(target)) {
                this.output.fireSetTarget(eventDescription, channel, this.output.chooseSet(channel, "ACTION", "ACTION_INACTIVE"));
                this.touchUser(nick, target);
            } else {
                if (ClientState.getClientState().isOption("auto.query", true)) {
                    boolean isSelected = !ClientState.getClientState().isOption("auto.hide", true);
                    this.getCapabilities().getUserInterface().openQueryWindow(nick, isSelected);
                }
                this.output.fireSetTarget(eventDescription, nick, "PRIVACTION");
            }
        } else if (event.equals("JOIN")) {
            if (eventDescription.get("$nick").equals(this.ircData.getMyNick())) {
                this.syncs.addChannel(channel.toString().toLowerCase());
                this.getCapabilities().sendln("MODE " + channel.toString());
                if (ClientState.getClientState().isOption("update.ial", true)) {
                    UpdateIAL checkIAL = new UpdateIAL();
                    this.getCapabilities().addTemporaryListener(checkIAL);
                    this.getCapabilities().sendln("WHO " + channel.toString());
                }
                if (ClientState.getClientState().isOption("auto.join", true)) {
                    this.getCapabilities().getUserInterface().openChannelWindow(this.ircData.getChannel(channel));
                } else {
                    this.getCapabilities().getUserInterface().setQuery(channel.toString());
                }
            }
            this.output.fireSetTarget(eventDescription, channel, "CHANNEL_JOIN");
        } else if (event.equals("KICK")) {
            if (eventDescription.get("$nick").equals(this.ircData.getMyNick())) {
                this.output.cycleQuery();
            }
            this.output.fireSetTarget(eventDescription, channel, "CHANNEL_KICK");
        } else if (event.equals("PART")) {
            if (eventDescription.get("$nick").equals(this.ircData.getMyNick())) {
                this.output.cycleQuery();
            }
            if (!ClientState.getClientState().isOption("auto.part", true) || !ClientState.getClientState().isOption("auto.join", true) || this.getCapabilities().getUserInterface().isWindow(channel)) {
                this.output.fireSetTarget(eventDescription, channel, "CHANNEL_PART");
            }
        } else if (event.equals("QUIT")) {
            this.output.fireSetAllDeadTarget(eventDescription, nick, "USER_QUIT");
        } else if (event.equals("NICK")) {
            this.getCapabilities().getUserInterface().notifyActiveWindow();
            if (eventDescription.containsKey("$parms")) {
                this.output.fireSetAllTarget(eventDescription, eventDescription.get("$parms").toString(), "USER_NICK");
            }
            if (this.getCapabilities().getUserInterface().isWindow(nick)) {
                this.getCapabilities().getUserInterface().renameWindow(nick, eventDescription.get("$parms").toString());
            }
        } else if (event.equals("TOPIC")) {
            this.output.fireSetTarget(eventDescription, channel, "CHANNEL_TOPIC_CHANGED");
            this.getCapabilities().getUserInterface().notifyWindow(channel);
            this.touchUser(nick, target);
        } else if (event.equals("SIGNON")) {
            this.output.fireSetConfused(eventDescription, null, "notify", "NOTIFY_SIGNON");
        } else if (event.equals("SIGNOFF")) {
            this.output.fireSetConfused(eventDescription, null, "notify", "NOTIFY_SIGNOFF");
        } else if (event.equals("REQUEST")) {
            String type = (String)eventDescription.get("$type");
            if (type.equals("VERSION")) {
                this.getCapabilities().sendln("NOTICE " + nick + " :" + '\u0001' + "VERSION " + ClientUtils.ShowVersion() + '\u0001');
            }
            if (type.equals("PING")) {
                this.getCapabilities().sendln("NOTICE " + nick + " :" + '\u0001' + eventDescription.get("$parms") + '\u0001');
            }
            if (type.equals("CLIENTINFO")) {
                this.getCapabilities().sendln("NOTICE " + nick + " :" + '\u0001' + "CLIENTINFO ACTION CLIENTINFO DCC PING SOURCE TIME VERSION" + '\u0001');
            }
            if (type.equals("SOURCE")) {
                this.getCapabilities().sendln("NOTICE " + nick + " :" + '\u0001' + "SOURCE http://jircii.dashnine.org" + '\u0001');
            }
            if (type.equals("TIME")) {
                this.getCapabilities().sendln("NOTICE " + nick + " :" + '\u0001' + "TIME " + ClientUtils.TimeDateStamp(System.currentTimeMillis() / 1000L) + '\u0001');
            }
            if (type.equals("DCC")) {
                this.output.fireSetConfused(eventDescription, target, "ctcp", "DCC_REQUEST");
            } else {
                this.output.fireSetConfused(eventDescription, target, "ctcp", "CTCP_REQUEST");
            }
        } else if (event.equals("CHAT_OPEN")) {
            nick = "=" + eventDescription.get("$nick");
            if (ClientState.getClientState().isOption("auto.chat", true)) {
                boolean isSelected = !ClientState.getClientState().isOption("auto.hide", true);
                this.getCapabilities().getUserInterface().openQueryWindow(nick, isSelected);
            }
            this.output.fireSetTarget(eventDescription, nick, "CHAT_OPEN");
        } else if (event.equals("CHAT")) {
            nick = "=" + eventDescription.get("$nick");
            this.output.fireSetTarget(eventDescription, nick, "CHATMSG");
        } else if (event.equals("ERROR")) {
            this.output.fireSetAll(eventDescription, "SERVER_ERROR");
        } else if (event.equals("CHAT_CLOSE")) {
            nick = "=" + eventDescription.get("$nick");
            if (!ClientState.getClientState().isOption("auto.chatclose", true) || this.getCapabilities().getUserInterface().isWindow(nick)) {
                this.output.fireSetTarget(eventDescription, nick, "CHAT_CLOSE");
            }
        } else if (event.equals("SEND_FAILED") || event.equals("RECEIVE_FAILED") || event.equals("SEND_COMPLETE") || event.equals("RECEIVE_COMPLETE") || event.equals("SEND_START") || event.equals("RECEIVE_START")) {
            this.output.fireSetConfused(eventDescription, nick, "ctcp", event);
            this.getCapabilities().getUserInterface().notifyActiveWindow();
        } else if (event.equals("REPLY")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            if (data.getToken(0).equals("PING") && data.getTotalTokens() > 1) {
                try {
                    long temp = Long.parseLong(data.getToken(1));
                    eventDescription.put("$pt", ClientUtils.formatLongAsDecimal(System.currentTimeMillis() - temp) + "s");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.output.fireSetConfused(eventDescription, (String)eventDescription.get("$target"), "reply", "CTCP_REPLY");
        } else if (event.equals("INVITE")) {
            this.output.fireSetActive(eventDescription, "INVITE");
        } else if (event.equals("329") && this.output.isSet("CHANNEL_CREATED")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            eventDescription.put("$created", ClientUtils.TimeDateStamp(Long.parseLong(data.getToken(1))));
            this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_CREATED");
        } else if (event.equals("324")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            channel = data.getToken(0);
            if (this.syncs.isSyncing(channel.toLowerCase())) {
                eventDescription.put("$sync", ClientUtils.formatLongAsDecimal(this.syncs.getSyncTime(channel.toLowerCase())));
                this.output.fireSetTarget(eventDescription, channel, "JOIN_SYNC");
            } else if (this.output.isSet("CHANNEL_MODE_IS")) {
                eventDescription.put("$parms", data.getTokenFrom(1));
                eventDescription.put("$data", data.getTokenFrom(0));
                this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_MODE_IS");
            } else {
                this.processNumeric("324", eventDescription);
            }
            this.getCapabilities().getUserInterface().notifyWindow(channel);
        } else if ((event.equals("332") || event.equals("331")) && this.output.isSet("CHANNEL_TOPIC_IS")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            eventDescription.put("$parms", data.getTokenFrom(1));
            eventDescription.put("$data", data.getTokenFrom(0));
            this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_TOPIC_IS");
        } else if (event.equals("333") && this.output.isSet("CHANNEL_TOPIC_SETBY")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            eventDescription.put("$seton", ClientUtils.TimeDateStamp(Long.parseLong(data.getToken(2))));
            nick = data.getToken(1);
            if (nick.indexOf(33) > -1) {
                nick = nick.substring(0, nick.indexOf(33));
            }
            eventDescription.put("$nick", nick);
            this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_TOPIC_SETBY");
        } else if (event.equals("353") && this.output.isSet("CHANNEL_NAMES")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            this.output.fireSetTarget(eventDescription, data.getToken(1), "CHANNEL_NAMES");
        } else if (event.equals("353") && this.output.isSet("FORMATTED_NAMES")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            eventDescription.put("$total", data.getTotalTokens() - 2 + "");
            this.output.fireSetTarget(eventDescription, data.getToken(1), "FORMATTED_NAMES_HEADER");
            if (data.getTotalTokens() < 3 || data.getToken(2).equals(":")) {
                return 0;
            }
            String[] names = new String[data.getTotalTokens() - 2];
            for (int x = 0; x < names.length; ++x) {
                char n = data.getToken(x + 2).charAt(0);
                if (this.ircData.getPrefixInfo().isPrefixChar(n)) {
                    eventDescription.put("$nick", data.getToken(x + 2).substring(1, data.getToken(x + 2).length()));
                } else {
                    eventDescription.put("$nick", data.getToken(x + 2));
                }
                names[x] = this.output.parseSet(eventDescription, "FORMATTED_NAMES");
            }
            this.output.echo(data.getToken(1), names, 0.85);
        } else if (event.equals("367") && this.output.isSet("CHANNEL_BANLIST")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_BANLIST");
        } else if (event.equals("368") && this.output.isSet("CHANNEL_BANLIST_END")) {
            TokenizedString data = new TokenizedString((String)eventDescription.get("$parms"));
            data.tokenize(" ");
            this.output.fireSetTarget(eventDescription, data.getToken(0), "CHANNEL_BANLIST_END");
        } else if (!event.equals("375") && !event.equals("376") && !event.equals("372") || ClientState.getClientState().isOption("option.showmotd", true)) {
            if (eventDescription.get("$numeric") != null) {
                String numeric = (String)eventDescription.get("$numeric");
                this.processNumeric(numeric, eventDescription);
            } else {
                this.output.fireSetStatus(eventDescription, event);
            }
        }
        return 0;
    }

    public void processNumeric(String numeric, HashMap eventDescription) {
        int temp = Integer.parseInt(numeric);
        String type = "NUMERIC";
        if (this.output.isSet("REPL_" + numeric)) {
            type = "REPL_" + numeric;
        }
        if (ProcessEvents.isWhoisNumeric(temp)) {
            if (!this.allowAway.isChatEvent(numeric, eventDescription) || this.allowAway.fireChatEvent(eventDescription) != 2) {
                this.output.fireSetConfused(eventDescription, null, "whois", type);
            }
        } else {
            this.output.fireSetStatus(eventDescription, type);
        }
    }

    public boolean isChatEvent(String eventId, HashMap eventDescription) {
        return true;
    }

    private static boolean isWhoisNumeric(int x) {
        return x >= 311 && x < 321 || x == 338 || x == 369 || x == 301 || x == 302 || x == 307 || x == 308 || x == 330 || x == 401 || x == 406 || x == 378 || x == 379 || x == 310 || x == 671 || x == 703;
    }

    private void touchUser(String nick, String channel) {
        ChannelDataWatch temp;
        User user = this.ircData.getUser(nick);
        boolean wasIdle = user.isIdle();
        user.touch();
        if (wasIdle && this.ircData.getChannel(channel) != null && (temp = this.ircData.getChannelDataWatch(this.ircData.getChannel(channel))) != null) {
            temp.userChanged();
        }
    }

    private static class AllowAwayReply
    implements ChatListener {
        private boolean awayIsGood = false;

        private AllowAwayReply() {
        }

        public boolean isChatEvent(String eventId, HashMap eventDescription) {
            return eventId.equals("301") || eventId.equals("311") || eventId.equals("318");
        }

        public int fireChatEvent(HashMap desc) {
            if ("311".equals(desc.get("$event"))) {
                this.awayIsGood = true;
            }
            if ("318".equals(desc.get("$event"))) {
                this.awayIsGood = false;
            }
            if ("301".equals(desc.get("$event")) && !this.awayIsGood) {
                return 2;
            }
            return 1;
        }
    }
}

