/*
 * Decompiled with CFR 0.152.
 */
package rero.client.script;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.util.ClientUtils;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.SyntaxError;
import sleep.error.YourCodeSucksException;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;

public class ScriptManager
extends Feature
implements ClientStateListener,
RuntimeWarningWatcher {
    protected ScriptLoader loader;
    protected Hashtable environment;
    protected boolean lock = false;
    private static boolean SILENT = false;
    private static boolean lame = true;
    private static final Pattern ENCODING_IN_FILE = Pattern.compile(".*\\.(.*?)\\..*$");
    private static final Pattern ENCODING_IN_EXTENSION = Pattern.compile(".*\\.(.*)$");
    private static SortedMap charsets = null;

    public void init() {
        this.loader = (ScriptLoader)this.getCapabilities().getDataStructure("scriptLoader");
        this.environment = (Hashtable)this.getCapabilities().getDataStructure("sharedEnvironment");
        ClientState.getClientState().addClientStateListener("script.files", this);
    }

    public void storeDataStructures(WeakHashMap data) {
        data.put("scriptManager", this);
    }

    public void hashScripts() {
        String tt;
        if (this.lock) {
            return;
        }
        LinkedHashSet configured = new LinkedHashSet();
        configured.addAll(ClientState.getClientState().getStringList("script.files").getList());
        Set load = this.loader.getScriptsToLoad(configured);
        Set unload = this.loader.getScriptsToUnload(configured);
        load.remove("menus");
        load.remove("default");
        load.remove("lame");
        unload.remove("menus");
        unload.remove("lame");
        unload.remove("default");
        Iterator i = unload.iterator();
        while (i.hasNext()) {
            tt = (String)i.next();
            this.loader.unloadScript(tt);
            if (!ClientState.getClientState().isOption("script.verboseLoad", true)) continue;
            this.getCapabilities().getUserInterface().printStatus("Successfully unloaded script " + tt);
        }
        i = load.iterator();
        while (i.hasNext()) {
            tt = (String)i.next();
            if (this.loader.isLoaded(tt)) continue;
            this.internalScriptLoad(tt);
        }
    }

    public void loadTheme(String filename) {
        if (new File(filename = ClientUtils.getFile(filename).getAbsolutePath()).exists()) {
            this.internalScriptLoad(filename);
            this.loader.unloadScript(filename);
        } else {
            this.getCapabilities().getUserInterface().printStatus("Error loading script: " + new File(filename).getAbsolutePath() + " does not exist");
        }
    }

    public void addScript(String filename) {
        if (new File(filename = ClientUtils.getFile(filename).getAbsolutePath()).exists()) {
            StringList temp = ClientState.getClientState().getStringList("script.files");
            String fn = ClientUtils.getFile(filename).getAbsolutePath();
            if (!temp.getList().contains(fn)) {
                temp.add(fn);
                temp.save();
                ClientState.getClientState().sync();
            } else {
                this.getCapabilities().getUserInterface().printStatus("Script file " + fn + " is already loaded.  Grabbing a beer instead");
            }
        } else {
            this.getCapabilities().getUserInterface().printStatus("Error loading script: " + new File(filename).getAbsolutePath() + " does not exist");
        }
    }

    public void evalScript(String code) {
        try {
            this.getCapabilities().getUserInterface().printActive(((ScriptInstance)this.loader.getScripts().getFirst()).getScriptEnvironment().evaluateExpression(code).toString());
        }
        catch (YourCodeSucksException ex) {
            this.formatCodeException("/eval input", ex);
        }
    }

    public void setDebug(String filename, String debuglevel) {
        Iterator i = this.findScripts(filename, ClientState.getClientState().getStringList("script.files").getList()).iterator();
        while (i.hasNext()) {
            String scriptf = (String)i.next();
            this.setDebugReal(scriptf, debuglevel);
        }
    }

    private void setDebugReal(String filename, String debuglevel) {
        ScriptInstance script = (ScriptInstance)this.loader.getScriptsByKey().get(filename);
        if (script == null) {
            this.getCapabilities().getUserInterface().printStatus("Could not find script " + filename + " to set debug level");
            return;
        }
        int debug = script.getDebugFlags();
        if (debuglevel.indexOf("+trace") > -1) {
            debug |= 8;
        }
        if (debuglevel.indexOf("-trace") > -1) {
            debug &= 0xFFFFFFF7;
        }
        if (debuglevel.indexOf("-warn") > -1) {
            debug &= 0xFFFFFFFD;
        }
        if (debuglevel.indexOf("+warn") > -1) {
            debug |= 2;
        }
        if (debuglevel.indexOf("+all") > -1) {
            debug = debug | 2 | 8;
        }
        if (debuglevel.indexOf("-all") > -1) {
            debug = debug & 0xFFFFFFFD & 0xFFFFFFF7;
        }
        script.setDebugFlags(debug);
        this.getCapabilities().getUserInterface().printStatus("*** Updated debug flags for " + filename);
    }

    public String evalString(String code) {
        try {
            return ((ScriptInstance)this.loader.getScripts().getFirst()).getScriptEnvironment().evaluateExpression(code).toString();
        }
        catch (YourCodeSucksException ex) {
            this.formatCodeException("/eval input", ex);
            return code;
        }
    }

    public void reloadScript(String filename) {
        boolean flag = true;
        Iterator i = this.findScripts(filename, ClientState.getClientState().getStringList("script.files").getList()).iterator();
        while (i.hasNext()) {
            flag = false;
            String scriptf = (String)i.next();
            this.removeScript(scriptf);
            this.addScript(scriptf);
        }
        if (flag) {
            this.getCapabilities().getUserInterface().printStatus("Error (re)loading script: " + filename + " isn't loaded");
        }
    }

    private LinkedList findScripts(String filename, LinkedList theList) {
        LinkedList<String> goodBye = new LinkedList<String>();
        Iterator i = theList.iterator();
        while (i.hasNext()) {
            File temp = new File((String)i.next());
            if (!temp.getName().equals(filename) && !temp.getAbsolutePath().equals(filename)) continue;
            goodBye.add(temp.getAbsolutePath());
        }
        return goodBye;
    }

    public void removeScript(String filename) {
        StringList temp = ClientState.getClientState().getStringList("script.files");
        Iterator i = this.findScripts(filename, temp.getList()).iterator();
        while (i.hasNext()) {
            String remMe = (String)i.next();
            temp.remove(remMe);
        }
        temp.save();
        ClientState.getClientState().sync();
    }

    public void loadLameScripts() {
        try {
            if (lame) {
                ScriptInstance defaults = this.loader.loadScript("lame", ClientState.getClientState().getResourceAsStream("lame.irc"), this.environment);
                defaults.addWarningWatcher(this);
                defaults.runScript();
                lame = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadScripts() {
        try {
            ScriptInstance defaults;
            long start;
            if (ClientState.getClientState().isOption("load.default", true)) {
                start = System.currentTimeMillis();
                defaults = this.loader.loadScript("default", ClientState.getClientState().getResourceAsStream("default.irc"), this.environment);
                defaults.addWarningWatcher(this);
                defaults.runScript();
            }
            if (ClientState.getClientState().isOption("load.menus", true)) {
                start = System.currentTimeMillis();
                defaults = this.loader.loadScript("menus", ClientState.getClientState().getResourceAsStream("menus.irc"), this.environment);
                defaults.addWarningWatcher(this);
                defaults.runScript();
            }
            if (ClientState.getClientState().isOption("load.lame", false)) {
                this.loadLameScripts();
            }
        }
        catch (YourCodeSucksException ex) {
            this.formatCodeException("<Internal Scripts>", ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Iterator i = ClientState.getClientState().getStringList("script.files").getList().iterator();
        while (i.hasNext()) {
            this.internalScriptLoad((String)i.next());
        }
    }

    public void propertyChanged(String name, String value) {
        this.hashScripts();
    }

    private void internalScriptLoad(String scriptFile) {
        try {
            String charset = this.guessCharsetFromFileName(scriptFile);
            boolean charsetConversions = this.loader.isCharsetConversions();
            String oldcharset = this.loader.getCharset();
            if (charset != null) {
                this.loader.setCharsetConversion(true);
                this.loader.setCharset(charset);
            }
            ScriptInstance scripti = this.loader.loadScript(scriptFile, this.environment);
            if (charset != null) {
                this.loader.setCharsetConversion(charsetConversions);
                this.loader.setCharset(oldcharset);
            }
            scripti.addWarningWatcher(this);
            if (ClientState.getClientState().isOption("script.verboseLoad", true)) {
                this.getCapabilities().getUserInterface().printStatus("Successfully loaded script " + new File(scriptFile).getName());
            }
            scripti.runScript();
        }
        catch (YourCodeSucksException ex) {
            this.formatCodeException(scriptFile, ex);
            this.lock = true;
            this.removeScript(scriptFile);
            this.lock = false;
        }
        catch (IOException ex2) {
            this.getCapabilities().getUserInterface().printStatus("Error loading " + new File(scriptFile).getName() + ": " + ex2.getMessage());
        }
        catch (Exception ex3) {
            this.getCapabilities().getUserInterface().printStatus("Error loading " + new File(scriptFile).getName() + ": " + ex3.getMessage() + " <-- could be a sleep bug, please report :)");
            ex3.printStackTrace();
        }
    }

    private String guessCharsetFromFileName(String scriptFile) {
        String charset;
        File f = new File(scriptFile);
        String name = f.getName();
        Matcher mname = ENCODING_IN_FILE.matcher(name);
        Matcher mext = ENCODING_IN_EXTENSION.matcher(name);
        if (mname.matches()) {
            if (charsets == null) {
                charsets = Charset.availableCharsets();
            }
            if (charsets.containsKey(charset = mname.group(1))) {
                return charset;
            }
        }
        if (mext.matches()) {
            charset = mext.group(1);
            if (charset.equalsIgnoreCase("irc")) {
                return null;
            }
            if (charsets == null) {
                charsets = Charset.availableCharsets();
            }
            if (charsets.containsKey(charset)) {
                return charset;
            }
        }
        return null;
    }

    public void processScriptWarning(ScriptWarning warn) {
        if (!ClientState.getClientState().isOption("script.ignoreWarnings", false)) {
            String[] temp = warn.getMessage().split("\n");
            String fname = warn.getNameShort();
            if (warn.isDebugTrace()) {
                this.getCapabilities().getUserInterface().printStatus(fname + ":" + warn.getLineNumber() + " " + temp[0]);
            } else {
                this.getCapabilities().getUserInterface().printStatus("*** Script Warning: " + temp[0] + " at " + fname + ":" + warn.getLineNumber());
            }
            for (int x = 1; x < temp.length; ++x) {
                this.getCapabilities().getUserInterface().printStatus("     " + temp[x]);
            }
        }
    }

    private void formatCodeException(String scriptFile, YourCodeSucksException ex) {
        this.getCapabilities().getUserInterface().printStatus("*** " + ex.getErrors().size() + " error(s) loading " + scriptFile);
        Iterator i = ex.getErrors().iterator();
        while (i.hasNext()) {
            SyntaxError anError = (SyntaxError)i.next();
            this.getCapabilities().getUserInterface().printStatus("Error: " + anError.getDescription() + " at line " + anError.getLineNumber());
            this.getCapabilities().getUserInterface().printStatus("       " + anError.getCodeSnippet());
            if (anError.getMarker() == null) continue;
            this.getCapabilities().getUserInterface().printStatus("       " + anError.getMarker());
        }
    }
}

