/*
 * Decompiled with CFR 0.152.
 */
package rero.client.output;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rero.bridges.set.SetEnvironment;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.UICapabilities;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;

public class OutputCapabilities
extends Feature
implements ClientStateListener {
    protected SetEnvironment sets;
    protected UICapabilities gui;
    protected InternalDataList data;
    protected boolean doTimestamp;

    public void init() {
        this.sets = (SetEnvironment)this.getCapabilities().getDataStructure("setBridge");
        this.gui = this.getCapabilities().getUserInterface();
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.doTimestamp = ClientState.getClientState().isOption("option.timestamp", false);
        ClientState.getClientState().addClientStateListener("option.timestamp", this);
    }

    public void propertyChanged(String varname, String parm) {
        this.doTimestamp = ClientState.getClientState().isOption("option.timestamp", false);
    }

    public void cycleQuery() {
        Channel temp;
        Set mychans = this.data.getMyUser().getChannels();
        boolean pastQuery = false;
        if (this.gui.getQuery().length() == 0) {
            pastQuery = true;
        }
        Iterator i = mychans.iterator();
        while (i.hasNext()) {
            temp = (Channel)i.next();
            if (pastQuery && !this.gui.isActive(temp.getName())) {
                this.gui.setQuery(temp.getName());
                return;
            }
            if (!temp.getName().equals(this.gui.getQuery())) continue;
            pastQuery = true;
        }
        i = mychans.iterator();
        while (i.hasNext()) {
            temp = (Channel)i.next();
            if (this.gui.isActive(temp.getName())) continue;
            this.gui.setQuery(temp.getName());
            return;
        }
        this.gui.setQuery("");
    }

    public void fireSetActive(HashMap event, String setName) {
        this.gui.printActive(this.getSet(event, setName));
    }

    public void fireSetQuery(HashMap event, String from, String target, String setName) {
        if (target.charAt(0) == '@' || target.charAt(0) == '+' || target.charAt(0) == '%') {
            target = target.substring(1, target.length());
        }
        boolean toActive = ClientState.getClientState().isOption("active.query", true);
        if (ClientUtils.isChannel(target)) {
            this.fireSetTarget(event, target, setName);
        } else if (this.getCapabilities().getUserInterface().isWindow(from)) {
            this.fireSetTarget(event, from, setName);
        } else if (toActive) {
            this.fireSetActive(event, setName);
        } else {
            this.fireSetStatus(event, setName);
        }
    }

    public void fireSetConfused(HashMap event, String target, String setType, String setName) {
        if (target != null && target.length() > 0 && (target.charAt(0) == '@' || target.charAt(0) == '+' || target.charAt(0) == '%')) {
            target = target.substring(1, target.length());
        }
        boolean toActive = ClientState.getClientState().isOption("active." + setType, true);
        if (target != null && this.getCapabilities().getUserInterface().isWindow(target)) {
            this.fireSetTarget(event, target, setName);
        } else if (toActive) {
            this.fireSetActive(event, setName);
        } else {
            this.fireSetStatus(event, setName);
        }
    }

    public void fireSetOption(HashMap event, String variable, String setName) {
        this.gui.printStatus(this.getSet(event, setName));
    }

    public void fireSetTarget(HashMap event, String target, String setName) {
        this.gui.printNormal(target, this.getSet(event, setName));
    }

    public void fireSetAllDeadTarget(HashMap event, String target, String setName) {
        Set temp = this.data.getChannelsFromPriorLife(target);
        this.gui.printToTargets(temp, this.getSet(event, setName), false);
    }

    public void fireSetAllTarget(HashMap event, String target, String setName) {
        this.echoToTarget(target, this.getSet(event, setName), false);
    }

    public void fireSetAllTarget2(HashMap event, String target, String setName) {
        this.echoToTarget(target, this.getSet(event, setName), true);
    }

    public void fireSetStatus(HashMap event, String setName) {
        this.gui.printStatus(this.getSet(event, setName));
    }

    public void fireSetAll(HashMap event, String setName) {
        this.gui.printAll(this.getSet(event, setName));
    }

    public String chooseSet(String target, String setNameActive, String setNameInActive) {
        if (this.gui.isActive(target)) {
            return setNameActive;
        }
        return setNameInActive;
    }

    public String getSet(HashMap event, String setName) {
        if (this.sets.isSet(setName)) {
            String setData = this.sets.parseSet(setName, event);
            if (setData == null || setData.equals("")) {
                return null;
            }
            if (this.doTimestamp && this.sets.isTimeStamped(setName) && this.sets.isSet("TIMESTAMP")) {
                return this.sets.parseSet("TIMESTAMP", event) + setData;
            }
            return setData;
        }
        return null;
    }

    public String parseSet(HashMap event, String set_name) {
        return this.sets.parseSet(set_name, event);
    }

    public boolean isSet(String setName) {
        return this.sets.isSet(setName);
    }

    public void echoToTarget(String nickname, String text, boolean alwaysStatys) {
        HashSet<String> targets = new HashSet<String>();
        Iterator i = this.data.getUser(nickname).getChannels().iterator();
        while (i.hasNext()) {
            Channel temp = (Channel)i.next();
            targets.add(temp.getName());
        }
        this.gui.printToTargets(targets, text, alwaysStatys);
    }

    public void echo(String window, String[] text, double percentage) {
        StringBuffer temp = new StringBuffer(text[0].length() * text.length);
        for (int x = 0; x < text.length; ++x) {
            temp.append(text[x]);
        }
        this.gui.printChunk(window, temp.toString(), text, percentage);
    }
}

