/*
 * Decompiled with CFR 0.152.
 */
package rero.client.output;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import rero.client.Feature;
import rero.client.output.OutputCapabilities;
import rero.dcc.Chat;
import rero.dcc.DataDCC;
import rero.ircfw.InternalDataList;
import rero.net.SocketConnection;
import rero.util.ClientUtils;

public class ChatCapabilities
extends Feature {
    protected SocketConnection sock;
    protected OutputCapabilities output;
    protected DataDCC dccData;

    public void init() {
        this.sock = this.getCapabilities().getSocketConnection();
        this.output = this.getCapabilities().getOutputCapabilities();
        this.dccData = (DataDCC)this.getCapabilities().getDataStructure("dcc");
    }

    public void sendMessage(String nickname, String message) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        if (nickname.charAt(0) == '=') {
            String dnickname = nickname.substring(1, nickname.length());
            Chat connection = (Chat)this.dccData.getSpecificConnection(dnickname, 3);
            if (connection == null) {
                eventData.put("$target", dnickname);
                eventData.put("$parms", message);
                eventData.put("$data", dnickname + " " + message);
                this.output.fireSetTarget(eventData, nickname, "SEND_CHAT_ERROR");
                return;
            }
            connection.sendln(message);
        } else {
            int max = this.computeMaxMessageLength(nickname);
            if (message.length() > max) {
                String[] messages = ChatCapabilities.wrapMessageToStringsArray(message, max);
                for (int i = 0; i < messages.length; ++i) {
                    String msg = messages[i];
                    this.sock.println("PRIVMSG " + nickname + " :" + msg);
                }
            } else {
                this.sock.println("PRIVMSG " + nickname + " :" + message);
            }
        }
        if (nickname.charAt(0) == '=') {
            eventData.put("$target", nickname.substring(1, nickname.length()));
            eventData.put("$parms", message);
            eventData.put("$data", nickname.substring(1, nickname.length()) + " " + message);
            this.output.fireSetTarget(eventData, nickname, "SEND_CHAT");
        } else if (ClientUtils.isChannel(nickname)) {
            eventData.put("$target", nickname);
            eventData.put("$channel", nickname);
            eventData.put("$parms", message);
            eventData.put("$data", nickname + " " + message);
            this.output.fireSetTarget(eventData, nickname, this.output.chooseSet(nickname, "SEND_TEXT", "SEND_TEXT_INACTIVE"));
        } else {
            eventData.put("$target", nickname);
            eventData.put("$parms", message);
            eventData.put("$data", nickname + " " + message);
            this.output.fireSetQuery(eventData, nickname, nickname, "SEND_MSG");
        }
    }

    private int computeMaxMessageLength(String nickname) {
        InternalDataList ci = (InternalDataList)this.output.getCapabilities().getDataStructure("clientInformation");
        String fullAddress = ci.getMyUser().getFullAddress();
        int max = 512;
        max -= 14;
        max -= fullAddress.length();
        return max -= nickname.length();
    }

    public void sendNotice(String target, String message) {
        this.sock.println("NOTICE " + target + " :" + message);
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("$target", target);
        eventData.put("$parms", message);
        eventData.put("$data", target + " " + message);
        this.output.fireSetConfused(eventData, target, "notice", "SEND_NOTICE");
    }

    public void sendAction(String target, String message) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        if (target.charAt(0) == '=') {
            eventData.put("$target", target.substring(1));
            eventData.put("$parms", message);
            eventData.put("$data", target.substring(1) + " " + message);
            this.output.fireSetTarget(eventData, target, this.output.chooseSet(target, "SEND_ACTION", "SEND_ACTION_INACTIVE"));
        } else if (ClientUtils.isChannel(target)) {
            eventData.put("$target", target);
            eventData.put("$channel", target);
            eventData.put("$parms", message);
            eventData.put("$data", target + " " + message);
            this.output.fireSetTarget(eventData, target, this.output.chooseSet(target, "SEND_ACTION", "SEND_ACTION_INACTIVE"));
        } else {
            eventData.put("$target", target);
            eventData.put("$parms", message);
            eventData.put("$data", target + " " + message);
            this.output.fireSetTarget(eventData, target, "SEND_ACTION");
        }
        if (target.charAt(0) == '=') {
            Chat connection = (Chat)this.dccData.getSpecificConnection(target.substring(1), 3);
            if (connection == null) {
                this.output.fireSetTarget(eventData, target, "SEND_CHAT_ERROR");
                return;
            }
            connection.sendln("\u0001ACTION " + message + '\u0001');
        } else {
            this.sock.println("PRIVMSG " + target + " :" + '\u0001' + "ACTION " + message + '\u0001');
        }
    }

    public void sendRequest(String target, String type, String parms) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("$target", target);
        eventData.put("$parms", parms);
        eventData.put("$type", type);
        eventData.put("$data", target + " " + type + " " + parms);
        if (type.equals("PING") && parms.equals("")) {
            parms = System.currentTimeMillis() + "";
        }
        this.output.fireSetConfused(eventData, target, "reply", "SEND_CTCP");
        if (parms.length() > 0) {
            this.sock.println("PRIVMSG " + target + " :" + '\u0001' + type.toUpperCase() + " " + parms + '\u0001');
        } else {
            this.sock.println("PRIVMSG " + target + " :" + '\u0001' + type.toUpperCase() + '\u0001');
        }
    }

    public void sendReply(String target, String type, String parms) {
        this.sock.println("NOTICE " + target + " :" + '\u0001' + type.toUpperCase() + " " + parms + '\u0001');
    }

    public static String[] wrapMessageToStringsArray(String message, int length) {
        String s = ChatCapabilities.wrapText(message, "\n", length);
        return s.split("\n");
    }

    public static String wrapText(String inString, String newline, int wrapColumn) {
        StringTokenizer lineTokenizer = new StringTokenizer(inString, newline, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (lineTokenizer.hasMoreTokens()) {
            try {
                String nextLine = lineTokenizer.nextToken();
                if (nextLine.length() > wrapColumn) {
                    nextLine = ChatCapabilities.wrapLine(nextLine, newline, wrapColumn);
                }
                stringBuffer.append(nextLine);
            }
            catch (NoSuchElementException nsee) {
                break;
            }
        }
        return stringBuffer.toString();
    }

    protected static String wrapLine(String line, String newline, int wrapColumn) {
        StringBuffer wrappedLine = new StringBuffer();
        while (line.length() > wrapColumn) {
            int spaceToWrapAt = line.lastIndexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            spaceToWrapAt = wrapColumn;
            wrappedLine.append(line.substring(0, spaceToWrapAt));
            wrappedLine.append(newline);
            line = line.substring(spaceToWrapAt);
        }
        wrappedLine.append(line);
        return wrappedLine.toString();
    }
}

