/*
 * Decompiled with CFR 0.152.
 */
package rero.client.notify;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.notify.Lag;
import rero.client.notify.NotifyUser;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.config.StringList;
import rero.ircfw.interfaces.ChatListener;
import rero.util.TimerListener;
import rero.util.TokenizedString;

public class NotifyData
extends Feature
implements ChatListener,
TimerListener,
ClientStateListener {
    protected HashMap users = new HashMap();
    protected Set signedon = new HashSet();
    protected Lag lag = new Lag();
    protected int isChecking = 0;

    public void reset() {
        this.signedon = new HashSet();
    }

    public void propertyChanged(String value, String parameter) {
        this.hashUsers();
    }

    public void hashUsers() {
        HashMap newUsers = new HashMap();
        Iterator i = ClientState.getClientState().getStringList("notify.users").getList().iterator();
        while (i.hasNext()) {
            String temp = (String)i.next();
            if (this.users.containsKey(temp)) {
                newUsers.put(temp, this.users.get(temp));
                continue;
            }
            newUsers.put(temp, this.createNotifyUser(temp));
        }
        this.users = newUsers;
    }

    public void addUser(String nickname) {
        StringList temp = ClientState.getClientState().getStringList("notify.users");
        temp.add(nickname);
        temp.save();
        ClientState.getClientState().sync();
    }

    public void removeUser(String nickname) {
        StringList temp = ClientState.getClientState().getStringList("notify.users");
        temp.remove(nickname);
        temp.save();
        ClientState.getClientState().sync();
    }

    public Set getSignedOnUsers() {
        HashSet<NotifyUser> rv = new HashSet<NotifyUser>();
        Iterator i = this.users.values().iterator();
        while (i.hasNext()) {
            NotifyUser temp = (NotifyUser)i.next();
            if (!temp.isSignedOn()) continue;
            rv.add(temp);
        }
        return rv;
    }

    public Set getNotifyUsers() {
        return new HashSet(this.users.values());
    }

    public Set getSignedOffUsers() {
        HashSet<NotifyUser> rv = new HashSet<NotifyUser>();
        Iterator i = this.users.values().iterator();
        while (i.hasNext()) {
            NotifyUser temp = (NotifyUser)i.next();
            if (temp.isSignedOn()) continue;
            rv.add(temp);
        }
        return rv;
    }

    public void init() {
        this.hashUsers();
        this.getCapabilities().addChatListener(this);
        this.getCapabilities().getTimer().addTimer(this, 60000L);
        ClientState.getClientState().addClientStateListener("notify.users", this);
    }

    public void cleanup() {
        this.getCapabilities().getTimer().stopTimer(this);
    }

    public void storeDataStructures(WeakHashMap data) {
        data.put("lag", this.lag);
        data.put("notify", this);
    }

    public NotifyUser createNotifyUser(String nickname) {
        NotifyUser temp = new NotifyUser(nickname);
        temp.installCapabilities(this.getCapabilities());
        return temp;
    }

    public NotifyUser getUserInfo(String nickname) {
        return (NotifyUser)this.users.get(nickname);
    }

    public void checkNotify() {
        if (this.getCapabilities().isConnected()) {
            ++this.isChecking;
            StringBuffer temp = new StringBuffer("ISON :");
            Iterator i = this.users.keySet().iterator();
            while (i.hasNext()) {
                temp.append((String)i.next());
                temp.append(" ");
            }
            this.lag.checkLag();
            this.getCapabilities().sendln(temp.toString());
        }
    }

    public void timerExecute() {
        this.checkNotify();
    }

    public int fireChatEvent(HashMap eventDescription) {
        if (eventDescription.get("$event").equals("376")) {
            this.checkNotify();
            return 1;
        }
        this.lag.setLag();
        if (eventDescription.get("$event").equals("303")) {
            NotifyUser user;
            String parms = (String)eventDescription.get("$parms");
            TokenizedString temp = new TokenizedString(parms);
            temp.tokenize(" ");
            HashSet<NotifyUser> newbatch = new HashSet<NotifyUser>();
            for (int x = 0; x < temp.getTotalTokens(); ++x) {
                user = this.getUserInfo(temp.getToken(x));
                if (user != null && !user.isSignedOn()) {
                    user.signOn();
                }
                newbatch.add(user);
            }
            this.signedon.removeAll(newbatch);
            Iterator i = this.signedon.iterator();
            while (i.hasNext()) {
                user = (NotifyUser)i.next();
                if (user == null || !user.isSignedOn() || !this.users.containsKey(user.toString())) continue;
                user.signOff();
            }
            this.signedon = newbatch;
        }
        --this.isChecking;
        return 2;
    }

    public boolean isChatEvent(String eventId, HashMap eventDescription) {
        return this.isChecking > 0 && (eventId.equals("303") || eventId.equals("461")) || eventId.equals("376");
    }
}

