/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import rero.client.Feature;
import rero.config.ClientState;
import rero.config.StringList;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import text.TextSource;

public class UtilOperators
extends Feature
implements Loadable {
    private static HashMap bridges = new HashMap();

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance script) {
        script.getScriptEnvironment().getEnvironment().put("&formatBytes", new formatBytes());
        script.getScriptEnvironment().getEnvironment().put("&duration", new duration());
        script.getScriptEnvironment().getEnvironment().put("&formatTime", new formatTime());
        script.getScriptEnvironment().getEnvironment().put("&formatTime2", new formatTime2());
        script.getScriptEnvironment().getEnvironment().put("&formatTime3", new formatTime3());
        script.getScriptEnvironment().getEnvironment().put("&formatDecimal", new formatDecimal());
        script.getScriptEnvironment().getEnvironment().put("&longip", new longip());
        script.getScriptEnvironment().getEnvironment().put("&ctime", new ctime());
        script.getScriptEnvironment().getEnvironment().put("&timeDateStamp", new timeDateStamp());
        script.getScriptEnvironment().getEnvironment().put("&timeStamp", new timeStamp());
        script.getScriptEnvironment().getEnvironment().put("&showInputDialog", new showInputDialog());
        script.getScriptEnvironment().getEnvironment().put("&showFileDialog", new showChooserDialog(0));
        script.getScriptEnvironment().getEnvironment().put("&showDirectoryDialog", new showChooserDialog(1));
        script.getScriptEnvironment().getEnvironment().put("&setMappedColor", new setMappedColor());
        script.getScriptEnvironment().getEnvironment().put("&getMappedColor", new getMappedColor());
        script.getScriptEnvironment().getEnvironment().put("&saveColorMap", new saveColorMap());
        script.getScriptEnvironment().getEnvironment().put("&generateThemeScript", new generateTheme());
        script.getScriptEnvironment().getEnvironment().put("&loadFont", new loadFont());
        script.getScriptEnvironment().getEnvironment().put("&getScriptPath", new getScriptPath());
        script.getScriptEnvironment().getEnvironment().put("&getScriptResource", new getScriptResource());
        script.getScriptEnvironment().getEnvironment().put("&strip", new strip());
        script.getScriptEnvironment().getEnvironment().put("&versionString", new versionString());
        script.getScriptEnvironment().getEnvironment().put("&exit", new exit());
        script.getScriptEnvironment().getEnvironment().put("&use", new f2_use());
        script.getScriptEnvironment().getEnvironment().put("-ischannel", new isChannel());
        script.getScriptEnvironment().getEnvironment().put("&groupNicks", new groupUsers());
        script.getScriptEnvironment().getEnvironment().put("&fileCompleteAll", new fileCompleteAll());
        script.getScriptEnvironment().getEnvironment().put("&buildCP437String", new buildString());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    private static File _getScriptPath(String script) {
        StringList temp = ClientState.getClientState().getStringList("script.files");
        Iterator i = temp.getList().iterator();
        while (i.hasNext()) {
            File f = new File(i.next().toString());
            if (!f.getName().equals(script) && !f.getAbsolutePath().equals(script)) continue;
            return f.getParentFile();
        }
        return null;
    }

    private static class duration
    implements Function {
        private duration() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long seconds = BridgeUtilities.getLong(locals, 0L);
            StringBuffer rv = new StringBuffer();
            long minutes = 0L;
            long hours = 0L;
            long days = 0L;
            days = seconds / 86400L;
            hours = seconds / 3600L % 24L;
            minutes = seconds / 60L % 60L;
            seconds %= 60L;
            if (days > 0L) {
                rv.append(days);
                if (days == 1L) {
                    rv.append("day, ");
                } else {
                    rv.append("days, ");
                }
            }
            if (hours > 0L) {
                rv.append(hours);
                if (hours == 1L) {
                    rv.append("hour, ");
                } else {
                    rv.append("hours, ");
                }
            }
            if (minutes > 0L) {
                rv.append(minutes);
                if (minutes == 1L) {
                    rv.append("minute, ");
                } else {
                    rv.append("minutes, ");
                }
            }
            rv.append(seconds);
            if (seconds == 1L) {
                rv.append("second");
            } else {
                rv.append("seconds");
            }
            return SleepUtils.getScalar(rv.toString());
        }
    }

    private static class isChannel
    implements Predicate {
        private isChannel() {
        }

        public boolean decide(String pred, ScriptInstance si, Stack locals) {
            return ClientUtils.isChannel(BridgeUtilities.getString(locals, " "));
        }
    }

    private static class groupUsers
    implements Function {
        private groupUsers() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ScalarArray users = BridgeUtilities.getArray(locals);
            int count = BridgeUtilities.getInt(locals, 4);
            Scalar value = SleepUtils.getArrayScalar();
            StringBuffer rv = new StringBuffer();
            int x = 1;
            Iterator i = users.scalarIterator();
            while (i.hasNext()) {
                String temp = i.next().toString();
                rv.append(temp);
                if (x % count == 0 && x > 1) {
                    rv.append("=");
                } else {
                    rv.append(",");
                }
                ++x;
            }
            if (rv.toString().length() > 1) {
                String[] groups = rv.toString().substring(0, rv.toString().length() - 1).split("=");
                for (x = 0; x < groups.length; ++x) {
                    value.getArray().push(SleepUtils.getScalar(groups[x]));
                }
            }
            return value;
        }
    }

    private static class fileCompleteAll
    implements Function {
        private fileCompleteAll() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            Scalar value = SleepUtils.getArrayScalar();
            Iterator i = ClientUtils.fileCompleteAll(BridgeUtilities.getString(locals, "")).iterator();
            while (i.hasNext()) {
                value.getArray().push(SleepUtils.getScalar(i.next().toString()));
            }
            return value;
        }
    }

    private static class saveColorMap
    implements Function {
        private saveColorMap() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            TextSource.saveColorMap();
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class getMappedColor
    implements Function {
        private getMappedColor() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            int a = BridgeUtilities.getInt(locals);
            if (a < TextSource.colorTable.length && a > 0) {
                return SleepUtils.getScalar(TextSource.colorTable[a].getRGB());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class setMappedColor
    implements Function {
        private setMappedColor() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            int a = BridgeUtilities.getInt(locals);
            String b = locals.pop().toString();
            if (a < TextSource.colorTable.length && a >= 0) {
                TextSource.colorTable[a] = Color.decode(b);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class timeStamp
    implements Function {
        private timeStamp() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(ClientUtils.TimeStamp());
        }
    }

    private static class formatDecimal
    implements Function {
        private formatDecimal() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long temp = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.formatLongAsDecimal(temp));
        }
    }

    private static class ctime
    implements Function {
        private ctime() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(ClientUtils.ctime());
        }
    }

    private class showChooserDialog
    implements Function {
        private int dirChooser;
        private JFileChooser chooser = null;

        public showChooserDialog(int dir) {
            this.dirChooser = dir;
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            int returnVal;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            this.chooser.setFileSelectionMode(this.dirChooser);
            String title = "Select File";
            if (!locals.isEmpty()) {
                title = locals.pop().toString();
            }
            this.chooser.setDialogTitle(title);
            if (!locals.isEmpty()) {
                this.chooser.setCurrentDirectory(new File(locals.pop().toString()));
            }
            if (!locals.isEmpty()) {
                this.chooser.setApproveButtonText(locals.pop().toString());
            }
            if ((returnVal = this.chooser.showOpenDialog(UtilOperators.this.getCapabilities().getGlobalCapabilities().getFrame())) == 0) {
                return SleepUtils.getScalar(this.chooser.getSelectedFile().getAbsolutePath());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class showInputDialog
    implements Function {
        private showInputDialog() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String a;
            String message = "Your answer?";
            if (!locals.isEmpty()) {
                message = locals.pop().toString();
            }
            String title = "Input Requested";
            if (!locals.isEmpty()) {
                title = locals.pop().toString();
            }
            if ((a = JOptionPane.showInputDialog(UtilOperators.this.getCapabilities().getGlobalCapabilities().getFrame(), message, title, 3)) == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(a);
        }
    }

    private class exit
    implements Function {
        private exit() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            UtilOperators.this.getCapabilities().getGlobalCapabilities().QuitClient();
            return null;
        }
    }

    private static class longip
    implements Function {
        private longip() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String a = locals.pop().toString();
            return SleepUtils.getScalar(ClientUtils.longip(a));
        }
    }

    private static class timeDateStamp
    implements Function {
        private timeDateStamp() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.TimeDateStamp(a));
        }
    }

    private static class formatTime3
    implements Function {
        private formatTime3() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.formatTime3(a));
        }
    }

    private static class formatTime2
    implements Function {
        private formatTime2() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.formatTime2(a));
        }
    }

    private static class formatTime
    implements Function {
        private formatTime() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.formatTime(a));
        }
    }

    private static class formatBytes
    implements Function {
        private formatBytes() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            long a = BridgeUtilities.getLong(locals);
            return SleepUtils.getScalar(ClientUtils.formatBytes(a));
        }
    }

    private static class loadFont
    implements Function {
        private loadFont() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String a = locals.pop().toString();
            try {
                Font font = Font.createFont(0, ClientState.getClientState().getResourceAsStream(a));
                return SleepUtils.getScalar(ClientUtils.encodeFont(font));
            }
            catch (Exception ex) {
                si.getScriptEnvironment().flagError(ex.getMessage());
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class versionString
    implements Function {
        private versionString() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(ClientState.getClientState().getString("version.string", "05.09.08"));
        }
    }

    private static class generateTheme
    implements Function {
        private generateTheme() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            if (locals.size() >= 1) {
                ClientUtils.generateThemeScript(locals.pop().toString());
            } else {
                ClientUtils.generateThemeScript(null);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class strip
    implements Function {
        private strip() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(ClientUtils.strip(BridgeUtilities.getString(locals, "")));
        }
    }

    private static class getScriptResource
    implements Function {
        private getScriptResource() {
        }

        public Scalar evaluate(String name, ScriptInstance si, Stack locals) {
            if (locals.size() < 2) {
                return SleepUtils.getEmptyScalar();
            }
            File path = UtilOperators._getScriptPath(locals.pop().toString());
            while (!locals.isEmpty()) {
                path = new File(path, locals.pop().toString());
            }
            return SleepUtils.getScalar(path.getAbsolutePath());
        }
    }

    private static class getScriptPath
    implements Function {
        private getScriptPath() {
        }

        public Scalar evaluate(String name, ScriptInstance si, Stack locals) {
            if (locals.size() < 1) {
                return SleepUtils.getEmptyScalar();
            }
            File path = UtilOperators._getScriptPath(locals.pop().toString());
            if (path == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(path.getAbsolutePath());
        }
    }

    private static class buildString
    implements Function {
        private buildString() {
        }

        public Scalar evaluate(String name, ScriptInstance si, Stack locals) {
            String temp = BridgeUtilities.getString(locals, "");
            return SleepUtils.getScalar(ClientUtils.BuildCP437String(temp));
        }
    }

    private static class f2_use
    implements Function {
        private f2_use() {
        }

        public Scalar evaluate(String n, ScriptInstance si, Stack l) {
            String className;
            File parent;
            if (l.size() == 2) {
                parent = BridgeUtilities.getFile(l, si);
                className = BridgeUtilities.getString(l, "");
            } else {
                File a = BridgeUtilities.getFile(l, si);
                parent = a.getParentFile();
                className = a.getName();
            }
            try {
                Loadable temp;
                Class<?> bridge;
                if (parent != null) {
                    URLClassLoader loader = new URLClassLoader(new URL[]{parent.toURL()});
                    bridge = Class.forName(className, true, loader);
                } else {
                    bridge = Class.forName(className);
                }
                if (bridges.get(bridge.toString()) == null) {
                    temp = (Loadable)bridge.newInstance();
                    bridges.put(bridge.toString(), temp);
                } else {
                    temp = (Loadable)bridges.get(bridge.toString());
                }
                temp.scriptLoaded(si);
            }
            catch (Exception ex) {
                si.getScriptEnvironment().flagError(ex.toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

