/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import rero.client.Feature;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.ircfw.User;
import rero.util.StringUtils;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class UserOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"&searchAddressList", "&getChannels", "&getAddress", "&getIdleTime", "-isidle"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        User user = null;
        if (function2.equals("&searchAddressList")) {
            if (locals.size() != 1) {
                return null;
            }
            String pattern = ((Object)((Scalar)locals.pop()).getValue()).toString();
            HashSet<String> rv = new HashSet<String>();
            Iterator i = this.data.getAllUsers().iterator();
            while (i.hasNext()) {
                User temp = (User)i.next();
                if (!StringUtils.iswm(pattern, temp.getFullAddress())) continue;
                rv.add(temp.getNick());
            }
            return SleepUtils.getArrayWrapper(rv);
        }
        if (locals.size() != 1) {
            user = this.data.getMyUser();
        } else {
            String nick = ((Object)((Scalar)locals.pop()).getValue()).toString();
            if (this.data.isUser(nick)) {
                user = this.data.getUser(nick);
            } else {
                return SleepUtils.getEmptyScalar();
            }
        }
        if (function2.equals("&getChannels")) {
            HashSet<String> rv = new HashSet<String>();
            Iterator i = user.getChannels().iterator();
            while (i.hasNext()) {
                rv.add(((Channel)i.next()).getName());
            }
            return SleepUtils.getArrayWrapper(rv);
        }
        if (function2.equals("&getAddress")) {
            return SleepUtils.getScalar(user.getAddress());
        }
        if (function2.equals("&getIdleTime")) {
            return SleepUtils.getScalar(user.getIdleTime());
        }
        return null;
    }

    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        if (terms.size() != 1) {
            return false;
        }
        String nick = ((Object)((Scalar)terms.pop()).getValue()).toString();
        if (predicate.equals("-isidle") && this.data.isUser(nick)) {
            return this.data.getUser(nick).getIdleTime() > 300;
        }
        return false;
    }
}

