/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.util.TimerListener;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class TimerOperators
extends Feature
implements Loadable {
    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance script) {
        script.getScriptEnvironment().getEnvironment().put("&addTimer", new addTimer());
        script.getScriptEnvironment().getEnvironment().put("&stopTimer", new stopTimer());
        script.getScriptEnvironment().getEnvironment().put("&setTimerResolution", new setResolution());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    private static class ScriptedTimer
    implements TimerListener {
        protected ScriptInstance si;
        protected SleepClosure func;
        protected Scalar args;

        public ScriptedTimer(SleepClosure f, ScriptInstance script, Scalar a) {
            this.func = f;
            this.si = script;
            this.args = a;
        }

        public void timerExecute() {
            if (this.si == null || !this.si.isLoaded()) {
                this.args = null;
                this.si = null;
                this.func = null;
                return;
            }
            Stack<Scalar> arg_stack = new Stack<Scalar>();
            if (this.args != null) {
                arg_stack.push(this.args);
            }
            this.func.callClosure("timer", this.si, arg_stack);
        }
    }

    private class setResolution
    implements Function {
        private setResolution() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            TimerOperators.this.getCapabilities().getTimer().setResolution(BridgeUtilities.getInt(locals));
            return SleepUtils.getEmptyScalar();
        }
    }

    private class stopTimer
    implements Function {
        private stopTimer() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ScriptedTimer timer = (ScriptedTimer)BridgeUtilities.getObject(locals);
            TimerOperators.this.getCapabilities().getTimer().stopTimer(timer);
            return SleepUtils.getEmptyScalar();
        }
    }

    private class addTimer
    implements Function {
        private addTimer() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            int repeats = -1;
            SleepClosure func = BridgeUtilities.getFunction(locals, si);
            int time = BridgeUtilities.getInt(locals);
            if (!locals.isEmpty()) {
                repeats = BridgeUtilities.getInt(locals);
            }
            ScriptedTimer timer = !locals.isEmpty() ? new ScriptedTimer(func, si, BridgeUtilities.getScalar(locals)) : new ScriptedTimer(func, si, null);
            TimerOperators.this.getCapabilities().getTimer().addTimer(timer, time, repeats);
            return SleepUtils.getScalar(timer);
        }
    }
}

