/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.client.notify.NotifyData;
import rero.client.notify.NotifyUser;
import rero.ircfw.InternalDataList;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class NotifyOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;
    protected NotifyData notify;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.notify = (NotifyData)this.getCapabilities().getDataStructure("notify");
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"-isnotify", "-issignedon", "-issignedoff", "&getNotifyUsers", "&getSignedOnUsers", "&getSignedOffUsers", "&onlineFor", "&getAddressFromNotify"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&onlineFor")) {
            if (locals.size() != 1) {
                return SleepUtils.getEmptyScalar();
            }
            NotifyUser temp = this.notify.getUserInfo(((Object)((Scalar)locals.pop()).getValue()).toString());
            return SleepUtils.getScalar(temp.getTimeOnline());
        }
        if (function2.equals("&getAddressFromNotify")) {
            if (locals.size() != 1) {
                return SleepUtils.getEmptyScalar();
            }
            String temps = locals.pop().toString();
            NotifyUser temp = this.notify.getUserInfo(temps);
            if (temp == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(temp.getAddress());
        }
        if (function2.equals("&getNotifyUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getNotifyUsers());
        }
        if (function2.equals("&getSignedOnUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getSignedOnUsers());
        }
        if (function2.equals("&getSignedOffUsers")) {
            return SleepUtils.getArrayWrapper(this.notify.getSignedOffUsers());
        }
        return null;
    }

    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        if (terms.size() != 1) {
            return false;
        }
        String nick = ((Object)((Scalar)terms.pop()).getValue()).toString();
        NotifyUser user = this.notify.getUserInfo(nick);
        if (user == null) {
            return false;
        }
        if (predicate.equals("-signedon")) {
            return user.isSignedOn();
        }
        if (predicate.equals("-signedoff")) {
            return !user.isSignedOn();
        }
        return false;
    }
}

