/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.Stack;
import rero.client.Feature;
import rero.client.dcc.LocalInfo;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.dcc.ListenDCC;
import rero.dcc.ProtocolDCC;
import rero.dcc.Receive;
import rero.dcc.Send;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class DCCOperators
extends Feature
implements Loadable {
    protected DataDCC dccData;

    public void init() {
        this.dccData = (DataDCC)this.getCapabilities().getDataStructure("dcc");
        this.getCapabilities().getScriptCore().addBridge(this);
    }

    public void scriptLoaded(ScriptInstance script) {
        script.getScriptEnvironment().getEnvironment().put("&getActiveConnections", new getActiveConnections());
        script.getScriptEnvironment().getEnvironment().put("&getWaitingConnections", new getWaitingConnections());
        script.getScriptEnvironment().getEnvironment().put("&getInactiveConnections", new getInactiveConnections());
        script.getScriptEnvironment().getEnvironment().put("&getSpecificConnection", new getSpecificConnection());
        script.getScriptEnvironment().getEnvironment().put("&getAllConnections", new getAllConnections());
        script.getScriptEnvironment().getEnvironment().put("&getDCCConnection", new getDCCConnection());
        script.getScriptEnvironment().getEnvironment().put("&getConnectionType", new getConnectionType());
        script.getScriptEnvironment().getEnvironment().put("&getConnectionState", new getConnectionState());
        script.getScriptEnvironment().getEnvironment().put("&getLocalPort", new getLocalPort());
        script.getScriptEnvironment().getEnvironment().put("&getRemotePort", new getRemotePort());
        script.getScriptEnvironment().getEnvironment().put("&getDCCAddress", new getConnectionAddress());
        script.getScriptEnvironment().getEnvironment().put("&getDCCNickname", new getConnectionNickname());
        script.getScriptEnvironment().getEnvironment().put("&getDCCIdleTime", new getIdleTime());
        script.getScriptEnvironment().getEnvironment().put("&getDCCStartTime", new getStartTime());
        script.getScriptEnvironment().getEnvironment().put("&getDCCTotalTime", new getTotalTime());
        script.getScriptEnvironment().getEnvironment().put("-isdccopen", new isOpen());
        script.getScriptEnvironment().getEnvironment().put("&closeDCC", new closeDCC());
        script.getScriptEnvironment().getEnvironment().put("&getFileSizeOffset", new B_getStartOffset());
        script.getScriptEnvironment().getEnvironment().put("&getDCCFileName", new B_getFileName());
        script.getScriptEnvironment().getEnvironment().put("&getDCCFilePath", new B_getFilePath());
        script.getScriptEnvironment().getEnvironment().put("&getTransferRate", new B_getTransferRate());
        script.getScriptEnvironment().getEnvironment().put("&getTimeRemaining", new B_getTimeRemaining());
        script.getScriptEnvironment().getEnvironment().put("&getAcknowledgedSize", new S_getAcknowledgedSize());
        script.getScriptEnvironment().getEnvironment().put("&getBytesSent", new S_getBytesSent());
        script.getScriptEnvironment().getEnvironment().put("&getBytesReceived", new R_getBytesReceived());
        script.getScriptEnvironment().getEnvironment().put("&getExpectedSize", new R_getExpectedSize());
        script.getScriptEnvironment().getEnvironment().put("&localip", new localip());
        script.getScriptEnvironment().getEnvironment().put("&getNextPort", new getNextPort());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public static int getType(String type) {
        if ((type = type.toUpperCase()).equals("SEND")) {
            return 1;
        }
        if (type.equals("CHAT")) {
            return 3;
        }
        if (type.equals("RECEIVE")) {
            return 2;
        }
        return -1;
    }

    private static String getTypeString(int type) {
        if (type == 1) {
            return "SEND";
        }
        if (type == 3) {
            return "CHAT";
        }
        if (type == 2) {
            return "RECEIVE";
        }
        return "Unknown";
    }

    private static String getStateString(int type) {
        if (type == 402) {
            return "OPEN";
        }
        if (type == 403) {
            return "CLOSED";
        }
        if (type == 401) {
            return "WAIT";
        }
        return "Unknown";
    }

    private static int getState(String type) {
        if (type.equals("OPEN")) {
            return 402;
        }
        if (type.equals("CLOSED")) {
            return 403;
        }
        if (type.equals("WAIT")) {
            return 401;
        }
        return -1;
    }

    private static ProtocolDCC deriveImplementation(Object temp) {
        if (temp instanceof GenericDCC) {
            return ((GenericDCC)temp).getImplementation();
        }
        if (temp instanceof ProtocolDCC) {
            return (ProtocolDCC)temp;
        }
        return null;
    }

    private class B_getFilePath
    implements Function {
        private B_getFilePath() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ProtocolDCC temp = DCCOperators.deriveImplementation(BridgeUtilities.getObject(locals));
            if (temp instanceof Send) {
                return SleepUtils.getScalar(((Send)temp).getFile().getAbsolutePath());
            }
            if (temp instanceof Receive) {
                return SleepUtils.getScalar(((Receive)temp).getFile().getAbsolutePath());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getFileName
    implements Function {
        private B_getFileName() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ProtocolDCC temp = DCCOperators.deriveImplementation(BridgeUtilities.getObject(locals));
            if (temp instanceof Send) {
                return SleepUtils.getScalar(((Send)temp).getFile().getName());
            }
            if (temp instanceof Receive) {
                return SleepUtils.getScalar(((Receive)temp).getFile().getName());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getTimeRemaining
    implements Function {
        private B_getTimeRemaining() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ProtocolDCC temp = DCCOperators.deriveImplementation(BridgeUtilities.getObject(locals));
            if (temp instanceof Send) {
                return SleepUtils.getScalar(((Send)temp).getTimeRemaining());
            }
            if (temp instanceof Receive) {
                return SleepUtils.getScalar(((Receive)temp).getTimeRemaining());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getTransferRate
    implements Function {
        private B_getTransferRate() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ProtocolDCC temp = DCCOperators.deriveImplementation(BridgeUtilities.getObject(locals));
            if (temp instanceof Send) {
                return SleepUtils.getScalar(((Send)temp).getTransferRate());
            }
            if (temp instanceof Receive) {
                return SleepUtils.getScalar(((Receive)temp).getTransferRate());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class B_getStartOffset
    implements Function {
        private B_getStartOffset() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            ProtocolDCC temp = ((GenericDCC)BridgeUtilities.getObject(locals)).getImplementation();
            if (temp instanceof Send) {
                return SleepUtils.getScalar(((Send)temp).getStartOffset());
            }
            if (temp instanceof Receive) {
                return SleepUtils.getScalar(((Receive)temp).getStartOffset());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class R_getBytesReceived
    implements Function {
        private R_getBytesReceived() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            Receive temp = (Receive)((GenericDCC)BridgeUtilities.getObject(locals)).getImplementation();
            return SleepUtils.getScalar(temp.getBytesReceived());
        }
    }

    private class R_getExpectedSize
    implements Function {
        private R_getExpectedSize() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            Receive temp = (Receive)((GenericDCC)BridgeUtilities.getObject(locals)).getImplementation();
            return SleepUtils.getScalar(temp.getExpectedSize());
        }
    }

    private class S_getBytesSent
    implements Function {
        private S_getBytesSent() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            Send temp = (Send)((GenericDCC)BridgeUtilities.getObject(locals)).getImplementation();
            return SleepUtils.getScalar(temp.getBytesSent());
        }
    }

    private class S_getAcknowledgedSize
    implements Function {
        private S_getAcknowledgedSize() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            Send temp = (Send)((GenericDCC)BridgeUtilities.getObject(locals)).getImplementation();
            return SleepUtils.getScalar(temp.getAcknowledgedSize());
        }
    }

    private class isOpen
    implements Predicate {
        private isOpen() {
        }

        public boolean decide(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return temp.getState() == 402;
        }
    }

    private class getTotalTime
    implements Function {
        private getTotalTime() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getTotalTime());
        }
    }

    private class getStartTime
    implements Function {
        private getStartTime() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getStartTime());
        }
    }

    private class getIdleTime
    implements Function {
        private getIdleTime() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getIdleTime());
        }
    }

    private class getConnectionNickname
    implements Function {
        private getConnectionNickname() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getNickname());
        }
    }

    private class getConnectionAddress
    implements Function {
        private getConnectionAddress() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getRemoteAddress());
        }
    }

    private class getRemotePort
    implements Function {
        private getRemotePort() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getPort());
        }
    }

    private class getLocalPort
    implements Function {
        private getLocalPort() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(temp.getImplementation().getLocalPort());
        }
    }

    private class getConnectionState
    implements Function {
        private getConnectionState() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(DCCOperators.getStateString(temp.getState()));
        }
    }

    private class getConnectionType
    implements Function {
        private getConnectionType() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            return SleepUtils.getScalar(DCCOperators.getTypeString(temp.getTypeOfDCC()));
        }
    }

    private class getAllConnections
    implements Function {
        private getAllConnections() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getAllConnections());
        }
    }

    private class getInactiveConnections
    implements Function {
        private getInactiveConnections() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 403));
        }
    }

    private class getWaitingConnections
    implements Function {
        private getWaitingConnections() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 401));
        }
    }

    private class closeDCC
    implements Function {
        private closeDCC() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            GenericDCC temp = (GenericDCC)BridgeUtilities.getObject(locals);
            temp.getImplementation().close();
            return SleepUtils.getEmptyScalar();
        }
    }

    private class getDCCConnection
    implements Function {
        private getDCCConnection() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String nick = locals.pop().toString();
            return SleepUtils.getScalar(DCCOperators.this.dccData.getConnectionFromHash(nick));
        }
    }

    private class getSpecificConnection
    implements Function {
        private getSpecificConnection() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            String nick = locals.pop().toString();
            String type = BridgeUtilities.getString(locals, "Unknown");
            return SleepUtils.getScalar(DCCOperators.this.dccData.getSpecificConnection(nick, DCCOperators.getType(type)));
        }
    }

    private class getActiveConnections
    implements Function {
        private getActiveConnections() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getArrayWrapper(DCCOperators.this.dccData.getConnections(-1, 402));
        }
    }

    private static class getNextPort
    implements Function {
        private getNextPort() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            return SleepUtils.getScalar(ListenDCC.getNextPort());
        }
    }

    private class localip
    implements Function {
        private localip() {
        }

        public Scalar evaluate(String f, ScriptInstance si, Stack locals) {
            LocalInfo linfo = (LocalInfo)DCCOperators.this.getCapabilities().getDataStructure("localInfo");
            return SleepUtils.getScalar(linfo.localip());
        }
    }
}

