/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.ArrayList;
import java.util.Stack;
import rero.client.Feature;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ChannelOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"ison", "isop", "ishalfop", "isvoice", "isnormal", "ismode", "hasmode", "&getUsers", "&getOps", "&getHalfOps", "&getVoiced", "&getNormal", "&getTopic", "&getKey", "&getMode", "&getLimit", "&getModeFor", "&getModeChars"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&getModeChars")) {
            String modes = this.data.getPrefixInfo().getModes();
            char[] chars = modes.toCharArray();
            ArrayList<String> ch = new ArrayList<String>(chars.length);
            for (int i = 0; i < chars.length; ++i) {
                char mchar = chars[i];
                ch.add(String.valueOf(mchar));
            }
            return SleepUtils.getArrayWrapper(ch);
        }
        if (function2.equals("&getModeFor")) {
            String _nick = BridgeUtilities.getString(locals, "");
            String _channel = BridgeUtilities.getString(locals, "");
            Channel channel = this.data.getChannel(_channel);
            if (this.data.getUser(_nick) == null) {
                return SleepUtils.getEmptyScalar();
            }
            return SleepUtils.getScalar(this.data.getPrefixInfo().toString(this.data.getUser(_nick).getModeFor(channel)));
        }
        if (locals.size() != 1) {
            return SleepUtils.getEmptyScalar();
        }
        String _channel = ((Object)((Scalar)locals.pop()).getValue()).toString();
        Channel channel = this.data.getChannel(_channel);
        if (channel == null) {
            return null;
        }
        if (function2.equals("&getTopic")) {
            return SleepUtils.getScalar(channel.getTopic());
        }
        if (function2.equals("&getMode")) {
            return SleepUtils.getScalar(channel.getMode().toString());
        }
        if (function2.equals("&getKey")) {
            return SleepUtils.getScalar(channel.getKey());
        }
        if (function2.equals("&getLimit")) {
            return SleepUtils.getScalar(channel.getLimit());
        }
        Stack rv = new Stack();
        Object i = null;
        if (function2.equals("&getUsers")) {
            return SleepUtils.getArrayWrapper(channel.getAllUsers());
        }
        if (function2.equals("&getOps")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(_channel, 'o'));
        }
        if (function2.equals("&getHalfOps")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(_channel, 'h'));
        }
        if (function2.equals("&getVoiced")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(_channel, 'v'));
        }
        if (function2.equals("&getNormal")) {
            return SleepUtils.getArrayWrapper(this.data.getUsersWithMode(_channel, ' '));
        }
        return null;
    }

    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        if (terms.size() != 2) {
            return false;
        }
        String channel = ((Object)((Scalar)terms.pop()).getValue()).toString();
        String nick = ((Object)((Scalar)terms.pop()).getValue()).toString();
        if (this.data.getChannel(channel) == null) {
            return false;
        }
        if (predicate.equals("ismode")) {
            for (int x = 0; x < nick.length(); ++x) {
                if (this.data.getChannel(channel).getMode().isSet(nick.charAt(x))) continue;
                return false;
            }
            return true;
        }
        if (!this.data.isUser(nick)) {
            return false;
        }
        if (predicate.equals("ison")) {
            return this.data.isOn(this.data.getUser(nick), this.data.getChannel(channel));
        }
        int temp = this.data.getUser(nick).getModeFor(this.data.getChannel(channel));
        if (predicate.equals("isop")) {
            return this.data.getPrefixInfo().isMode(temp, 'o');
        }
        if (predicate.equals("ishalfop")) {
            return this.data.getPrefixInfo().isMode(temp, 'h');
        }
        if (predicate.equals("isvoice")) {
            return this.data.getPrefixInfo().isMode(temp, 'v');
        }
        if (predicate.equals("isnormal")) {
            return temp == 0;
        }
        if (predicate.equals("hasmode")) {
            return temp != 0;
        }
        return false;
    }
}

