/*
 * Decompiled with CFR 0.152.
 */
package rero.client.functions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import rero.client.Feature;
import rero.client.user.UserHandler;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dialogs.HelpWindow;
import rero.ircfw.InternalDataList;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class BuiltInOperators
extends Feature
implements Predicate,
Function,
Loadable {
    protected InternalDataList data;
    protected UserHandler commands;

    public void init() {
        this.getCapabilities().getScriptCore().addBridge(this);
        this.data = (InternalDataList)this.getCapabilities().getDataStructure("clientInformation");
        this.commands = (UserHandler)this.getCapabilities().getDataStructure("commands");
    }

    public void scriptLoaded(ScriptInstance script) {
        String[] contents = new String[]{"&call", "&mask", "&sendRaw", "&sendNotice", "&sendAction", "&sendMessage", "&sendReply", "&sendRequest", "&nickComplete", "&nickCompleteAll", "&echo", "&echoRaw", "&echoStatus", "&echoAll", "&setQuery", "&cycleQuery", "&processInput", "&openCommand", "&getSupportHints"};
        for (int x = 0; x < contents.length; ++x) {
            script.getScriptEnvironment().getEnvironment().put(contents[x], this);
        }
        script.getScriptEnvironment().getEnvironment().put("&say", new say());
        script.getScriptEnvironment().getEnvironment().put("&getAliasList", new getAliasList());
        script.getScriptEnvironment().getEnvironment().put("&parseSet", new parseSet());
        script.getScriptEnvironment().getEnvironment().put("&fireEvent", new fireEvent());
        script.getScriptEnvironment().getEnvironment().put("&echoColumns", new echoColumns());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&echo")) {
            switch (locals.size()) {
                case 1: {
                    this.getCapabilities().getUserInterface().printActive(this.getString(locals));
                    break;
                }
                case 2: {
                    this.getCapabilities().getUserInterface().printNormal(this.getString(locals), this.getString(locals));
                    break;
                }
                case 3: {
                    int ck = BridgeUtilities.getInt(locals);
                    this.getCapabilities().getOutputCapabilities().echoToTarget(this.getString(locals), this.getString(locals), ck == 2);
                    break;
                }
            }
            return SleepUtils.getEmptyScalar();
        }
        if (function2.equals("&openCommand") && locals.size() == 1) {
            try {
                Runtime.getRuntime().exec(ClientState.getClientState().getString("ui.openfiles", ClientDefaults.ui_openfiles) + " " + locals.pop().toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (function2.equals("&echoStatus") && locals.size() == 1) {
            this.getCapabilities().getUserInterface().printStatus(this.getString(locals));
        } else if (function2.equals("&echoRaw") && locals.size() == 2) {
            this.getCapabilities().getUserInterface().printRaw(BridgeUtilities.getString(locals, ""), BridgeUtilities.getString(locals, ""));
        } else if (function2.equals("&echoAll") && locals.size() == 1) {
            this.getCapabilities().getUserInterface().printAll(this.getString(locals));
        } else if (function2.equals("&setQuery") && locals.size() == 1) {
            this.getCapabilities().getUserInterface().setQuery(this.getString(locals));
        } else if (function2.equals("&cycleQuery")) {
            this.getCapabilities().getOutputCapabilities().cycleQuery();
        } else if (function2.equals("&sendRaw") && locals.size() == 1) {
            this.getCapabilities().sendln(this.getString(locals));
        } else {
            if (function2.equals("&mask") && locals.size() == 2) {
                return SleepUtils.getScalar(ClientUtils.mask(this.getString(locals), this.getInt(locals)));
            }
            if (function2.equals("&call") && locals.size() == 1) {
                String temp = this.getString(locals);
                if (temp.charAt(0) != '/') {
                    temp = "/" + temp;
                }
                this.commands.processCommand(temp);
            } else if (function2.equals("&call") && locals.size() == 2) {
                String temp = this.getString(locals);
                if (temp.charAt(0) != '/') {
                    temp = "/" + temp;
                }
                this.commands.processCommandBuiltIn(temp);
            } else if (function2.equals("&processInput") && locals.size() == 1) {
                this.commands.processInput(this.getString(locals));
            } else {
                if (function2.equals("&nickComplete") && locals.size() == 2) {
                    return SleepUtils.getScalar(this.data.nickComplete(this.getString(locals), this.getString(locals)));
                }
                if (function2.equals("&nickCompleteAll") && locals.size() == 2) {
                    Scalar rv = SleepUtils.getArrayScalar();
                    Iterator i = this.data.nickCompleteAll(this.getString(locals), this.getString(locals)).iterator();
                    while (i.hasNext()) {
                        rv.getArray().push(SleepUtils.getScalar(i.next().toString()));
                    }
                    return rv;
                }
                if (function2.substring(1, 5).equals("send") && locals.size() >= 2) {
                    String target = this.getString(locals);
                    String text = this.getString(locals);
                    if (function2.equals("&sendNotice")) {
                        this.getCapabilities().getChatCapabilities().sendNotice(target, text);
                    } else if (function2.equals("&sendMessage")) {
                        this.getCapabilities().getChatCapabilities().sendMessage(target, text);
                    } else if (function2.equals("&sendAction")) {
                        this.getCapabilities().getChatCapabilities().sendAction(target, text);
                    } else if (function2.equals("&sendReply")) {
                        this.getCapabilities().getChatCapabilities().sendReply(target, text, this.getString(locals));
                    } else if (function2.equals("&sendRequest")) {
                        this.getCapabilities().getChatCapabilities().sendRequest(target, text, this.getString(locals));
                    }
                    return SleepUtils.getEmptyScalar();
                }
            }
        }
        if (function2.equals("&getSupportHints")) {
            return SleepUtils.getHashWrapper(this.data.getSupportInfo());
        }
        return SleepUtils.getEmptyScalar();
    }

    private String getString(Stack l) {
        if (l.isEmpty()) {
            return "";
        }
        return ((Object)((Scalar)l.pop()).getValue()).toString();
    }

    private int getInt(Stack l) {
        if (l.isEmpty()) {
            return 0;
        }
        return ((Scalar)l.pop()).getValue().intValue();
    }

    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        return false;
    }

    private class say
    implements Function {
        private say() {
        }

        public Scalar evaluate(String name, ScriptInstance si, Stack parms) {
            BuiltInOperators.this.getCapabilities().getChatCapabilities().sendMessage(BuiltInOperators.this.getCapabilities().getUserInterface().getQuery(), parms.pop().toString());
            return SleepUtils.getEmptyScalar();
        }
    }

    private class fireEvent
    implements Function {
        private fireEvent() {
        }

        public Scalar evaluate(String fname, ScriptInstance si, Stack parms) {
            if (parms.size() == 1) {
                BuiltInOperators.this.getCapabilities().injectEvent(BridgeUtilities.getString(parms, ""));
            } else {
                String name = BridgeUtilities.getString(parms, "UNKNOWN_EVENT");
                Scalar temp = BridgeUtilities.getScalar(parms);
                if (temp.getHash() != null) {
                    HashMap<String, String> eventData = new HashMap<String, String>();
                    eventData.put("$event", name);
                    Iterator i = temp.getHash().keys().scalarIterator();
                    while (i.hasNext()) {
                        Scalar key = (Scalar)i.next();
                        eventData.put(key.toString(), temp.getHash().getAt(key).toString());
                    }
                    BuiltInOperators.this.getCapabilities().dispatchEvent(eventData);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private class parseSet
    implements Function {
        private parseSet() {
        }

        public Scalar evaluate(String name, ScriptInstance si, Stack parms) {
            String set = BridgeUtilities.getString(parms, "UNKNOWN_SET");
            if (!parms.isEmpty() && ((Scalar)parms.peek()).getHash() != null) {
                ScalarHash hashish = ((Scalar)parms.pop()).getHash();
                HashMap<String, String> temp = new HashMap<String, String>();
                Iterator i = hashish.keys().scalarIterator();
                while (i.hasNext()) {
                    Scalar key = (Scalar)i.next();
                    temp.put(key.toString(), hashish.getAt(key).toString());
                }
                return SleepUtils.getScalar(BuiltInOperators.this.getCapabilities().getOutputCapabilities().parseSet(temp, set));
            }
            String target = BridgeUtilities.getString(parms, "<unknown>");
            String data = BridgeUtilities.getString(parms, "");
            return SleepUtils.getScalar(BuiltInOperators.this.getCapabilities().getOutputCapabilities().parseSet(ClientUtils.getEventHashMap(target, data), set));
        }
    }

    private class getAliasList
    implements Function {
        private getAliasList() {
        }

        public Scalar evaluate(String function2, ScriptInstance si, Stack parms) {
            LinkedList rv = new LinkedList();
            rv.addAll(HelpWindow.getBuiltInAliases());
            rv.addAll(BuiltInOperators.this.commands.getScriptedAliases());
            return SleepUtils.getArrayWrapper(rv);
        }
    }

    private class echoColumns
    implements Function {
        private echoColumns() {
        }

        public Scalar evaluate(String function2, ScriptInstance si, Stack locals) {
            String window = BridgeUtilities.getString(locals, "");
            String text = BridgeUtilities.getString(locals, "");
            double percen = BridgeUtilities.getDouble(locals, 1.0);
            BuiltInOperators.this.getCapabilities().getUserInterface().printChunk(window, text.replace('\t', ' '), text.split("\t"), percen);
            return SleepUtils.getEmptyScalar();
        }
    }
}

