/*
 * Decompiled with CFR 0.152.
 */
package rero.client.dcc;

import java.io.File;
import java.util.HashMap;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.dcc.LocalInfo;
import rero.client.functions.DCCOperators;
import rero.client.user.ClientCommand;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.dcc.Chat;
import rero.dcc.ConnectDCC;
import rero.dcc.DCCUtilities;
import rero.dcc.DataDCC;
import rero.dcc.GenericDCC;
import rero.dcc.ListenDCC;
import rero.dcc.Receive;
import rero.dcc.Send;
import rero.dialogs.DialogUtilities;
import rero.dialogs.dcc.ChatRequest;
import rero.dialogs.dcc.SendRequest;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import rero.ircfw.interfaces.FrameworkConstants;
import rero.util.ClientUtils;
import rero.util.TokenizedString;

public class FeatureDCC
extends Feature
implements ClientCommand,
ChatListener,
FrameworkConstants {
    protected ChatFramework ircfw;
    protected DataDCC dccData = new DataDCC();
    protected LocalInfo localInfo;

    public void storeDataStructures(WeakHashMap data) {
        data.put("dcc", this.dccData);
    }

    public void init() {
        this.ircfw = this.getCapabilities().getChatFramework();
        this.localInfo = (LocalInfo)this.getCapabilities().getDataStructure("localInfo");
        this.getCapabilities().addChatListener(this);
        this.getCapabilities().registerCommand("DCC", this);
        this.getCapabilities().registerCommand("SEND", this);
        this.getCapabilities().registerCommand("CHAT", this);
    }

    public void requestChat(String nickname) {
        Chat protocol = new Chat(nickname);
        ListenDCC connect = new ListenDCC();
        connect.announceFramework(this.ircfw);
        connect.setImplementation(protocol);
        int port = connect.getListenerPort();
        if (port > -1) {
            String out = "PRIVMSG " + nickname + " :" + '\u0001' + "DCC CHAT chat " + ClientUtils.longip(this.localInfo.localip()) + " " + port + "" + '\u0001' + "";
            this.getCapabilities().getOutputCapabilities().fireSetConfused(ClientUtils.getEventHashMap(nickname, "CHAT " + port), nickname, "reply", "SEND_DCC");
            this.getCapabilities().sendln(out);
            this.dccData.addConnection(port + "", connect);
            connect.connect();
        } else {
            connect.getImplementation().fireError("unable to establish a port");
        }
    }

    public void sendFile(String nickname, File file) {
        Send protocol = new Send(nickname, file);
        ListenDCC connect = new ListenDCC();
        connect.announceFramework(this.ircfw);
        connect.setImplementation(protocol);
        int port = connect.getListenerPort();
        if (port > -1) {
            String fname = file.getName();
            if (ClientState.getClientState().isOption("dcc.fillspaces", true)) {
                fname = fname.replace(' ', '_');
            }
            String out = "PRIVMSG " + nickname + " :" + '\u0001' + "DCC SEND " + fname + " " + ClientUtils.longip(this.localInfo.localip()) + " " + port + " " + file.length() + '\u0001' + "";
            this.getCapabilities().getOutputCapabilities().fireSetConfused(ClientUtils.getEventHashMap(nickname, "SEND " + port + " " + file.length() + " " + file.getAbsolutePath()), nickname, "reply", "SEND_DCC");
            this.getCapabilities().sendln(out);
            this.dccData.addConnection(port + "", connect);
            connect.connect();
        } else {
            connect.getImplementation().fireError("unable to establish a port");
        }
    }

    public void runAlias(String command, String parameters) {
        File sendme;
        if ((command = command.toLowerCase()).equals("send") || command.equals("chat")) {
            this.runAlias("dcc", command + " " + parameters);
            return;
        }
        if (!command.equals("dcc")) {
            return;
        }
        TokenizedString temps = new TokenizedString(parameters);
        temps.tokenize(" ");
        if (temps.getToken(0).equals("stats")) {
            this.getCapabilities().getUserInterface().openDCCWindow();
        } else if (temps.getToken(0).equals("chat")) {
            this.requestChat(temps.getToken(1));
        } else if (temps.getToken(0).equals("close")) {
            if (temps.getToken(1).charAt(0) == '=') {
                this.dccData.closeChat(temps.getToken(1).substring(1, temps.getToken(1).length()));
            } else if (temps.getTotalTokens() == 3) {
                int type = DCCOperators.getType(temps.getToken(1));
                this.dccData.closeConnection(temps.getToken(2), type);
            } else {
                this.dccData.closeConnection(temps.getToken(1));
            }
        } else if (temps.getToken(0).equals("accept")) {
            ConnectDCC temp = (ConnectDCC)this.dccData.getConnectionToAccept(temps.getToken(1));
            if (temps.getTotalTokens() >= 3 && temp.getImplementation() instanceof Receive) {
                ((Receive)temp.getImplementation()).setFile(new File(temps.getToken(2)));
            }
            if (temp != null) {
                temp.connect();
            }
        } else if (temps.getToken(0).equals("send") && (sendme = temps.getTotalTokens() == 2 || !new File(temps.getToken(2)).exists() ? DialogUtilities.showFileDialog("Send File", "Accept", null) : ClientUtils.getFile(temps.getToken(2))) != null && sendme.exists()) {
            this.sendFile(temps.getToken(1), sendme);
        }
    }

    public boolean isChatEvent(String event, HashMap eventDescription) {
        String parms = (String)eventDescription.get("$parms");
        return event.equals("REQUEST") && parms.substring(0, 3).equals("DCC");
    }

    public int fireChatEvent(HashMap description) {
        TokenizedString temp = new TokenizedString(description.get("$parms").toString());
        temp.tokenize(" ");
        if (temp.getToken(1).equals("CHAT")) {
            boolean checkAutoAccept;
            int port = Integer.parseInt(temp.getToken(4));
            String server = ClientUtils.longip(temp.getToken(3));
            if (port <= 0 || port == 19) {
                return 1;
            }
            Chat protocol = new Chat(description.get("$nick").toString());
            ConnectDCC connect = new ConnectDCC(server, port);
            connect.announceFramework(this.ircfw);
            connect.setImplementation(protocol);
            this.dccData.addConnection(port + "", connect);
            boolean checkDialog = ClientState.getClientState().getInteger("dcc.onchat", 0) == 0 && ChatRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connect);
            boolean bl = checkAutoAccept = ClientState.getClientState().getInteger("dcc.onchat", 0) == 1;
            if (checkDialog || checkAutoAccept) {
                connect.connect();
            }
        } else if (temp.getToken(1).equals("CLOSE")) {
            this.dccData.closeChat(temp.getToken(2).substring(1, temp.getToken(2).length()));
        } else if (temp.getToken(1).equals("ACCEPT")) {
            ConnectDCC tempc = (ConnectDCC)this.dccData.getConnection(temp.getToken(3));
            if (tempc != null) {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(description, "RESUME_SUCCEEDED");
                tempc.connect();
            } else {
                this.getCapabilities().getOutputCapabilities().fireSetStatus(description, "RESUME_FAILED");
            }
        } else if (temp.getToken(1).equals("RESUME")) {
            GenericDCC tempc = this.dccData.getConnection(temp.getToken(3));
            if (tempc != null && tempc.getImplementation().getTypeOfDCC() == 1) {
                Send send = (Send)tempc.getImplementation();
                if (send.resume(Long.parseLong(temp.getToken(4)))) {
                    this.getCapabilities().getOutputCapabilities().fireSetStatus(description, "RESUME_REQUEST");
                    String output = "PRIVMSG " + description.get("$nick") + " :" + '\u0001' + "DCC ACCEPT " + temp.getTokenFrom(2) + '\u0001';
                    this.getCapabilities().sendln(output);
                    tempc.connect();
                } else {
                    this.getCapabilities().getOutputCapabilities().fireSetStatus(description, "RESUME_REQUEST_ERROR");
                }
            }
        } else if (temp.getToken(1).equals("SEND")) {
            boolean checkAutoAccept;
            int offset = temp.getTotalTokens() - 6;
            int port = Integer.parseInt(temp.getToken(4 + offset));
            String server = ClientUtils.longip(temp.getToken(3 + offset));
            if (port < 1024) {
                return 1;
            }
            String fstring = temp.getToken(2);
            if (offset > 0) {
                fstring = temp.getTokenRange(2, 2 + offset);
            }
            fstring = new File(fstring).getName();
            File output = new File(ClientState.getClientState().getString("dcc.saveto", ClientDefaults.dcc_saveto), fstring);
            Receive protocol = new Receive(description.get("$nick").toString(), output, Long.parseLong(temp.getToken(5 + offset)));
            ConnectDCC connect = new ConnectDCC(server, port);
            connect.announceFramework(this.ircfw);
            connect.setImplementation(protocol);
            this.dccData.addConnection(port + "", connect);
            boolean checkDialog = ClientState.getClientState().getInteger("dcc.onsend", 0) == 0 && SendRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connect);
            boolean bl = checkAutoAccept = ClientState.getClientState().getInteger("dcc.onsend", 0) == 1;
            if (checkDialog || checkAutoAccept) {
                this.handleReceive(protocol, connect, description, temp);
            }
        }
        return 1;
    }

    private void handleReceive(Receive protocol, ConnectDCC connect, HashMap description, TokenizedString temp) {
        File output = protocol.getFile();
        if (output.exists()) {
            int resumeOption = DCCUtilities.DetermineResumeOption(this.getCapabilities(), connect);
            switch (resumeOption) {
                case 0: {
                    if (output.length() < protocol.getExpectedSize()) {
                        protocol.pleaseResume();
                        String outputz = "PRIVMSG " + description.get("$nick") + " :" + '\u0001' + "DCC RESUME " + temp.getToken(2) + " " + temp.getToken(4) + " " + output.length() + '\u0001';
                        this.getCapabilities().sendln(outputz);
                        this.getCapabilities().getOutputCapabilities().fireSetStatus(description, "SEND_RESUME_REQUEST");
                        break;
                    }
                    protocol.fireError("file already completed, no need to resume");
                    break;
                }
                case 1: {
                    boolean option = SendRequest.showDialog(this.getCapabilities().getGlobalCapabilities().getFrame(), connect);
                    if (!option) break;
                    this.handleReceive(protocol, connect, description, temp);
                    break;
                }
                case 2: {
                    connect.connect();
                }
            }
        } else {
            connect.connect();
        }
    }
}

