/*
 * Decompiled with CFR 0.152.
 */
package rero.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.WeakHashMap;
import rero.client.Feature;
import rero.client.data.DataStructureBridge;
import rero.client.dcc.FeatureDCC;
import rero.client.dcc.LocalInfo;
import rero.client.functions.BuiltInOperators;
import rero.client.functions.ChannelOperators;
import rero.client.functions.ConfigOperators;
import rero.client.functions.DCCOperators;
import rero.client.functions.NotifyOperators;
import rero.client.functions.ServerOperators;
import rero.client.functions.SoundOperators;
import rero.client.functions.TimerOperators;
import rero.client.functions.TokenOperators;
import rero.client.functions.UserOperators;
import rero.client.functions.UtilOperators;
import rero.client.listeners.InternalEvents;
import rero.client.notify.NotifyData;
import rero.client.output.ChatCapabilities;
import rero.client.output.OutputCapabilities;
import rero.client.script.ScriptManager;
import rero.client.server.PerformOnConnect;
import rero.client.server.ProcessEvents;
import rero.client.server.ServerHandler;
import rero.client.user.ClientCommand;
import rero.client.user.UserHandler;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import rero.gui.UICapabilities;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import rero.net.SocketConnection;
import rero.script.ScriptCore;
import rero.util.TimerUtil;

public class Capabilities {
    protected SocketConnection socket;
    protected ChatFramework ircfw;
    protected ScriptCore script;
    protected OutputCapabilities output;
    protected ChatCapabilities actions;
    protected UICapabilities gui;
    protected static TimerUtil timer;
    protected WeakHashMap data;
    protected LinkedList featureList;

    public Capabilities(ChatFramework _ircfw, SocketConnection _socket, ScriptCore _script, UICapabilities _gui, WeakHashMap _data) {
        this.ircfw = _ircfw;
        this.socket = _socket;
        this.script = _script;
        this.gui = _gui;
        this.data = _data;
        if (timer == null) {
            timer = new TimerUtil();
            timer.start();
        }
        this.featureList = new LinkedList();
        this.output = new OutputCapabilities();
        this.setupFeature(this.output, this.featureList);
        this.actions = new ChatCapabilities();
        this.setupFeature(this.actions, this.featureList);
        UserHandler userInput = new UserHandler();
        this.setupFeature(userInput, this.featureList);
        ServerHandler serverOutput = new ServerHandler();
        this.setupFeature(serverOutput, this.featureList);
        FeatureDCC dcc = new FeatureDCC();
        this.setupFeature(dcc, this.featureList);
        ProcessEvents processEvents = new ProcessEvents();
        this.setupFeature(processEvents, this.featureList);
        NotifyData notify = new NotifyData();
        this.setupFeature(notify, this.featureList);
        InternalEvents internalEvents = new InternalEvents();
        this.setupFeature(internalEvents, this.featureList);
        LocalInfo localInfo = new LocalInfo();
        this.setupFeature(localInfo, this.featureList);
        ScriptManager scriptManager = new ScriptManager();
        this.setupFeature(scriptManager, this.featureList);
        PerformOnConnect performConnect = new PerformOnConnect();
        this.setupFeature(performConnect, this.featureList);
        DataStructureBridge dataStructs = new DataStructureBridge();
        this.setupFeature(dataStructs, this.featureList);
        ChannelOperators chanops = new ChannelOperators();
        this.setupFeature(chanops, this.featureList);
        this.script.addBridge(chanops);
        UserOperators userops = new UserOperators();
        this.setupFeature(userops, this.featureList);
        this.script.addBridge(userops);
        BuiltInOperators builtinops = new BuiltInOperators();
        this.setupFeature(builtinops, this.featureList);
        this.script.addBridge(builtinops);
        NotifyOperators notifyops = new NotifyOperators();
        this.setupFeature(notifyops, this.featureList);
        this.script.addBridge(notifyops);
        TimerOperators timerops = new TimerOperators();
        this.setupFeature(timerops, this.featureList);
        ConfigOperators configops = new ConfigOperators();
        this.setupFeature(configops, this.featureList);
        DCCOperators dccops = new DCCOperators();
        this.setupFeature(dccops, this.featureList);
        UtilOperators utilops = new UtilOperators();
        this.setupFeature(utilops, this.featureList);
        TokenOperators tokenops = new TokenOperators();
        this.setupFeature(tokenops, this.featureList);
        ServerOperators serverops = new ServerOperators();
        this.setupFeature(serverops, this.featureList);
        SoundOperators soundops = new SoundOperators();
        this.setupFeature(soundops, this.featureList);
        this.finalizeFeatures(this.featureList);
    }

    public TimerUtil getTimer() {
        return timer;
    }

    public void cleanup() {
        ListIterator i = this.featureList.listIterator();
        while (i.hasNext()) {
            Feature temp = (Feature)i.next();
            temp.cleanup();
        }
        this.data.clear();
        this.featureList.clear();
    }

    public boolean isConnected() {
        return this.socket.getSocketInformation().isConnected;
    }

    public ChatCapabilities getChatCapabilities() {
        return this.actions;
    }

    public OutputCapabilities getOutputCapabilities() {
        return this.output;
    }

    public UICapabilities getUserInterface() {
        return this.gui;
    }

    public ScriptCore getScriptCore() {
        return this.script;
    }

    public SocketConnection getSocketConnection() {
        return this.socket;
    }

    public void sendln(String text) {
        this.socket.println(text);
    }

    public Object getDataStructure(String key) {
        return this.data.get(key);
    }

    public void injectEvent(String text) {
        this.ircfw.injectEvent(text);
    }

    public void dispatchEvent(HashMap data) {
        this.ircfw.getProtocolDispatcher().dispatchEvent(data);
    }

    public void addChatListener(ChatListener l) {
        this.ircfw.addChatListener(l);
    }

    public void addTemporaryListener(ChatListener l) {
        this.ircfw.addTemporaryListener(l);
    }

    public ChatFramework getChatFramework() {
        return this.ircfw;
    }

    public void registerCommand(String command, ClientCommand code) {
        UserHandler commands = (UserHandler)this.getDataStructure("commands");
        commands.registerCommand(command, code);
    }

    public void setupFeature(Feature aFeature, LinkedList features) {
        aFeature.storeDataStructures(this.data);
        aFeature.installCapabilities(this);
        features.add(aFeature);
    }

    public void finalizeFeatures(LinkedList features) {
        ListIterator i = features.listIterator();
        while (i.hasNext()) {
            Feature temp = (Feature)i.next();
            temp.init();
        }
    }

    public GlobalCapabilities getGlobalCapabilities() {
        return SessionManager.getGlobalCapabilities();
    }
}

