/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import rero.bridges.menu.CodeSnippet;
import rero.bridges.menu.MenuBridge;
import rero.bridges.menu.MenuBridgeParent;
import rero.script.ScriptCore;
import sleep.engine.Block;
import sleep.runtime.ScriptInstance;

public class ScriptedPopupMenu
extends JPopupMenu
implements PopupMenuListener,
MenuBridgeParent {
    protected static HashMap MenuData = null;
    protected LinkedList code;

    public static void SetMenuData(HashMap h) {
        if (h != null) {
            MenuData = h;
        }
    }

    public static HashMap getMenuData() {
        return MenuData;
    }

    public static void FinishMenuData() {
        MenuData = null;
    }

    public ScriptedPopupMenu(ScriptInstance _owner, Block _code) {
        this.code = new LinkedList();
        this.installCode(_owner, _code);
        this.addPopupMenuListener(this);
    }

    public ScriptedPopupMenu(LinkedList _code) {
        this.code = _code;
        this.addPopupMenuListener(this);
    }

    public void installCode(ScriptInstance _owner, Block _code) {
        this.code.add(new CodeSnippet(_owner, _code));
    }

    public boolean isValidCode() {
        Iterator i = this.code.iterator();
        while (i.hasNext()) {
            CodeSnippet temp = (CodeSnippet)i.next();
            if (temp.getOwner().isLoaded()) continue;
            i.remove();
        }
        return this.code.size() > 0;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        MenuBridge.SetParent(this);
        Iterator i = this.code.iterator();
        while (i.hasNext()) {
            CodeSnippet temp = (CodeSnippet)i.next();
            if (temp.getOwner().isLoaded()) {
                ScriptCore.runCode(temp.getOwner(), temp.getBlock(), MenuData);
                continue;
            }
            i.remove();
        }
        MenuBridge.FinishParent();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.removeAll();
    }
}

