/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rero.bridges.menu.CodeSnippet;
import rero.bridges.menu.MenuBridge;
import rero.bridges.menu.MenuBridgeParent;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.script.ScriptCore;
import sleep.engine.Block;
import sleep.runtime.ScriptInstance;

public class ScriptedMenu
extends JMenu
implements MenuListener,
MenuBridgeParent {
    protected LinkedList code;

    public ScriptedMenu(ScriptInstance _owner, String _label, Block _code) {
        if (_label.indexOf(38) > -1) {
            this.setText(_label.substring(0, _label.indexOf(38)) + _label.substring(_label.indexOf(38) + 1, _label.length()));
            this.setMnemonic(_label.charAt(_label.indexOf(38) + 1));
        } else {
            this.setText(_label);
        }
        this.code = new LinkedList();
        this.installCode(_owner, _code);
        this.addMenuListener(this);
    }

    public JPopupMenu getScriptedPopupMenu() {
        return new ScriptedPopupMenu(this.code);
    }

    public void installCode(ScriptInstance _owner, Block _code) {
        this.code.add(new CodeSnippet(_owner, _code));
    }

    public boolean isValidCode() {
        Iterator i = this.code.iterator();
        while (i.hasNext()) {
            CodeSnippet temp = (CodeSnippet)i.next();
            if (temp.getOwner().isLoaded()) continue;
            i.remove();
        }
        return this.code.size() > 0;
    }

    public void menuSelected(MenuEvent e) {
        MenuBridge.SetParent(this);
        Iterator i = this.code.iterator();
        while (i.hasNext()) {
            CodeSnippet temp = (CodeSnippet)i.next();
            if (!temp.getOwner().isLoaded()) continue;
            ScriptCore.runCode(temp.getOwner(), temp.getBlock(), ScriptedPopupMenu.getMenuData());
        }
        MenuBridge.FinishParent();
    }

    public void menuDeselected(MenuEvent e) {
        this.removeAll();
    }

    public void menuCanceled(MenuEvent e) {
        this.removeAll();
    }
}

