/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.menu;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import rero.bridges.menu.MenuBridgeParent;
import rero.bridges.menu.ScriptedItem;
import rero.bridges.menu.ScriptedMenu;
import rero.bridges.menu.ScriptedPopupMenu;
import rero.bridges.menu.SimpleItem;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;

public class MenuBridge
implements Environment,
Function,
Loadable {
    protected static String WINDOW_MENU = "&Window";
    protected static String HELP_MENU = "&Help";
    protected static Stack ParentMenu = new Stack();
    protected LinkedHashMap menubarMenus = new LinkedHashMap(10, 0.75f, false);
    protected HashMap menus = new HashMap();

    public static void SetParent(MenuBridgeParent m) {
        ParentMenu.push(m);
    }

    public static MenuBridgeParent GetParent() {
        return (MenuBridgeParent)ParentMenu.peek();
    }

    public static void FinishParent() {
        ParentMenu.pop();
    }

    protected static boolean isTopLevel(String name) {
        if ((name = name.toLowerCase()).length() > 2 && name.substring(0, 2).equals("__")) {
            return true;
        }
        return name.equals("list") || name.equals("dcc") || name.equals("switchbar") || name.equals("nicklist") || name.equals("status") || name.equals("channel") || name.equals("query") || name.equals("input") || name.equals("chat") || name.equals("tab") || name.equals("background");
    }

    protected static boolean isSpecialMenu(String name) {
        return name.equals(WINDOW_MENU) || name.equals(HELP_MENU);
    }

    public void bindFunction(ScriptInstance si, String type, String description, Block code) {
        if (type.equals("menubar")) {
            if (this.menubarMenus.containsKey(description)) {
                ((ScriptedMenu)this.menubarMenus.get(description)).installCode(si, code);
            } else if (MenuBridge.isSpecialMenu(description)) {
                if (this.menus.containsKey(description)) {
                    ((ScriptedMenu)this.menus.get(description)).installCode(si, code);
                } else {
                    this.menus.put(description, new ScriptedMenu(si, description, code));
                }
            } else {
                this.menubarMenus.put(description, new ScriptedMenu(si, description, code));
            }
        }
        if (type.equals("menu")) {
            if (MenuBridge.isTopLevel(description.toUpperCase())) {
                if (this.menus.containsKey(description.toUpperCase())) {
                    ((ScriptedPopupMenu)this.menus.get(description.toUpperCase())).installCode(si, code);
                } else {
                    this.menus.put(description.toUpperCase(), new ScriptedPopupMenu(si, code));
                }
            } else {
                MenuBridge.GetParent().add(new ScriptedMenu(si, description, code));
            }
        }
        if (type.equals("item")) {
            MenuBridge.GetParent().add(new ScriptedItem(si, description, code));
        }
    }

    public Scalar evaluate(String function2, ScriptInstance script, Stack locals) {
        if (function2.equals("&addSeparator")) {
            MenuBridge.GetParent().addSeparator();
        } else if (function2.equals("&addItem") && locals.size() == 2) {
            String name = ((Scalar)locals.pop()).stringValue();
            String func = ((Scalar)locals.pop()).stringValue();
            MenuBridge.GetParent().add(new SimpleItem(script, name, func));
        } else if (function2.equals("&removeMenubarItem") && locals.size() == 1) {
            String name = ((Scalar)locals.pop()).stringValue();
            this.menus.remove(name);
        }
        return null;
    }

    public void scriptLoaded(ScriptInstance si) {
        Hashtable env = si.getScriptEnvironment().getEnvironment();
        env.put("item", this);
        env.put("menu", this);
        env.put("menubar", this);
        env.put("&addItem", this);
        env.put("&addSeparator", this);
        env.put("&removeMenubarItem", this);
    }

    public JPopupMenu getPopupMenu(String description, HashMap data) {
        if (!this.menus.containsKey(description.toUpperCase())) {
            return null;
        }
        ScriptedPopupMenu.SetMenuData(data);
        JPopupMenu temp = (JPopupMenu)this.menus.get(description.toUpperCase());
        return temp;
    }

    public JPopupMenu getPrimaryPopup(String description) {
        if (!this.menubarMenus.containsKey(description)) {
            return null;
        }
        ScriptedPopupMenu.SetMenuData(new HashMap());
        ScriptedMenu temp = (ScriptedMenu)this.menubarMenus.get(description);
        return temp.getScriptedPopupMenu();
    }

    public void installMenubar(JMenuBar bar) {
        Iterator i = this.menubarMenus.values().iterator();
        while (i.hasNext()) {
            ScriptedMenu temp = (ScriptedMenu)i.next();
            if (temp.isValidCode()) {
                bar.add(temp);
                continue;
            }
            i.remove();
        }
        if (this.menus.containsKey(WINDOW_MENU)) {
            bar.add((JMenu)this.menus.get(WINDOW_MENU));
        }
        if (this.menus.containsKey(HELP_MENU)) {
            bar.add((JMenu)this.menus.get(HELP_MENU));
        }
    }

    public void scriptUnloaded(ScriptInstance si) {
    }
}

