/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import rero.bridges.event.CodeSnippet;

public abstract class ScriptedEventListener {
    protected boolean registered = false;
    protected List temporary = new LinkedList();
    protected List permanent = new LinkedList();

    public int dispatchEvent(HashMap eventDescription) {
        int rv = this.easyDispatch(this.temporary, eventDescription);
        if (rv == 1) {
            rv = this.easyDispatch(this.permanent, eventDescription);
        }
        return rv;
    }

    private int easyDispatch(List listeners, HashMap eventDescription) {
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            CodeSnippet l = (CodeSnippet)iter.next();
            if (l.isValid()) {
                int rv;
                if (listeners == this.temporary) {
                    iter.remove();
                }
                if (((rv = l.execute(eventDescription)) & 4) == 4 && listeners != this.temporary) {
                    iter.remove();
                }
                if ((rv & 2) != 2) continue;
                return 2;
            }
            iter.remove();
        }
        return 1;
    }

    public void addTemporaryListener(CodeSnippet c) {
        this.temporary.add(c);
    }

    public void addListener(CodeSnippet c) {
        this.permanent.add(c);
    }

    public abstract void setupListener();

    public boolean isSetup() {
        return this.registered;
    }

    public void setRegistered() {
        this.registered = true;
    }
}

