/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rero.bridges.event.CodeSnippet;
import rero.bridges.event.EventChatListener;
import rero.util.ClientUtils;
import rero.util.StringUtils;
import sleep.runtime.ScriptEnvironment;

public class FilterChatListener
extends EventChatListener {
    protected ScriptEnvironment env;
    protected String[] filter;
    protected String event;
    protected CodeSnippet code;
    protected int isPublic;
    private static final Pattern filterPattern = Pattern.compile("(.*?) (.*?) (.*)");

    public FilterChatListener(ScriptEnvironment _env, String _event, String _filter, CodeSnippet _code) {
        this.env = _env;
        this.event = _event.toUpperCase();
        if (this.event.equals("PUBLIC")) {
            this.isPublic = 1;
            this.event = "PRIVMSG";
        } else if (this.event.equals("PUBLIC_ACTION")) {
            this.isPublic = 1;
            this.event = "ACTION";
        } else if (this.event.equals("PRIVATE_ACTION")) {
            this.isPublic = 2;
            this.event = "ACTION";
        } else if (this.event.equals("MSG")) {
            this.isPublic = 2;
            this.event = "MSG";
        } else if (this.event.length() > 6 && this.event.substring(0, 5).equals("REPL_")) {
            this.isPublic = 0;
            this.event = this.event.substring(5, this.event.length());
        } else {
            this.isPublic = 0;
        }
        this.code = _code;
        this.filter = new String[3];
        _filter = this.env.evaluateExpression(_filter) + "";
        Matcher matcher = filterPattern.matcher(_filter.toUpperCase());
        if (matcher.matches()) {
            this.filter[0] = matcher.group(1);
            this.filter[1] = matcher.group(2);
            this.filter[2] = matcher.group(3);
            this.addListener(_code);
        } else {
            _env.getScriptInstance().fireWarning("Invalid format for event " + _event + " filter: " + _filter, _code.getLineNumber());
        }
    }

    private boolean isMatch(HashMap eventDescription) {
        String target = (eventDescription.get("$target") + "").toUpperCase();
        String from = (eventDescription.get("$source") + "").toUpperCase();
        String parms = (eventDescription.get("$parms") + "").toUpperCase();
        if (target.equals("")) {
            target = "<none>";
        }
        if (from.equals("")) {
            target = "<none>";
        }
        boolean check = true;
        if (this.isPublic > 0 && ClientUtils.isChannel(target)) {
            check = this.isPublic == 1;
        }
        return check && StringUtils.iswm(this.filter[0], from) && StringUtils.iswm(this.filter[1], target) && StringUtils.iswm(this.filter[2], parms);
    }

    public boolean isChatEvent(String eventId, HashMap eventDescription) {
        if (!this.code.isValid()) {
            return false;
        }
        return eventId.toUpperCase().equals(this.event) && this.isMatch(eventDescription);
    }
}

