/*
 * Decompiled with CFR 0.152.
 */
package rero.bridges.event;

import java.util.HashMap;
import java.util.Hashtable;
import rero.bridges.event.CodeSnippet;
import rero.bridges.event.EventChatListener;
import rero.bridges.event.FilterChatListener;
import rero.bridges.event.GeneralChatListener;
import rero.bridges.event.PredicateChatListener;
import rero.bridges.event.PrivateChatListener;
import rero.bridges.event.PublicChatListener;
import rero.bridges.event.ScriptedEventListener;
import rero.ircfw.ChatFramework;
import rero.ircfw.interfaces.ChatListener;
import sleep.engine.Block;
import sleep.engine.atoms.Check;
import sleep.interfaces.Environment;
import sleep.interfaces.FilterEnvironment;
import sleep.interfaces.Loadable;
import sleep.interfaces.PredicateEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class EventBridge
implements Loadable,
Environment,
PredicateEnvironment,
FilterEnvironment {
    protected HashMap listeners = new HashMap();
    protected ChatFramework framework;
    protected HashMap registeredEvents = new HashMap();
    protected HashMap unloadEvents = new HashMap();

    public void announceFramework(ChatFramework f) {
        this.framework = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptUnloaded(ScriptInstance si) {
        if (this.unloadEvents.get(si) != null) {
            Block code = (Block)this.unloadEvents.get(si);
            this.unloadEvents.remove(si);
            ScriptVariables scriptVariables = si.getScriptEnvironment().getScriptVariables();
            synchronized (scriptVariables) {
                si.getScriptEnvironment().getScriptVariables().pushLocalLevel();
                SleepUtils.runCode(code, si.getScriptEnvironment());
                si.getScriptEnvironment().getScriptVariables().popLocalLevel();
            }
        }
    }

    public void scriptLoaded(ScriptInstance si) {
        Hashtable _env = si.getScriptEnvironment().getEnvironment();
        _env.put("on", this);
        _env.put("wait", this);
    }

    public void registerEvent(String name, ScriptedEventListener listener) {
        this.registeredEvents.put(name.toUpperCase(), listener);
    }

    protected EventChatListener getNewListenerFor(String event_name) {
        if (event_name.equals("PUBLIC")) {
            return new PublicChatListener("PRIVMSG");
        }
        if (event_name.equals("PUBLIC_ACTION")) {
            return new PublicChatListener("ACTION");
        }
        if (event_name.equals("PRIVATE_ACTION")) {
            return new PrivateChatListener("ACTION");
        }
        if (event_name.equals("MSG")) {
            return new PrivateChatListener("PRIVMSG");
        }
        if (event_name.length() > 6 && event_name.substring(0, 5).equals("REPL_")) {
            return new GeneralChatListener(event_name.substring(5, event_name.length()));
        }
        return new GeneralChatListener(event_name);
    }

    protected EventChatListener getListenerFor(String event_name) {
        if (this.listeners.get(event_name) == null) {
            this.listeners.put(event_name, this.getNewListenerFor(event_name));
            this.framework.addChatListener((ChatListener)this.listeners.get(event_name));
        }
        return (EventChatListener)this.listeners.get(event_name);
    }

    public void bindFilteredFunction(ScriptInstance si, String typeKeyword, String keyword, String filter, Block functionBody) {
        FilterChatListener temp = new FilterChatListener(si.getScriptEnvironment(), keyword, filter, new CodeSnippet(functionBody, si.getScriptEnvironment()));
        if (typeKeyword.equals("on")) {
            this.framework.addChatListener(temp);
        }
        if (typeKeyword.equals("wait")) {
            temp.setFlags(4);
            this.framework.addTemporaryListener(temp);
        }
    }

    public void bindPredicate(ScriptInstance si, String type, Check pred, Block code) {
        PredicateChatListener temp = new PredicateChatListener(si.getScriptEnvironment(), pred, new CodeSnippet(code, si.getScriptEnvironment()));
        if (type.equals("on")) {
            this.framework.addChatListener(temp);
        }
        if (type.equals("wait")) {
            temp.setFlags(4);
            this.framework.addTemporaryListener(temp);
        }
    }

    public void bindFunction(ScriptInstance si, String type, String name, Block code) {
        name = name.toUpperCase();
        if (type.equals("on") && name.equals("UNLOAD")) {
            this.unloadEvents.put(si, code);
        } else {
            if (this.registeredEvents.get(name) != null) {
                ScriptedEventListener temp = (ScriptedEventListener)this.registeredEvents.get(name);
                if (!temp.isSetup()) {
                    temp.setupListener();
                    temp.setRegistered();
                }
                if (type.equals("on")) {
                    temp.addListener(new CodeSnippet(code, si.getScriptEnvironment()));
                }
                if (type.equals("wait")) {
                    temp.addTemporaryListener(new CodeSnippet(code, si.getScriptEnvironment()));
                }
                return;
            }
            if (type.equals("on")) {
                EventChatListener temp = this.getListenerFor(name);
                temp.addListener(new CodeSnippet(code, si.getScriptEnvironment()));
            } else if (type.equals("wait")) {
                EventChatListener temp = this.getNewListenerFor(name);
                temp.addListener(new CodeSnippet(code, si.getScriptEnvironment()));
                temp.setFlags(4);
                this.framework.addTemporaryListener(temp);
            }
        }
    }
}

