/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.serialize;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import org.ru.amip.serialize.StringUtils;
import sleep.bridges.BridgeUtilities;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.HashContainer;
import sleep.engine.types.IntValue;
import sleep.engine.types.LongValue;
import sleep.engine.types.MyLinkedList;
import sleep.engine.types.NullValue;
import sleep.engine.types.ObjectValue;
import sleep.engine.types.StringValue;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SerializationBridge
implements Loadable {
    XStream xstream;

    public void scriptLoaded(ScriptInstance script) {
        this.xstream = new XStream();
        this.xstream.alias("sscalar", Scalar.class);
        this.xstream.alias("sarray", MyLinkedList.class);
        this.xstream.alias("shash", HashContainer.class);
        this.xstream.alias("sstring", StringValue.class);
        this.xstream.alias("sdouble", DoubleValue.class);
        this.xstream.alias("sint", IntValue.class);
        this.xstream.alias("slong", LongValue.class);
        this.xstream.alias("snull", NullValue.class);
        this.xstream.alias("sobject", ObjectValue.class);
        Hashtable environment = script.getScriptEnvironment().getEnvironment();
        environment.put("&serialize", new Serialize());
        environment.put("&serialize_file", new SerializeFile());
        environment.put("&deserialize", new Deserialize());
        environment.put("&deserialize_file", new DeserializeFile());
    }

    public void scriptUnloaded(ScriptInstance script) {
        this.xstream = null;
    }

    class DeserializeFile
    implements Function {
        DeserializeFile() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            String file = BridgeUtilities.getString((Stack)passedInLocals, null);
            if (file == null) {
                return SleepUtils.getEmptyScalar();
            }
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                Scalar scalar = (Scalar)SerializationBridge.this.xstream.fromXML((InputStream)is);
                is.close();
                return scalar;
            }
            catch (FileNotFoundException e) {
                return SleepUtils.getEmptyScalar();
            }
            catch (IOException e) {
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    class Deserialize
    implements Function {
        Deserialize() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            String xml = BridgeUtilities.getString((Stack)passedInLocals, null);
            if (xml != null) {
                return (Scalar)SerializationBridge.this.xstream.fromXML(xml);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    class SerializeFile
    implements Function {
        SerializeFile() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            Scalar scalar = BridgeUtilities.getScalar((Stack)passedInLocals);
            String file = BridgeUtilities.getString((Stack)passedInLocals, null);
            if (file == null) {
                return SleepUtils.getScalar((int)0);
            }
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                SerializationBridge.this.xstream.toXML((Object)scalar, (OutputStream)os);
                os.close();
            }
            catch (FileNotFoundException e) {
                return SleepUtils.getScalar((int)-1);
            }
            catch (IOException e) {
                return SleepUtils.getScalar((int)-2);
            }
            return SleepUtils.getScalar((int)1);
        }
    }

    class Serialize
    implements Function {
        Serialize() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            Scalar scalar = BridgeUtilities.getScalar((Stack)passedInLocals);
            String xml = SerializationBridge.this.xstream.toXML((Object)scalar);
            xml = StringUtils.replace(xml, "\n", "");
            return SleepUtils.getScalar((String)xml);
        }
    }
}

