
import sleep.interfaces.Loadable;
import sleep.interfaces.Function;
import sleep.runtime.ScriptInstance;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import sleep.bridges.BridgeUtilities;

import java.util.Stack;
import java.io.UnsupportedEncodingException;

/**
 * Created by IntelliJ IDEA.
 * User: Serge Baranov
 * Date: Apr 9, 2005
 * Time: 12:40:54 AM
 */
public class CharsetRecode implements Loadable, Function {
  public boolean scriptLoaded(ScriptInstance si) {
    si.getScriptEnvironment().getEnvironment().put("&charset_encode", this);
    si.getScriptEnvironment().getEnvironment().put("&charset_decode", this);
    return true;
  }

  public boolean scriptUnloaded(ScriptInstance scriptInstance) {
    return true;
  }

  public Scalar evaluate(String name, ScriptInstance scriptInstance, Stack locals) {
    String text, charset, ourcharset;
    text = BridgeUtilities.getString(locals, "");
    charset = BridgeUtilities.getString(locals, "UTF-8");
    ourcharset = BridgeUtilities.getString(locals, "UTF-8");

    try {
      if ("&charset_encode".equals(name))
        return SleepUtils.getScalar(Encode(text, charset, ourcharset));

      if ("&charset_decode".equals(name))
        return SleepUtils.getScalar(Decode(text, charset, ourcharset));
    } catch (Exception ex) { }

    return SleepUtils.getEmptyScalar();
  }


  public static String Encode(String text, String tocharset, String ourcharset) throws UnsupportedEncodingException {
    byte[] bytes = text.getBytes(tocharset);
    return new String(bytes, ourcharset);
  }

  public static String Decode(String text, String tocharset, String ourcharset) throws UnsupportedEncodingException {
    byte[] bytes = text.getBytes(ourcharset);
    return new String(bytes, tocharset);
  }
}
