/*
 * Decompiled with CFR 0.152.
 */
package org.ululatus.sleep.bridges;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Stack;
import org.ululatus.sleep.bridges.ExtendableClassLoader;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ClassloaderBridge
implements Loadable {
    private static Hashtable loaders = new Hashtable();
    private static final Class[] parameters = new Class[]{URL.class};
    static /* synthetic */ Class class$sleep$interfaces$Loadable;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public boolean scriptLoaded(ScriptInstance script) {
        loaders.put(script, new ExtendableClassLoader());
        Hashtable environment = script.getScriptEnvironment().getEnvironment();
        environment.put("&addClassPath", new AddClassPath());
        environment.put("&getClassPath", new GetClassPath());
        environment.put("&loadClass", new LoadClass());
        environment.put("&useClass", new UseClass());
        environment.put("&useLoadable", new UseLoadable());
        AddLibPath libPath = new AddLibPath();
        environment.put("&addLibraryPath", libPath);
        environment.put("&addBinaryPath", libPath);
        environment.put("&isLibraryPath", new IsLibPath());
        environment.put("&loadLibrary", new LoadLibrary());
        environment.put("&addSysClassPath", new AddSysClassPath());
        return true;
    }

    public boolean scriptUnloaded(ScriptInstance script) {
        ExtendableClassLoader loader = (ExtendableClassLoader)loaders.get(script);
        loader.removeAllPaths();
        loaders.remove(script);
        loader = null;
        System.gc();
        return true;
    }

    private static void addFile(String s) throws IOException {
        File f = new File(s);
        URL url = f.toURL();
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    private static class AddSysClassPath
    implements Function {
        private AddSysClassPath() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getScalar((int)0);
            try {
                String path = BridgeUtilities.getString((Stack)args, (String)"");
                ClassloaderBridge.addFile(path);
                result = SleepUtils.getScalar((int)1);
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return result;
        }
    }

    private static class LoadLibrary
    implements Function {
        private LoadLibrary() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            String library = BridgeUtilities.getString((Stack)args, (String)"");
            if (library.length() == 0) {
                return SleepUtils.getScalar((int)0);
            }
            try {
                System.loadLibrary(library);
                return SleepUtils.getScalar((int)1);
            }
            catch (Throwable e) {
                script.getScriptEnvironment().flagError(e.toString());
                return SleepUtils.getScalar((int)0);
            }
        }
    }

    private static class IsLibPath
    implements Function {
        private IsLibPath() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getScalar((int)0);
            String path = BridgeUtilities.getString((Stack)args, (String)"");
            if (path.length() == 0) {
                return result;
            }
            try {
                File libdir = new File(path).getCanonicalFile();
                path = libdir.toString();
                if (!libdir.isDirectory()) {
                    return result;
                }
                Field usr_paths = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassloaderBridge.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
                usr_paths.setAccessible(true);
                Object value = usr_paths.get(null);
                String[] currentpaths = (String[])value;
                for (int i = 0; i < currentpaths.length; ++i) {
                    if (!currentpaths[i].equals(path)) continue;
                    result = SleepUtils.getScalar((int)1);
                    break;
                }
            }
            catch (Exception e) {
                script.getScriptEnvironment().flagError(e.toString());
            }
            return result;
        }
    }

    private static class AddLibPath
    implements Function {
        private AddLibPath() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getScalar((int)0);
            String path = BridgeUtilities.getString((Stack)args, (String)"");
            if (path.length() == 0) {
                return result;
            }
            try {
                File libdir = new File(path).getCanonicalFile();
                if (!libdir.isDirectory()) {
                    libdir = libdir.getParentFile();
                }
                if (!libdir.isDirectory()) {
                    return result;
                }
                Field usr_paths = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassloaderBridge.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
                usr_paths.setAccessible(true);
                String[] value = usr_paths.get(null);
                String[] currentpaths = value;
                String[] newpaths = new String[currentpaths.length + 1];
                System.arraycopy(currentpaths, 0, newpaths, 0, currentpaths.length);
                newpaths[currentpaths.length] = libdir.toString();
                value = newpaths;
                usr_paths.set(null, value);
                result = SleepUtils.getScalar((int)1);
            }
            catch (Exception e) {
                script.getScriptEnvironment().flagError(e.toString());
            }
            return result;
        }
    }

    private static class UseLoadable
    implements Function {
        private UseLoadable() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Loadable bridge = (Loadable)BridgeUtilities.getObject((Stack)args);
            try {
                bridge.scriptLoaded(script);
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class UseClass
    implements Function {
        private UseClass() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            try {
                Object obj = BridgeUtilities.getObject((Stack)args);
                if (obj instanceof Class && (class$sleep$interfaces$Loadable == null ? (class$sleep$interfaces$Loadable = ClassloaderBridge.class$("sleep.interfaces.Loadable")) : class$sleep$interfaces$Loadable).isAssignableFrom((Class)obj)) {
                    Class bridge = (Class)obj;
                    Loadable temp = (Loadable)bridge.newInstance();
                    temp.scriptLoaded(script);
                } else if (obj instanceof String) {
                    String bridge = (String)obj;
                    ExtendableClassLoader loader = (ExtendableClassLoader)loaders.get(script);
                    Class c = loader.findClass(bridge);
                    if (c != null && (class$sleep$interfaces$Loadable == null ? (class$sleep$interfaces$Loadable = ClassloaderBridge.class$("sleep.interfaces.Loadable")) : class$sleep$interfaces$Loadable).isAssignableFrom(c)) {
                        Loadable temp = (Loadable)c.newInstance();
                        temp.scriptLoaded(script);
                        return SleepUtils.getScalar((int)1);
                    }
                }
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class LoadClass
    implements Function {
        private LoadClass() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getEmptyScalar();
            String classname = BridgeUtilities.getString((Stack)args, (String)"");
            try {
                ExtendableClassLoader loader = (ExtendableClassLoader)loaders.get(script);
                Class c = loader.findClass(classname);
                if (c != null) {
                    result = SleepUtils.getScalar((Object)c);
                }
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return result;
        }
    }

    private static class GetClassPath
    implements Function {
        private GetClassPath() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getEmptyScalar();
            try {
                ExtendableClassLoader loader = (ExtendableClassLoader)loaders.get(script);
                SleepUtils.getScalar((String)loader.getClasspath());
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return result;
        }
    }

    private static class AddClassPath
    implements Function {
        private AddClassPath() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            Scalar result = SleepUtils.getScalar((int)0);
            try {
                String path = BridgeUtilities.getString((Stack)args, (String)"");
                ExtendableClassLoader loader = (ExtendableClassLoader)loaders.get(script);
                if (loader.extendClasspath(path)) {
                    result = SleepUtils.getScalar((int)1);
                }
            }
            catch (Exception ex) {
                script.getScriptEnvironment().flagError(ex.toString());
            }
            return result;
        }
    }
}

