/*
 * Decompiled with CFR 0.152.
 */
package socksshttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import socksshttp.CProxy;
import socksshttp.CSocks4;
import socksshttp.LogHelper;

public class CSocks5
extends CSocks4 {
    private Log log = LogFactory.getLog((Class)CSocks5.class);
    static final byte SOCKS5_Version = 5;
    static final int MaxAddrLen = 255;
    static final byte SC_UDP = 3;
    protected DatagramSocket DGSocket;
    protected DatagramPacket DGPack;
    private InetAddress UDP_IA;
    private int UDP_port;
    public byte RSV;
    public byte ATYP;
    static final int[] ADDR_Size = new int[]{-1, 4, -1, -1, 16};
    static final byte[] SRE_Accept = new byte[]{5, 0};

    protected byte getSuccessCode() {
        return 0;
    }

    protected byte getFailCode() {
        return 4;
    }

    public CSocks5(CProxy Parent) {
        super(Parent);
        this.DST_Addr = new byte[255];
    }

    public InetAddress calcInetAddress(byte AType, byte[] addr) {
        InetAddress IA;
        switch (AType) {
            case 1: {
                IA = super.calcInetAddress(addr);
                break;
            }
            case 3: {
                if (addr[0] <= 0) {
                    this.log.error((Object)("SOCKS 5 - calcInetAddress() : BAD IP in command - size : " + addr[0]));
                    return null;
                }
                String sIA = "";
                for (int i = 1; i <= addr[0]; ++i) {
                    sIA = sIA + (char)addr[i];
                }
                try {
                    IA = InetAddress.getByName(sIA);
                    break;
                }
                catch (UnknownHostException e) {
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        return IA;
    }

    public boolean Calculate_Address() {
        this.m_ServerIP = this.calcInetAddress(this.ATYP, this.DST_Addr);
        this.m_nServerPort = this.calcPort(this.DST_Port[0], this.DST_Port[1]);
        this.m_ClientIP = this.m_Parent.m_ClientSocket.getInetAddress();
        this.m_nClientPort = this.m_Parent.m_ClientSocket.getPort();
        return this.m_ServerIP != null && this.m_nServerPort >= 0;
    }

    public void Authenticate(byte SOCKS_Ver) throws Exception {
        super.Authenticate(SOCKS_Ver);
        if (this.SOCKS_Version == 5) {
            if (!this.CheckAuthentication()) {
                this.Refuse_Authentication("SOCKS 5 - Not Supported Authentication!");
                throw new Exception("SOCKS 5 - Not Supported Authentication.");
            }
        } else {
            this.Refuse_Authentication("Incorrect SOCKS version : " + this.SOCKS_Version);
            throw new Exception("Not Supported SOCKS Version -'" + this.SOCKS_Version + "'");
        }
        this.Accept_Authentication();
    }

    public void Refuse_Authentication(String msg) {
        this.log.info((Object)("SOCKS 5 - Refuse Authentication: '" + msg + "'"));
        this.m_Parent.SendToClient(SRE_Refuse);
    }

    public void Accept_Authentication() {
        this.log.info((Object)"SOCKS 5 - Accepts Auth. method 'NO_AUTH'");
        CSocks5.SRE_Accept[0] = this.SOCKS_Version;
        this.m_Parent.SendToClient(SRE_Accept);
    }

    public boolean CheckAuthentication() throws Exception {
        int Methods_Num = this.GetByte();
        String Methods = "";
        for (int i = 0; i < Methods_Num; ++i) {
            Methods = Methods + ",-" + this.GetByte() + '-';
        }
        return Methods.indexOf("-0-") != -1 || Methods.indexOf("-00-") != -1;
    }

    public void GetClientCommand() throws Exception {
        this.SOCKS_Version = this.GetByte();
        this.Command = this.GetByte();
        this.RSV = this.GetByte();
        this.ATYP = this.GetByte();
        int Addr_Len = ADDR_Size[this.ATYP];
        this.DST_Addr[0] = this.GetByte();
        if (this.ATYP == 3) {
            Addr_Len = this.DST_Addr[0] + 1;
        }
        for (int i = 1; i < Addr_Len; ++i) {
            this.DST_Addr[i] = this.GetByte();
        }
        this.DST_Port[0] = this.GetByte();
        this.DST_Port[1] = this.GetByte();
        if (this.SOCKS_Version != 5) {
            this.log.info((Object)("SOCKS 5 - Incorrect SOCKS Version of Command: " + this.SOCKS_Version));
            this.Refuse_Command((byte)-1);
            throw new Exception("Incorrect SOCKS Version of Command: " + this.SOCKS_Version);
        }
        if (this.Command < 1 || this.Command > 3) {
            this.log.error((Object)("SOCKS 5 - GetClientCommand() - Unsupported Command : \"" + this.commName(this.Command) + "\""));
            this.Refuse_Command((byte)7);
            throw new Exception("SOCKS 5 - Unsupported Command: \"" + this.Command + "\"");
        }
        if (this.ATYP == 4) {
            this.log.error((Object)"SOCKS 5 - GetClientCommand() - Unsupported Address Type - IP v6");
            this.Refuse_Command((byte)8);
            throw new Exception("Unsupported Address Type - IP v6");
        }
        if (this.ATYP >= 4 || this.ATYP <= 0) {
            this.log.error((Object)("SOCKS 5 - GetClientCommand() - Unsupported Address Type: " + this.ATYP));
            this.Refuse_Command((byte)8);
            throw new Exception("SOCKS 5 - Unsupported Address Type: " + this.ATYP);
        }
        if (!this.Calculate_Address()) {
            this.Refuse_Command((byte)4);
            throw new Exception("SOCKS 5 - Unknown Host/IP address '" + this.m_ServerIP.toString() + "'");
        }
        this.log.info((Object)("SOCKS 5 - Accepted SOCKS5 Command: \"" + this.commName(this.Command) + "\""));
    }

    public void Reply_Command(byte ReplyCode) {
        int pt;
        this.log.info((Object)("SOCKS 5 - Reply to Client \"" + this.ReplyName(ReplyCode) + "\""));
        byte[] REPLY = new byte[10];
        byte[] IP = new byte[4];
        if (this.m_Parent.m_ServerSocket != null) {
            InetAddress IA = this.m_Parent.m_ServerSocket.getInetAddress();
            IP = IA.getAddress();
            pt = this.m_Parent.m_ServerSocket.getLocalPort();
        } else {
            IP[0] = 0;
            IP[1] = 0;
            IP[2] = 0;
            IP[3] = 0;
            pt = 0;
        }
        REPLY[0] = 5;
        REPLY[1] = ReplyCode;
        REPLY[2] = 0;
        REPLY[3] = 1;
        REPLY[4] = IP[0];
        REPLY[5] = IP[1];
        REPLY[6] = IP[2];
        REPLY[7] = IP[3];
        REPLY[8] = (byte)((pt & 0xFF00) >> 8);
        REPLY[9] = (byte)(pt & 0xFF);
        this.m_Parent.SendToClient(REPLY);
    }

    public void BIND_Reply(byte ReplyCode, InetAddress IA, int PT) {
        byte[] IP = new byte[]{0, 0, 0, 0};
        this.log.info((Object)("BIND Reply to Client \"" + this.ReplyName(ReplyCode) + "\""));
        byte[] REPLY = new byte[10];
        if (IA != null) {
            IP = IA.getAddress();
        }
        REPLY[0] = 5;
        REPLY[1] = (byte)(ReplyCode - 90);
        REPLY[2] = 0;
        REPLY[3] = 1;
        REPLY[4] = IP[0];
        REPLY[5] = IP[1];
        REPLY[6] = IP[2];
        REPLY[7] = IP[3];
        REPLY[8] = (byte)((PT & 0xFF00) >> 8);
        REPLY[9] = (byte)(PT & 0xFF);
        if (this.m_Parent.isActive()) {
            this.m_Parent.SendToClient(REPLY);
        } else {
            this.log.info((Object)"BIND - Closed Client Connection");
        }
    }

    public void UDP_Reply(byte ReplyCode, InetAddress IA, int PT) throws IOException {
        this.log.info((Object)("Reply to Client \"" + this.ReplyName(ReplyCode) + "\""));
        if (this.m_Parent.m_ClientSocket == null) {
            this.log.info((Object)"Error in UDP_Reply() - Client socket is NULL");
        }
        byte[] IP = IA.getAddress();
        byte[] REPLY = new byte[]{5, ReplyCode, 0, 1, IP[0], IP[1], IP[2], IP[3], (byte)((PT & 0xFF00) >> 8), (byte)(PT & 0xFF)};
        this.m_Parent.SendToClient(REPLY);
    }

    public void UDP() throws IOException {
        try {
            this.DGSocket = new DatagramSocket();
            this.Init_UDP_InOut();
        }
        catch (IOException e) {
            this.Refuse_Command((byte)5);
            throw new IOException("Connection Refused - FAILED TO INITIALIZE UDP Association.");
        }
        InetAddress MyIP = this.m_Parent.m_ClientSocket.getLocalAddress();
        int MyPort = this.DGSocket.getLocalPort();
        this.UDP_Reply((byte)0, MyIP, MyPort);
        this.log.info((Object)("UDP Listen at: <" + MyIP.toString() + ":" + MyPort + ">"));
        while (this.m_Parent.CheckClientData() >= 0) {
            this.ProcessUDP();
            Thread.yield();
        }
        this.log.info((Object)"UDP - Closed TCP Master of UDP Association");
    }

    private void Init_UDP_InOut() throws IOException {
        this.DGSocket.setSoTimeout(10);
        this.m_Parent.m_Buffer = new byte[this.m_Parent.m_BufLen];
        this.DGPack = new DatagramPacket(this.m_Parent.m_Buffer, this.m_Parent.m_BufLen);
    }

    private byte[] AddDGPhead(byte[] Buffer) {
        byte[] IABuf = this.DGPack.getAddress().getAddress();
        int DGport = this.DGPack.getPort();
        int HeaderLen = 6 + IABuf.length;
        int DataLen = this.DGPack.getLength();
        int NewPackLen = HeaderLen + DataLen;
        byte[] UB = new byte[NewPackLen];
        UB[0] = 0;
        UB[1] = 0;
        UB[2] = 0;
        UB[3] = 1;
        System.arraycopy(IABuf, 0, UB, 4, IABuf.length);
        UB[4 + IABuf.length] = (byte)(DGport >> 8 & 0xFF);
        UB[5 + IABuf.length] = (byte)(DGport & 0xFF);
        System.arraycopy(Buffer, 0, UB, 6 + IABuf.length, DataLen);
        System.arraycopy(UB, 0, Buffer, 0, NewPackLen);
        return UB;
    }

    private byte[] ClearDGPhead(byte[] Buffer) {
        int IAlen;
        int p = 4;
        byte AType = Buffer[3];
        switch (AType) {
            case 1: {
                IAlen = 4;
                break;
            }
            case 3: {
                IAlen = Buffer[p] + 1;
                break;
            }
            default: {
                this.log.info((Object)("Error in ClearDGPhead() - Invalid Destination IP Addres type " + AType));
                return null;
            }
        }
        byte[] IABuf = new byte[IAlen];
        System.arraycopy(Buffer, p, IABuf, 0, IAlen);
        p += IAlen;
        this.UDP_IA = this.calcInetAddress(AType, IABuf);
        this.UDP_port = this.calcPort(Buffer[p++], Buffer[p++]);
        if (this.UDP_IA == null) {
            this.log.info((Object)"Error in ClearDGPHead() - Invalid UDP dest IP address: NULL");
            return null;
        }
        int DataLen = this.DGPack.getLength();
        byte[] UB = new byte[DataLen -= p];
        System.arraycopy(Buffer, p, UB, 0, DataLen);
        System.arraycopy(UB, 0, Buffer, 0, DataLen);
        return UB;
    }

    protected void UDPSend(DatagramPacket DGP) {
        if (DGP == null) {
            return;
        }
        String LogString = DGP.getAddress() + ":" + DGP.getPort() + "> : " + DGP.getLength() + " bytes";
        try {
            this.DGSocket.send(DGP);
        }
        catch (IOException e) {
            this.log.info((Object)("Error in ProcessUDPClient() - Failed to Send DGP to " + LogString));
        }
    }

    public void ProcessUDP() {
        try {
            this.DGSocket.receive(this.DGPack);
        }
        catch (InterruptedIOException e) {
            return;
        }
        catch (IOException e) {
            this.log.info((Object)("Error in ProcessUDP() - " + e.toString()));
            return;
        }
        if (this.m_ClientIP.equals(this.DGPack.getAddress())) {
            this.ProcessUDPClient();
        } else {
            this.ProcessUDPRemote();
        }
        try {
            this.Init_UDP_InOut();
        }
        catch (IOException e) {
            this.log.info((Object)("IOError in Init_UDP_IO() - " + e.toString()));
            this.m_Parent.Close();
        }
    }

    public void ProcessUDPClient() {
        this.m_nClientPort = this.DGPack.getPort();
        byte[] Buf = this.ClearDGPhead(this.DGPack.getData());
        if (Buf == null) {
            return;
        }
        if (Buf.length <= 0) {
            return;
        }
        if (this.UDP_IA == null) {
            this.log.info((Object)"Error in ProcessUDPClient() - Invalid Destination IP - NULL");
            return;
        }
        if (this.UDP_port == 0) {
            this.log.info((Object)"Error in ProcessUDPClient() - Invalid Destination Port - 0");
            return;
        }
        if (this.m_ServerIP != this.UDP_IA || this.m_nServerPort != this.UDP_port) {
            this.m_ServerIP = this.UDP_IA;
            this.m_nServerPort = this.UDP_port;
        }
        this.log.info((Object)("Datagram : " + Buf.length + " bytes : " + LogHelper.getSocketInfo(this.DGPack) + " >> <" + LogHelper.IP2Str(this.m_ServerIP) + ":" + this.m_nServerPort + ">"));
        DatagramPacket DGPSend = new DatagramPacket(Buf, Buf.length, this.UDP_IA, this.UDP_port);
        this.UDPSend(DGPSend);
    }

    public void ProcessUDPRemote() {
        this.log.info((Object)("Datagram : " + this.DGPack.getLength() + " bytes : " + "<" + LogHelper.IP2Str(this.m_ClientIP) + ":" + this.m_nClientPort + "> << " + LogHelper.getSocketInfo(this.DGPack)));
        InetAddress DGP_IP = this.DGPack.getAddress();
        int DGP_Port = this.DGPack.getPort();
        byte[] Buf = this.AddDGPhead(this.m_Parent.m_Buffer);
        if (Buf == null) {
            return;
        }
        DatagramPacket DGPSend = new DatagramPacket(Buf, Buf.length, this.m_ClientIP, this.m_nClientPort);
        this.UDPSend(DGPSend);
        if (DGP_IP != this.UDP_IA || DGP_Port != this.UDP_port) {
            this.m_ServerIP = DGP_IP;
            this.m_nServerPort = DGP_Port;
        }
    }
}

