/*
 * Decompiled with CFR 0.152.
 */
package socksshttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import socksshttp.CProxy;
import socksshttp.LogHelper;

public class CSocks4 {
    private Log log = LogFactory.getLog((Class)CSocks4.class);
    public byte SOCKS_Version;
    static final byte SOCKS4_Version = 4;
    static byte[] SRE_Refuse = new byte[]{5, -1};
    static byte[] SRE_Accept = new byte[]{5, 0};
    public CProxy m_Parent;
    public byte Command;
    public byte[] DST_Port = null;
    public byte[] DST_Addr = null;
    public byte[] UserID = null;
    public String UID = "";
    static final byte SC_CONNECT = 1;
    static final byte SC_BIND = 2;
    static final byte SC_UDP = 3;
    protected InetAddress m_ServerIP;
    protected int m_nServerPort;
    protected InetAddress m_ClientIP;
    protected int m_nClientPort;
    public InetAddress m_ExtLocalIP;

    protected byte getSuccessCode() {
        return 90;
    }

    protected byte getFailCode() {
        return 91;
    }

    public InetAddress getClientAddress() {
        return this.m_ClientIP;
    }

    public InetAddress getServerAddress() {
        return this.m_ServerIP;
    }

    public int getClientPort() {
        return this.m_nClientPort;
    }

    public int getServerPort() {
        return this.m_nServerPort;
    }

    public String commName(byte code) {
        switch (code) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "BIND";
            }
            case 3: {
                return "UDP Association";
            }
        }
        return "Unknown Command";
    }

    public String ReplyName(byte code) {
        switch (code) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "General SOCKS Server failure";
            }
            case 2: {
                return "Connection not allowed by ruleset";
            }
            case 3: {
                return "Network Unreachable";
            }
            case 4: {
                return "HOST Unreachable";
            }
            case 5: {
                return "Connection Refused";
            }
            case 6: {
                return "TTL Expired";
            }
            case 7: {
                return "Command not supported";
            }
            case 8: {
                return "Address Type not Supported";
            }
            case 9: {
                return "to 0xFF UnAssigned";
            }
            case 90: {
                return "Request GRANTED";
            }
            case 91: {
                return "Request REJECTED or FAILED";
            }
            case 92: {
                return "Request REJECTED - SOCKS server can't connect to Identd on the client";
            }
            case 93: {
                return "Request REJECTED - Client and Identd report diff user-ID";
            }
        }
        return "Unknown Command";
    }

    public CSocks4(CProxy Parent) {
        this.m_Parent = Parent;
        this.DST_Addr = new byte[4];
        this.DST_Port = new byte[2];
    }

    public void Calculate_UserID() {
        String s = this.UID + " ";
        this.UserID = s.getBytes();
        this.UserID[this.UserID.length - 1] = 0;
    }

    public int byte2int(byte b) {
        int res = b;
        if (res < 0) {
            res = 256 + res;
        }
        return res;
    }

    public int calcPort(byte Hi, byte Lo) {
        return this.byte2int(Hi) << 8 | this.byte2int(Lo);
    }

    public InetAddress calcInetAddress(byte[] addr) {
        InetAddress IA;
        String sIA = "";
        if (addr.length < 4) {
            this.log.error((Object)("calcInetAddress() - Invalid length of IP v4 - " + addr.length + " bytes"));
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            sIA = sIA + this.byte2int(addr[i]);
            if (i >= 3) continue;
            sIA = sIA + ".";
        }
        try {
            IA = InetAddress.getByName(sIA);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return IA;
    }

    public boolean Calculate_Address() {
        this.m_ServerIP = this.calcInetAddress(this.DST_Addr);
        this.m_nServerPort = this.calcPort(this.DST_Port[0], this.DST_Port[1]);
        this.m_ClientIP = this.m_Parent.m_ClientSocket.getInetAddress();
        this.m_nClientPort = this.m_Parent.m_ClientSocket.getPort();
        return this.m_ServerIP != null && this.m_nServerPort >= 0;
    }

    protected byte GetByte() {
        byte b;
        try {
            b = this.m_Parent.GetByteFromClient();
        }
        catch (Exception e) {
            b = 0;
        }
        return b;
    }

    public void Authenticate(byte SOCKS_Ver) throws Exception {
        this.SOCKS_Version = SOCKS_Ver;
    }

    public void GetClientCommand() throws Exception {
        byte b;
        this.Command = this.GetByte();
        this.DST_Port[0] = this.GetByte();
        this.DST_Port[1] = this.GetByte();
        for (int i = 0; i < 4; ++i) {
            this.DST_Addr[i] = this.GetByte();
        }
        while ((b = this.GetByte()) != 0) {
            this.UID = this.UID + (char)b;
        }
        this.Calculate_UserID();
        if (this.Command < 1 || this.Command > 2) {
            this.Refuse_Command((byte)91);
            throw new Exception("Socks 4 - Unsupported Command : " + this.commName(this.Command));
        }
        if (!this.Calculate_Address()) {
            this.Refuse_Command((byte)92);
            throw new Exception("Socks 4 - Unknown Host/IP address '" + this.m_ServerIP.toString());
        }
        this.log.info((Object)("Accepted SOCKS 4 Command: \"" + this.commName(this.Command) + "\""));
    }

    public void Reply_Command(byte ReplyCode) {
        this.log.info((Object)("Socks 4 reply: \"" + this.ReplyName(ReplyCode) + "\""));
        byte[] REPLY = new byte[]{0, ReplyCode, this.DST_Port[0], this.DST_Port[1], this.DST_Addr[0], this.DST_Addr[1], this.DST_Addr[2], this.DST_Addr[3]};
        this.m_Parent.SendToClient(REPLY);
    }

    protected void Refuse_Command(byte ErrorCode) {
        this.log.info((Object)("Socks 4 - Refuse Command: \"" + this.ReplyName(ErrorCode) + "\""));
        this.Reply_Command(ErrorCode);
    }

    protected void Connect() throws Exception {
        this.log.info((Object)"Connecting...");
        try {
            this.m_Parent.ConnectToServer(this.m_ServerIP.getHostAddress(), this.m_nServerPort);
        }
        catch (IOException e) {
            this.Refuse_Command(this.getFailCode());
            throw new Exception("Socks 4 - Can't connect to " + LogHelper.getSocketInfo(this.m_Parent.m_ServerSocket));
        }
        this.log.info((Object)("Connected to " + LogHelper.getSocketInfo(this.m_Parent.m_ServerSocket)));
        this.Reply_Command(this.getSuccessCode());
    }

    public void BIND_Reply(byte ReplyCode, InetAddress IA, int PT) throws IOException {
        byte[] IP = new byte[]{0, 0, 0, 0};
        this.log.info((Object)("Reply to Client : \"" + this.ReplyName(ReplyCode) + "\""));
        byte[] REPLY = new byte[8];
        if (IA != null) {
            IP = IA.getAddress();
        }
        REPLY[0] = 0;
        REPLY[1] = ReplyCode;
        REPLY[2] = (byte)((PT & 0xFF00) >> 8);
        REPLY[3] = (byte)(PT & 0xFF);
        REPLY[4] = IP[0];
        REPLY[5] = IP[1];
        REPLY[6] = IP[2];
        REPLY[7] = IP[3];
        if (this.m_Parent.isActive()) {
            this.m_Parent.SendToClient(REPLY);
        } else {
            this.log.info((Object)"Closed BIND Client Connection");
        }
    }

    public InetAddress ResolveExternalLocalIP() {
        InetAddress IP = null;
        if (this.m_ExtLocalIP != null) {
            Socket sct = null;
            try {
                sct = new Socket(this.m_ExtLocalIP, this.m_Parent.getSocksServer().getPort());
                IP = sct.getLocalAddress();
                sct.close();
                return this.m_ExtLocalIP;
            }
            catch (IOException e) {
                this.log.info((Object)"WARNING !!! THE LOCAL IP ADDRESS WAS CHANGED !");
            }
        }
        String[] hosts = new String[]{"www.sun.com", "www.microsoft.com", "www.aol.com", "www.altavista.com", "www.mirabilis.com", "www.yahoo.com"};
        for (int i = 0; i < hosts.length; ++i) {
            try {
                Socket sct = new Socket(InetAddress.getByName(hosts[i]), 80);
                IP = sct.getLocalAddress();
                sct.close();
                break;
            }
            catch (Exception e) {
                this.log.info((Object)("Error in BIND() - BIND reip Failed at " + i));
                continue;
            }
        }
        this.m_ExtLocalIP = IP;
        return IP;
    }

    protected void Bind() throws IOException {
        ServerSocket ssock;
        int MyPort = 0;
        this.log.info((Object)"Binding...");
        InetAddress MyIP = this.ResolveExternalLocalIP();
        if (MyIP != null) {
            this.log.info((Object)("Local IP : " + MyIP.toString()));
        }
        try {
            ssock = new ServerSocket(0);
            ssock.setSoTimeout(10);
            if (MyIP == null) {
                MyIP = ssock.getInetAddress();
            }
            MyPort = ssock.getLocalPort();
        }
        catch (IOException e) {
            this.log.info((Object)"Error in BIND() - Can't BIND at any Port");
            this.BIND_Reply((byte)92, MyIP, MyPort);
            return;
        }
        this.log.info((Object)("BIND at : <" + MyIP.toString() + ":" + MyPort + ">"));
        this.BIND_Reply((byte)90, MyIP, MyPort);
        Socket socket = null;
        while (socket == null) {
            if (this.m_Parent.CheckClientData() >= 0) {
                this.log.info((Object)"BIND - Client connection closed");
                return;
            }
            try {
                socket = ssock.accept();
                socket.setSoTimeout(10);
            }
            catch (InterruptedIOException e) {
                // empty catch block
            }
            Thread.yield();
        }
        this.m_ServerIP = socket.getInetAddress();
        this.m_nServerPort = socket.getPort();
        this.BIND_Reply((byte)90, socket.getInetAddress(), socket.getPort());
        this.m_Parent.m_ServerSocket = socket;
        this.m_Parent.PrepareServer();
        this.log.info((Object)("BIND Connection from " + LogHelper.getSocketInfo(this.m_Parent.m_ServerSocket)));
    }

    public void UDP() throws IOException {
        this.log.info((Object)"Error - Socks 4 don't support UDP Association!");
        this.log.info((Object)"Check your Software please...");
        this.Refuse_Command((byte)91);
    }
}

