/*
 * Decompiled with CFR 0.152.
 */
package socksshttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import socksshttp.CProxy;
import socksshttp.LogHelper;

public class CServer
implements Runnable {
    private Log log = LogFactory.getLog((Class)CServer.class);
    public static final int LISTEN_TIMEOUT = 200;
    public static final int DEFAULT_TIMEOUT = 200;
    private Object m_lock = this;
    protected volatile Thread m_TheThread;
    private ServerSocket m_ListenSocket;
    private int m_nPort;
    protected boolean m_bUseSHttpProxy;
    protected String m_cProxyHost;
    protected String m_cProxyUser;
    protected String m_cProxyPass;
    protected int m_nProxyPort;

    public int getPort() {
        return this.m_nPort;
    }

    public int getProxyPort() {
        return this.m_nProxyPort;
    }

    public String getProxyHost() {
        return this.m_cProxyHost;
    }

    public void setProxyUser(String m_cProxyUser) {
        this.m_cProxyUser = m_cProxyUser;
    }

    public void setProxyPass(String m_cProxyPass) {
        this.m_cProxyPass = m_cProxyPass;
    }

    public CServer(int ListenPort, boolean UseSHttpProxy, String ProxyHost, int ProxyPort) {
        this.m_nPort = ListenPort;
        this.m_bUseSHttpProxy = UseSHttpProxy;
        this.m_cProxyHost = ProxyHost;
        this.m_nProxyPort = ProxyPort;
        this.log.info((Object)"SOCKS Server Created.");
    }

    public void SetLock(Object lock) {
        this.m_lock = lock;
    }

    public void start() {
        this.m_TheThread = new Thread(this);
        this.m_TheThread.start();
        this.log.info((Object)"SOCKS Server Started.");
    }

    public void stop() {
        this.log.info((Object)"SOCKS Server Stopped.");
        this.Close();
        Thread tmp = this.m_TheThread;
        this.m_TheThread = null;
        if (tmp != null) {
            tmp.interrupt();
        }
    }

    public void run() {
        this.SetLock(this);
        this.Listen();
        this.Close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Close() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_ListenSocket != null) {
                try {
                    this.log.info((Object)"SOCKS Server Closed.");
                    this.m_ListenSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.m_ListenSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_ListenSocket != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PrepareToListen() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_ListenSocket = new ServerSocket(this.m_nPort, 0, InetAddress.getByName("127.0.0.1"));
            this.m_ListenSocket.setSoTimeout(200);
            if (this.m_nPort == 0) {
                this.m_nPort = this.m_ListenSocket.getLocalPort();
            }
            this.log.info((Object)("SOCKS Server Listen at Port : " + this.m_nPort));
        }
    }

    protected void Listen() {
        try {
            this.PrepareToListen();
        }
        catch (BindException e) {
            this.log.error((Object)("The Port " + this.m_nPort + " is in use !"));
            this.log.error((Object)e);
            return;
        }
        catch (IOException e) {
            this.log.error((Object)("IO Error Binding at port : " + this.m_nPort));
            return;
        }
        while (this.isActive()) {
            this.CheckClientConnection();
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CheckClientConnection() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_ListenSocket == null) {
                return;
            }
            try {
                Socket ClientSocket = this.m_ListenSocket.accept();
                ClientSocket.setSoTimeout(200);
                this.log.info((Object)("Connection from : " + LogHelper.getSocketInfo(ClientSocket)));
                CProxy Proxy2 = new CProxy(this, ClientSocket);
                Proxy2.start();
            }
            catch (InterruptedIOException e) {
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }
}

