/*
 * Decompiled with CFR 0.152.
 */
package socksshttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.ProxyClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import socksshttp.CServer;
import socksshttp.CSocks4;
import socksshttp.CSocks5;
import socksshttp.LogHelper;

public class CProxy
implements Runnable {
    private Log log = LogFactory.getLog((Class)CProxy.class);
    private Object m_lock = this;
    public static final int DEFAULT_BUF_SIZE = 4096;
    protected Thread m_TheThread;
    protected CServer m_SocksServer;
    public Socket m_ClientSocket;
    public Socket m_ServerSocket;
    public int m_BufLen = 4096;
    public byte[] m_Buffer = null;
    public InputStream m_ClientInput;
    public OutputStream m_ClientOutput;
    public InputStream m_ServerInput;
    public OutputStream m_ServerOutput;
    public static final int DEFAULT_TIMEOUT = 10;
    protected boolean m_bUseSHttpProxy;
    protected String m_cProxyHost;
    protected String m_cProxyUser;
    protected String m_cProxyPass;
    protected int m_nProxyPort;
    static final byte SOCKS5_Version = 5;
    static final byte SOCKS4_Version = 4;
    CSocks4 comm;
    public static final String EOL = "\r\n";

    public CServer getSocksServer() {
        return this.m_SocksServer;
    }

    public boolean doUseSHttpProxy() {
        return this.m_bUseSHttpProxy;
    }

    public int getProxyPort() {
        return this.m_nProxyPort;
    }

    public String getProxyHost() {
        return this.m_cProxyHost;
    }

    public CProxy(CServer SocksServer, Socket ClientSocket) {
        this.m_SocksServer = SocksServer;
        if (this.m_SocksServer == null) {
            this.Close();
            return;
        }
        this.m_ClientSocket = ClientSocket;
        if (this.m_ClientSocket != null) {
            try {
                this.m_ClientSocket.setSoTimeout(10);
            }
            catch (SocketException e) {
                this.log.error((Object)"Socket Exception during seting Timeout.");
            }
        }
        this.m_bUseSHttpProxy = this.m_SocksServer.m_bUseSHttpProxy;
        this.m_cProxyHost = this.m_SocksServer.m_cProxyHost;
        this.m_cProxyUser = this.m_SocksServer.m_cProxyUser;
        this.m_cProxyPass = this.m_SocksServer.m_cProxyPass;
        this.m_nProxyPort = this.m_SocksServer.m_nProxyPort;
        this.m_Buffer = new byte[this.m_BufLen];
        this.log.info((Object)"Proxy Created.");
    }

    public void SetLock(Object lock) {
        this.m_lock = lock;
    }

    public void start() {
        this.m_TheThread = new Thread(this);
        this.m_TheThread.start();
        this.log.info((Object)"Proxy Started.");
    }

    public void stop() {
        try {
            if (this.m_ClientSocket != null) {
                this.m_ClientSocket.close();
            }
            if (this.m_ServerSocket != null) {
                this.m_ServerSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_ClientSocket = null;
        this.m_ServerSocket = null;
        this.log.info((Object)"Proxy Stopped.");
        this.Close();
        Thread tmp = this.m_TheThread;
        this.m_TheThread = null;
        if (tmp != null) {
            tmp.interrupt();
        }
    }

    public void run() {
        this.SetLock(this);
        if (!this.PrepareClient()) {
            this.log.error((Object)"Proxy - client socket is null !");
            return;
        }
        this.ProcessRelay();
        this.Close();
    }

    public void Close() {
        try {
            if (this.m_ClientOutput != null) {
                this.m_ClientOutput.flush();
                this.m_ClientOutput.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.m_ServerOutput != null) {
                this.m_ServerOutput.flush();
                this.m_ServerOutput.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.m_ClientSocket != null) {
                this.m_ClientSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.m_ServerSocket != null) {
                this.m_ServerSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_ServerSocket = null;
        this.m_ClientSocket = null;
        this.log.info((Object)"Proxy Closed.");
    }

    public void SendToClient(byte[] Buf) {
        this.SendToClient(Buf, Buf.length);
    }

    public void SendToClient(byte[] Buf, int Len) {
        if (this.m_ClientOutput == null) {
            return;
        }
        if (Len <= 0 || Len > Buf.length) {
            return;
        }
        try {
            this.m_ClientOutput.write(Buf, 0, Len);
            this.m_ClientOutput.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"Sending data to client");
        }
    }

    public void SendToServer(byte[] Buf) {
        this.SendToServer(Buf, Buf.length);
    }

    public void SendToServer(byte[] Buf, int Len) {
        if (this.m_ServerOutput == null) {
            return;
        }
        if (Len <= 0 || Len > Buf.length) {
            return;
        }
        try {
            this.m_ServerOutput.write(Buf, 0, Len);
            this.m_ServerOutput.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"Sending data to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_ClientSocket != null && this.m_ServerSocket != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ConnectToServer(String Server, int port) throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            if (Server.length() == 0) {
                this.Close();
                this.log.error((Object)"Invalid Remote Host Name - Empty String !!!");
                return;
            }
            this.m_ServerSocket = this.makeHttpProxyConnection(Server, port, this.m_cProxyHost, this.m_nProxyPort, this.m_cProxyUser, this.m_cProxyPass);
            if (this.m_ServerSocket == null) {
                this.Close();
                this.log.error((Object)"Can't connect =(");
                return;
            }
            this.m_ServerSocket.setSoTimeout(10);
            this.log.info((Object)("Connected to " + LogHelper.getSocketInfo(this.m_ServerSocket)));
            this.PrepareServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket makeHttpProxyConnection(String host, int port, String proxyhost, int proxyport, String user, String pass) {
        String oldhost = System.setProperty("socksProxyHost", "");
        ProxyClient proxyclient = new ProxyClient();
        proxyclient.getHostConfiguration().setHost(host, port);
        proxyclient.getHostConfiguration().setProxy(proxyhost, proxyport);
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        proxyclient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        if (user != null && user.length() > 0) {
            proxyclient.getState().setProxyCredentials(new AuthScope(proxyhost, proxyport, null), (Credentials)new UsernamePasswordCredentials(user, pass));
        }
        ProxyClient.ConnectResponse response = null;
        try {
            response = proxyclient.connect();
        }
        catch (Exception e) {
            this.log.error((Object)("Can't connect: " + e.getMessage()));
            Socket socket = null;
            return socket;
        }
        catch (Throwable t) {
            this.log.error((Object)("Can't connect: " + t.getMessage()));
        }
        finally {
            System.setProperty("socksProxyHost", oldhost);
        }
        if (response.getSocket() != null) {
            return response.getSocket();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void PrepareServer() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_ServerInput = this.m_ServerSocket.getInputStream();
            this.m_ServerOutput = this.m_ServerSocket.getOutputStream();
        }
    }

    public boolean PrepareClient() {
        if (this.m_ClientSocket == null) {
            return false;
        }
        try {
            this.m_ClientInput = this.m_ClientSocket.getInputStream();
            this.m_ClientOutput = this.m_ClientSocket.getOutputStream();
        }
        catch (IOException e) {
            this.log.error((Object)"Proxy - can't get I/O streams!");
            this.log.error((Object)e);
            return false;
        }
        return true;
    }

    public void ProcessRelay() {
        try {
            byte SOCKS_Version = this.GetByteFromClient();
            switch (SOCKS_Version) {
                case 4: {
                    this.comm = new CSocks4(this);
                    break;
                }
                case 5: {
                    this.comm = new CSocks5(this);
                    break;
                }
                default: {
                    this.log.error((Object)("Invalid SOKCS version : " + SOCKS_Version));
                    return;
                }
            }
            this.log.info((Object)("Accepted SOCKS " + SOCKS_Version + " Request."));
            this.comm.Authenticate(SOCKS_Version);
            this.comm.GetClientCommand();
            switch (this.comm.Command) {
                case 1: {
                    this.comm.Connect();
                    this.Relay();
                    break;
                }
                case 2: {
                    this.comm.Bind();
                    this.Relay();
                    break;
                }
                case 3: {
                    this.comm.UDP();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public byte GetByteFromClient() throws Exception {
        while (this.m_ClientSocket != null) {
            int b;
            try {
                b = this.m_ClientInput.read();
            }
            catch (InterruptedIOException e) {
                Thread.yield();
                continue;
            }
            return (byte)b;
        }
        throw new Exception("Interrupted Reading GetByteFromClient()");
    }

    public void CreateSSLTunnel() throws Exception {
        this.log.info((Object)"Initiating SSL Tunneling...");
        String Host = this.comm.m_ServerIP.getHostAddress();
        String cmd = "CONNECT " + Host + ":" + this.comm.m_nServerPort + " HTTP/1.0" + EOL + EOL;
        this.SendToServer(cmd.getBytes());
        int dlen = 0;
        while (dlen == 0) {
            try {
                dlen = this.m_ServerInput.read(this.m_Buffer, 0, this.m_BufLen);
                if (dlen <= 0) continue;
                String s = new String(this.m_Buffer, 0, dlen);
                if (s.startsWith("HTTP/1.0 200") || s.startsWith("HTTP/1.1 200")) {
                    this.log.info((Object)"SHTTP Proxy Reply : [Connection Established]");
                    continue;
                }
                this.log.info((Object)("SHTTP Proxy Reply : [" + s.trim() + "]"));
                throw new Exception("Error Response from SHTTP Proxy !");
            }
            catch (InterruptedIOException e) {
                dlen = 0;
            }
        }
    }

    public void Relay() {
        boolean Active = true;
        while (Active) {
            int dlen = this.CheckClientData();
            if (dlen < 0) {
                Active = false;
            }
            if (dlen > 0) {
                this.LogClientData(dlen);
                this.SendToServer(this.m_Buffer, dlen);
            }
            if ((dlen = this.CheckServerData()) < 0) {
                Active = false;
            }
            if (dlen > 0) {
                this.LogServerData(dlen);
                this.SendToClient(this.m_Buffer, dlen);
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int CheckClientData() {
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            if (this.m_ClientInput == null) {
                return -1;
            }
            try {
                dlen = this.m_ClientInput.read(this.m_Buffer, 0, this.m_BufLen);
            }
            catch (InterruptedIOException e) {
                return 0;
            }
            catch (IOException e) {
                this.log.info((Object)"Client connection Closed!");
                this.Close();
                return -1;
            }
            if (dlen < 0) {
                this.Close();
            }
            return dlen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int CheckServerData() {
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            if (this.m_ServerInput == null) {
                return -1;
            }
            try {
                dlen = this.m_ServerInput.read(this.m_Buffer, 0, this.m_BufLen);
            }
            catch (InterruptedIOException e) {
                return 0;
            }
            catch (IOException e) {
                this.log.info((Object)"Server connection Closed!");
                this.Close();
                return -1;
            }
            if (dlen < 0) {
                this.Close();
            }
            return dlen;
        }
    }

    public void LogServerData(int traffic) {
        this.log.info((Object)("Srv data : " + LogHelper.getSocketInfo(this.m_ClientSocket) + " << <" + this.comm.m_ServerIP.getHostName() + "/" + this.comm.m_ServerIP.getHostAddress() + ":" + this.comm.m_nServerPort + "> : " + traffic + " bytes."));
    }

    public void LogClientData(int traffic) {
        this.log.info((Object)("Cli data : " + LogHelper.getSocketInfo(this.m_ClientSocket) + " >> <" + this.comm.m_ServerIP.getHostName() + "/" + this.comm.m_ServerIP.getHostAddress() + ":" + this.comm.m_nServerPort + "> : " + traffic + " bytes."));
    }
}

