/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.httpproxy;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ru.amip.httpproxy.ProxyInstance;
import org.ru.amip.httpproxy.SettingsBean;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.gui.GlobalCapabilities;
import rero.gui.KeyBindings;

public class ProxySettings
extends JFrame {
    private Log log;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField proxyhost;
    private JTextField proxyport;
    private JTextField proxyuser;
    private JPasswordField proxypass;
    private JTextField port;
    private JCheckBox enabled;
    private JCheckBox logging;
    private JPanel optpanel;
    private SettingsBean settings;
    private ProxyInstance proxy;

    public static void setState(JComponent cmp, boolean state) {
        cmp.setEnabled(state);
        if (cmp.getComponentCount() > 0) {
            Component[] cmps = cmp.getComponents();
            for (int i = 0; i < cmps.length; ++i) {
                Component component = cmps[i];
                if (!(component instanceof JComponent)) continue;
                ProxySettings.setState((JComponent)component, state);
            }
        }
    }

    public ProxySettings(ProxyInstance proxy) {
        this.$$$setupUI$$$();
        this.log = LogFactory.getLog((Class)ProxySettings.class);
        this.settings = new SettingsBean();
        this.setIconImage(GlobalCapabilities.frame.getIconImage());
        this.proxy = proxy;
        Properties prop = proxy.getProp();
        this.settings.setEnabled(prop.getProperty("enabled").equalsIgnoreCase("true"));
        this.settings.setLogging(prop.getProperty("log").equalsIgnoreCase("true"));
        this.settings.setProxyHost(prop.getProperty("proxyhost"));
        this.settings.setProxyPort(prop.getProperty("proxyport"));
        this.settings.setProxyUser(prop.getProperty("proxyuser"));
        this.settings.setProxyPass(prop.getProperty("proxypass"));
        this.settings.setPort(prop.getProperty("port"));
        this.setData(this.settings);
        this.setTitle("HTTP Proxy Settings");
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.buttonOK);
        ProxySettings.setState(this.optpanel, this.enabled.isSelected());
        this.enabled.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ProxySettings.setState(ProxySettings.this.optpanel, ProxySettings.this.enabled.isSelected());
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxySettings.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxySettings.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProxySettings.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxySettings.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        KeyBindings.is_dialog_active = true;
        proxy.optionShown = true;
    }

    private void onOK() {
        KeyBindings.is_dialog_active = false;
        if (this.isModified(this.settings)) {
            this.getData(this.settings);
            this.proxy.stop();
            Properties prop = this.proxy.getProp();
            prop.setProperty("enabled", this.settings.isEnabled() ? "true" : "false");
            prop.setProperty("log", this.settings.isLogging() ? "true" : "false");
            prop.setProperty("proxyhost", this.settings.getProxyHost());
            prop.setProperty("proxyport", this.settings.getProxyPort());
            prop.setProperty("proxyuser", this.settings.getProxyUser());
            prop.setProperty("proxypass", this.settings.getProxyPass());
            prop.setProperty("port", this.settings.getPort());
            ClientState.getClientState().setOption("proxy.enabled", this.settings.isEnabled());
            try {
                prop.store(new FileOutputStream(this.proxy.getConfig()), "jIRCii HTTP Proxy Settings");
            }
            catch (IOException e) {
                this.log.fatal((Object)("Unable to save settings: " + e.getMessage()));
            }
            if (prop.getProperty("log").equalsIgnoreCase("true")) {
                System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "info");
            } else {
                System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "fatal");
            }
            LogFactory.releaseAll();
            this.proxy.start();
        }
        this.proxy.optionShown = false;
        this.dispose();
    }

    public static void updateJIRCIISettings(String port, boolean isEnabled) {
        ClientState jopt = ClientState.getClientState();
        jopt.setOption("proxy.enabled", isEnabled);
        jopt.setInteger("proxy.port", Integer.parseInt(port));
        jopt.setString("proxy.server", "127.0.0.1");
        jopt.setString("proxy.userid", "");
        jopt.setString("proxy.password", "");
        jopt.fireChange("proxy.port");
        jopt.fireChange("proxy.server");
        jopt.fireChange("proxy.userid");
        jopt.fireChange("proxy.password");
        System.setProperty("socksProxyHost", jopt.getString("proxy.server", ClientDefaults.proxy_server));
        System.setProperty("socksProxyPort", jopt.getString("proxy.port", ClientDefaults.proxy_port));
        jopt.sync();
    }

    private void onCancel() {
        KeyBindings.is_dialog_active = false;
        this.proxy.optionShown = false;
        this.dispose();
    }

    public void setData(SettingsBean data) {
        this.enabled.setSelected(data.isEnabled());
        this.logging.setSelected(data.isLogging());
        this.proxyhost.setText(data.getProxyHost());
        this.proxyport.setText(data.getProxyPort());
        this.proxyuser.setText(data.getProxyUser());
        this.proxypass.setText(data.getProxyPass());
        this.port.setText(data.getPort());
    }

    public void getData(SettingsBean data) {
        data.setEnabled(this.enabled.isSelected());
        data.setLogging(this.logging.isSelected());
        data.setProxyHost(this.proxyhost.getText());
        data.setProxyPort(this.proxyport.getText());
        data.setProxyUser(this.proxyuser.getText());
        data.setProxyPass(this.proxypass.getText());
        data.setPort(this.port.getText());
    }

    public boolean isModified(SettingsBean data) {
        if (this.enabled.isSelected() != data.isEnabled()) {
            return true;
        }
        if (this.logging.isSelected() != data.isLogging()) {
            return true;
        }
        if (this.proxyhost.getText() != null ? !this.proxyhost.getText().equals(data.getProxyHost()) : data.getProxyHost() != null) {
            return true;
        }
        if (this.proxyport.getText() != null ? !this.proxyport.getText().equals(data.getProxyPort()) : data.getProxyPort() != null) {
            return true;
        }
        if (this.proxyuser.getText() != null ? !this.proxyuser.getText().equals(data.getProxyUser()) : data.getProxyUser() != null) {
            return true;
        }
        if (this.proxypass.getText() != null ? !this.proxypass.getText().equals(data.getProxyPass()) : data.getProxyPass() != null) {
            return true;
        }
        return this.port.getText() != null ? !this.port.getText().equals(data.getPort()) : data.getPort() != null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JTextField jTextField3;
        JPasswordField jPasswordField;
        JTextField jTextField4;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jButton2.setMnemonic('O');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.enabled = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use HTTP proxy");
        jCheckBox2.setMnemonic('U');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jCheckBox2.setFocusable(true);
        jPanel5.add((Component)jCheckBox2, "North");
        this.optpanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(2, 0, 2, 1, 0, 3, 3, 1, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Authorization (optional):", 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("User name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(70, 14), null));
        this.proxyuser = jTextField4 = new JTextField();
        jTextField4.setText("");
        jPanel6.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Password:");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(1);
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(70, 14), null));
        this.proxypass = jPasswordField = new JPasswordField();
        jPasswordField.setText("");
        jPanel6.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(4, 0, 2, 1, 0, 3, 3, 1, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Local tunnel settings:", 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("SOCKS port:");
        jLabel4.setDisplayedMnemonic('S');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(70, 14), null));
        this.port = jTextField3 = new JTextField();
        jTextField3.setText("");
        jPanel7.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        this.logging = jCheckBox = new JCheckBox();
        jCheckBox.setText("Log to console (requires restart)");
        jCheckBox.setMnemonic('L');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 7, 1, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("(0 - auto)");
        jPanel7.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 1, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(null, "HTTP/HTTPS proxy:", 0, 0, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Proxy host:");
        jLabel6.setDisplayedMnemonic('P');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(70, 14), null));
        this.proxyhost = jTextField2 = new JTextField();
        jPanel8.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Proxy port:");
        jLabel7.setDisplayedMnemonic('R');
        jLabel7.setDisplayedMnemonicIndex(1);
        jPanel8.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(70, 14), null));
        this.proxyport = jTextField = new JTextField();
        jPanel8.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jPasswordField);
        jLabel4.setLabelFor(jTextField3);
        jLabel6.setLabelFor(jTextField2);
        jLabel7.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

