/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.httpproxy;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ru.amip.httpproxy.ProxySettings;
import rero.gui.GlobalCapabilities;
import socksshttp.CServer;

public class ProxyInstance {
    private Log log = LogFactory.getLog((Class)ProxyInstance.class);
    private Properties prop;
    private CServer server;
    private ProxyInstance inst;
    private String config;
    private boolean running;
    public boolean optionShown;
    private static final int PORT_MIN = 58888;
    private static final int PORT_MAX = 60000;

    public String getConfig() {
        return this.config;
    }

    public Properties getProp() {
        return this.prop;
    }

    public ProxyInstance init(String config) {
        Properties def = new Properties();
        def.setProperty("enabled", "false");
        def.setProperty("proxyhost", "");
        def.setProperty("proxyport", "3128");
        def.setProperty("port", "0");
        def.setProperty("log", "false");
        def.setProperty("proxyuser", "");
        def.setProperty("proxypass", "");
        this.inst = this;
        this.config = config;
        this.prop = new Properties();
        try {
            this.prop.load(new FileInputStream(config));
        }
        catch (IOException e) {
            this.prop = def;
        }
        if (this.prop.getProperty("log").equalsIgnoreCase("true")) {
            System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "info");
        } else {
            System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "fatal");
        }
        this.startProxy();
        return this;
    }

    public static int findFreePort() {
        for (int i = 58888; i < 60000; ++i) {
            try {
                ServerSocket socket = new ServerSocket(i);
                socket.close();
                return i;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return -1;
    }

    private void startProxy() {
        boolean enabled = this.prop.getProperty("enabled").equalsIgnoreCase("true");
        if (!enabled || this.running) {
            return;
        }
        String phost = this.prop.getProperty("proxyhost");
        int pport = Integer.parseInt(this.prop.getProperty("proxyport"));
        int port = Integer.parseInt(this.prop.getProperty("port"));
        if (phost.length() == 0 || pport == 0) {
            return;
        }
        if (port == 0) {
            port = ProxyInstance.findFreePort();
            this.log.info((Object)("Found free port for local tunnel: " + port));
            if (port == -1) {
                return;
            }
        }
        ProxySettings.updateJIRCIISettings(String.valueOf(port), true);
        String user = this.prop.getProperty("proxyuser");
        String pass = this.prop.getProperty("proxypass");
        this.server = new CServer(port, true, phost, pport);
        this.server.setProxyUser(user);
        this.server.setProxyPass(pass);
        this.server.start();
        this.running = true;
    }

    public boolean uninit() {
        this.stop();
        return true;
    }

    public void configure() {
        if (this.optionShown) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                ProxySettings dialog = new ProxySettings(ProxyInstance.this.inst);
                dialog.pack();
                dialog.setLocationRelativeTo(GlobalCapabilities.frame);
                dialog.setVisible(true);
            }
        }).start();
    }

    public void start() {
        this.startProxy();
    }

    public void stop() {
        if (this.running) {
            this.server.stop();
        }
        this.running = false;
    }
}

