/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.gds;

import java.util.Hashtable;
import java.util.Stack;
import org.ru.amip.gds.Entities;
import org.ru.amip.gds.GDS;
import rero.util.ClientUtils;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class GDSBridge
implements Loadable {
    public void scriptLoaded(ScriptInstance script) {
        Hashtable env = script.getScriptEnvironment().getEnvironment();
        env.put("&gds_register", new GDSRegister());
        env.put("&gds_unregister", new GDSUnregister());
        env.put("&gds_settimeout", new GDSSetTimeout());
        env.put("&gds_index", new GDSIndex());
    }

    public void scriptUnloaded(ScriptInstance script) {
    }

    public static Object getGDS(ScriptInstance anInstance) {
        Scalar scalar = anInstance.getScriptVariables().getGlobalVariables().getScalar("%GLOBAL");
        return scalar.getHash().getAt(SleepUtils.getScalar((String)"GDS_INSTANCE")).objectValue();
    }

    public static String forHTMLTag(String aTagFragment) {
        return Entities.HTML40.escape(aTagFragment);
    }

    class GDSSetTimeout
    implements Function {
        GDSSetTimeout() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            GDS gds = (GDS)GDSBridge.getGDS(anInstance);
            if (gds != null) {
                long timeout = BridgeUtilities.getLong((Stack)passedInLocals, (long)900L);
                gds.setTimeout(timeout);
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    class GDSUnregister
    implements Function {
        GDSUnregister() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            GDS gds = (GDS)GDSBridge.getGDS(anInstance);
            boolean res = false;
            if (gds != null) {
                res = gds.unregister();
            }
            return SleepUtils.getScalar((boolean)res);
        }
    }

    class GDSRegister
    implements Function {
        GDS gds;

        GDSRegister() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            if (this.gds == null) {
                this.gds = new GDS();
                this.gds.register();
            }
            return SleepUtils.getScalar((Object)this.gds);
        }
    }

    class GDSIndex
    implements Function {
        GDSIndex() {
        }

        public Scalar evaluate(String functionName, ScriptInstance anInstance, Stack passedInLocals) {
            GDS gds = (GDS)GDSBridge.getGDS(anInstance);
            if (gds != null) {
                String text = BridgeUtilities.getString((Stack)passedInLocals, (String)"");
                String mynick = BridgeUtilities.getString((Stack)passedInLocals, (String)"");
                String buddynick = BridgeUtilities.getString((Stack)passedInLocals, (String)"");
                String title = BridgeUtilities.getString((Stack)passedInLocals, (String)"");
                text = ClientUtils.strip((String)text);
                if ((text = GDSBridge.forHTMLTag(text)).length() > 0 && mynick.length() > 0 && buddynick.length() > 0) {
                    gds.index(text, mynick, buddynick, title);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

