/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.ru.amip.channel.ChannelLoader;
import org.ru.amip.channel.TimedBanItem;

public class TimedBansManager {
    private HashMap channelBans = new HashMap();
    private Thread ourDaemon;

    public synchronized int getBanTime(String channel, String mask) {
        if (this.hasTimedBan(channel, mask)) {
            TimedBanItem banItem = (TimedBanItem)((HashMap)this.channelBans.get(channel)).get(mask);
            return banItem.getBantime();
        }
        return 0;
    }

    public void startDaemon() {
        if (this.ourDaemon != null) {
            return;
        }
        this.ourDaemon = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    TimedBansManager.this.removeExprired();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        this.ourDaemon.start();
    }

    public void stopDaemon() {
        this.ourDaemon.interrupt();
        this.ourDaemon = null;
    }

    public synchronized void addTimedBan(String chan, String mask, int minutes) {
        HashMap maskTime;
        if (this.channelBans.containsKey(chan = chan.toLowerCase())) {
            maskTime = (HashMap)this.channelBans.get(chan);
        } else {
            maskTime = new HashMap();
            this.channelBans.put(chan, maskTime);
        }
        maskTime.put(mask, new TimedBanItem(minutes));
    }

    private synchronized void removeExprired() {
        if (this.channelBans.size() == 0) {
            return;
        }
        Set set = this.channelBans.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String channel = (String)iterator.next();
            HashMap bansmap = (HashMap)this.channelBans.get(channel);
            if (bansmap.size() == 0) continue;
            Set bans = bansmap.keySet();
            Iterator bi = bans.iterator();
            while (bi.hasNext()) {
                String mask = (String)bi.next();
                TimedBanItem item = (TimedBanItem)bansmap.get(mask);
                if (!item.expired()) continue;
                this.removeBan(channel, mask);
                bi.remove();
            }
        }
    }

    private void removeBan(String channel, String mask) {
        ChannelLoader.getInstance().getSpecificSession().executeCommand("/mode " + channel + " -b " + mask);
    }

    public synchronized void removeTimedBan(String channel, String mask) {
        if (this.hasTimedBan(channel = channel.toLowerCase(), mask)) {
            ((HashMap)this.channelBans.get(channel)).remove(mask);
        }
    }

    public synchronized boolean hasTimedBan(String channel, String mask) {
        return this.channelBans.containsKey(channel = channel.toLowerCase()) && ((HashMap)this.channelBans.get(channel)).containsKey(mask);
    }
}

