/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class PopUpMenu {
    private static JPopupMenu pm = PopUpMenu.createPopUpMenu();
    private static MouseListener popupListener = new PopupListener();

    public static void addCopyPasteMenu(JTextComponent tc) {
        tc.addMouseListener(popupListener);
    }

    public static JPopupMenu getPm() {
        return pm;
    }

    private static JPopupMenu createPopUpMenu() {
        final JPopupMenu pm = new JPopupMenu();
        JMenuItem mi = new JMenuItem(new DefaultEditorKit.CutAction());
        mi.setText("Cut");
        pm.add(mi);
        mi = new JMenuItem(new DefaultEditorKit.CopyAction());
        mi.setText("Copy");
        pm.add(mi);
        mi = new JMenuItem(new DefaultEditorKit.PasteAction());
        mi.setText("Paste");
        pm.add(mi);
        mi = new JMenuItem("Delete");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopUpMenu.deleteSelection((JTextComponent)pm.getInvoker());
            }
        });
        pm.add(mi);
        pm.addSeparator();
        mi = new JMenuItem("Select All");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((JTextComponent)pm.getInvoker()).selectAll();
            }
        });
        pm.add(mi);
        return pm;
    }

    private static String deleteSelection(JTextComponent tc) {
        int ss = tc.getSelectionStart();
        int se = tc.getSelectionEnd();
        String st = tc.getSelectedText();
        String text = tc.getText();
        int len = text.length();
        text = text.substring(0, ss) + text.substring(se, len);
        tc.setText(text);
        tc.setCaretPosition(ss);
        return st;
    }

    static class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JTextComponent tc;
            if (e.isPopupTrigger() && (tc = (JTextComponent)e.getComponent()).isEnabled()) {
                if (tc.getSelectedText() == null) {
                    this.setEnabled(0, false);
                    this.setEnabled(1, false);
                    this.setEnabled(3, false);
                } else {
                    this.setEnabled(0, true);
                    this.setEnabled(1, true);
                    this.setEnabled(3, true);
                }
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void setEnabled(int item, boolean enabled) {
            MenuElement[] subElements = pm.getSubElements();
            subElements[item].getComponent().setEnabled(enabled);
        }
    }
}

