/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import java.text.SimpleDateFormat;
import java.util.Date;

class ModeItem {
    private String raw;
    private String mask;
    private String setby;
    private String date;
    private String mode;
    private String other;
    private long timestamp;

    public String getDate() {
        return this.date;
    }

    public String getMode() {
        return this.mode;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getMask() {
        return this.mask;
    }

    public String getSetby() {
        return this.setby;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ModeItem(String raw, String mode) {
        this.raw = raw;
        this.mode = mode;
        String[] strings = raw.split("\\s");
        block8: for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            switch (i) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    this.mask = string;
                    continue block8;
                }
                case 2: {
                    this.setby = string;
                    continue block8;
                }
                case 3: {
                    try {
                        this.timestamp = Long.parseLong(string);
                        this.date = ModeItem.formatDate(this.timestamp * 1000L);
                    }
                    catch (NumberFormatException e) {
                        this.other = this.other + string + " ";
                        this.timestamp = 0L;
                    }
                    continue block8;
                }
                default: {
                    this.other = this.other + string + " ";
                }
            }
        }
        if (this.other != null) {
            this.other = this.other.trim();
        }
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append(this.mask);
        if (this.setby != null) {
            tmp.append(" ");
            tmp.append(this.setby);
        }
        if (this.timestamp != 0L) {
            String mydate = ModeItem.formatDate(this.timestamp * 1000L);
            tmp.append(" ");
            tmp.append(mydate);
        }
        if (this.other != null) {
            tmp.append(" ");
            tmp.append(this.other);
        }
        return tmp.toString();
    }

    private static String formatDate(long timestamp) {
        return new SimpleDateFormat("HH:mm dd/MM/yy").format(new Date(timestamp));
    }
}

