/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.ru.amip.channel.ChannelLoader;
import org.ru.amip.channel.IRCStringUtils;
import org.ru.amip.channel.MaskEdit;
import org.ru.amip.channel.ModeItem;
import org.ru.amip.channel.OurJTable;
import org.ru.amip.channel.PopUpMenu;
import rero.gui.GlobalCapabilities;
import rero.gui.KeyBindings;
import rero.ircfw.Channel;
import rero.ircfw.data.GenericMode;
import rero.ircfw.interfaces.ChatListener;

public class ChannelCentralDialog
extends JFrame {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTable ourTable;
    private JTextArea ourTopic;
    private JCheckBox cbmt;
    private JCheckBox cbmn;
    private JCheckBox cbmi;
    private JCheckBox cbmm;
    private JCheckBox cbmk;
    private JCheckBox cbml;
    private JCheckBox cbmp;
    private JCheckBox cbms;
    private JTextField fldlimit;
    private JTextField fldkey;
    private JButton btnhup;
    private JButton btnhdown;
    private JButton btnBans;
    private JButton btnExcepts;
    private JButton btnInvites;
    private JButton btnRemove;
    private JButton btnEdit;
    private JLabel lblType;
    private JLabel info;
    private JLabel lblhist;
    private JCheckBox cbraw;
    private JPanel modesPanel;
    private int histidx;
    private int MAX_TOPIC;
    private Color oldForeColor;
    private Channel ourChn;
    private String channel;
    private String lastmode;
    private ArrayList lastlist;
    private ArrayList ourTopicHistory;
    private DefaultTableModel ourDataModel;
    private JScrollPane ourScroll;
    private boolean ourCatchTableEvents;
    private static ChannelCentralDialog instance;

    public String getChannel() {
        return this.channel;
    }

    public String getLastmode() {
        return this.lastmode;
    }

    public static ChannelCentralDialog getInstance() {
        return instance;
    }

    public ChannelCentralDialog(String chan) {
        instance = this;
        this.channel = chan;
        this.$$$setupUI$$$();
        this.ourChn = ChannelLoader.getInstance().getInternalDataList().getChannel(this.channel);
        if (this.ourChn == null) {
            this.onCancel();
            return;
        }
        this.setContentPane(this.contentPane);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setIconImage(GlobalCapabilities.frame.getIconImage());
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChannelCentralDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.btnBans.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.refreshBans();
            }
        });
        this.btnExcepts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.refreshExcepts();
            }
        });
        this.btnInvites.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.refreshInvites();
            }
        });
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnhup.setIcon(new ImageIcon(ChannelCentralDialog.class.getResource("/images/up.png")));
        this.btnhdown.setIcon(new ImageIcon(ChannelCentralDialog.class.getResource("/images/down.png")));
        this.btnhup.setEnabled(false);
        this.btnhdown.setEnabled(false);
        this.btnhup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.btnhdown.setEnabled(true);
                ChannelCentralDialog.this.histidx--;
                ChannelCentralDialog.this.ourTopic.setText((String)ChannelCentralDialog.this.ourTopicHistory.get(ChannelCentralDialog.this.histidx));
                if (ChannelCentralDialog.this.histidx == 0) {
                    ChannelCentralDialog.this.btnhup.setEnabled(false);
                }
                ChannelCentralDialog.this.recodeTopic();
                ChannelCentralDialog.this.updateInfo();
            }
        });
        this.btnhdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.btnhup.setEnabled(true);
                ChannelCentralDialog.this.histidx++;
                ChannelCentralDialog.this.ourTopic.setText((String)ChannelCentralDialog.this.ourTopicHistory.get(ChannelCentralDialog.this.histidx));
                if (ChannelCentralDialog.this.histidx == ChannelCentralDialog.this.ourTopicHistory.size() - 1) {
                    ChannelCentralDialog.this.btnhdown.setEnabled(false);
                }
                ChannelCentralDialog.this.recodeTopic();
                ChannelCentralDialog.this.updateInfo();
            }
        });
        PopUpMenu.addCopyPasteMenu(this.ourTopic);
        PopUpMenu.addCopyPasteMenu(this.fldlimit);
        PopUpMenu.addCopyPasteMenu(this.fldkey);
        this.cbraw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.recodeTopic();
            }
        });
        final boolean op = ChannelLoader.getInstance().isOp(this.channel);
        if (!op) {
            ChannelCentralDialog.setState(this.modesPanel, false);
        }
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelCentralDialog.this.deleteSelectedMasks();
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaskEdit.showDialog(ChannelCentralDialog.getInstance(), (ModeItem)ChannelCentralDialog.this.lastlist.get(ChannelCentralDialog.this.ourTable.getSelectedRow()));
            }
        });
        this.cbmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ChannelCentralDialog.this.cbmp.isSelected()) {
                    ChannelCentralDialog.this.cbms.setSelected(false);
                }
            }
        });
        this.cbms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ChannelCentralDialog.this.cbms.isSelected()) {
                    ChannelCentralDialog.this.cbmp.setSelected(false);
                }
            }
        });
        this.ourDataModel = new DefaultTableModel(new String[]{"Address", "Set by", "Date"}, 1){

            public boolean isCellEditable(int row, int column) {
                return column == 0 && op;
            }

            public void setValueAt(Object aValue, int row, int column) {
                super.setValueAt(aValue, row, column);
                if (ChannelCentralDialog.this.ourCatchTableEvents) {
                    String newmask = (String)aValue;
                    ModeItem item = (ModeItem)ChannelCentralDialog.this.lastlist.get(row);
                    String oldmask = item.getMask();
                    if (oldmask.compareTo(newmask) != 0) {
                        if ("b".compareTo(ChannelCentralDialog.this.lastmode) == 0) {
                            ChannelLoader.getInstance().getBanManager().removeTimedBan(ChannelCentralDialog.this.channel, oldmask);
                        }
                        ChannelCentralDialog.this.ourCatchTableEvents = false;
                        MaskEdit.editMask(oldmask, newmask, ChannelCentralDialog.this.channel, ChannelCentralDialog.this.lastmode);
                    }
                }
            }
        };
        this.ourTable = new OurJTable(this.ourDataModel);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.ourTable.setRowSelectionAllowed(true);
        this.ourTable.setShowVerticalLines(false);
        this.ourTable.setShowHorizontalLines(false);
        this.ourTable.setShowGrid(false);
        this.ourTable.setColumnSelectionAllowed(false);
        this.ourTable.getTableHeader().setReorderingAllowed(false);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ChannelCentralDialog.this.lastlist.size() > 0 && op) {
                    ChannelCentralDialog.this.btnRemove.setEnabled(true);
                    ChannelCentralDialog.this.btnEdit.setEnabled(true);
                } else {
                    ChannelCentralDialog.this.btnRemove.setEnabled(false);
                    ChannelCentralDialog.this.btnEdit.setEnabled(false);
                }
                if (ChannelCentralDialog.this.ourTable.getSelectedRowCount() > 1) {
                    ChannelCentralDialog.this.btnEdit.setEnabled(false);
                }
            }
        });
        this.ourTable.setSelectionModel(selectionModel);
        this.ourScroll.setViewportView(this.ourTable);
        this.ourTopic.setFont(this.info.getFont());
        this.ourScroll.getViewport().setBackground(this.ourTopic.getBackground());
        this.showDialogAndContinue();
    }

    private void deleteSelectedMasks() {
        StringBuffer modes = new StringBuffer();
        StringBuffer masks = new StringBuffer();
        modes.append("-");
        int[] selectedIndices = this.ourTable.getSelectedRows();
        for (int i = 0; i < selectedIndices.length; ++i) {
            int idx = selectedIndices[i];
            ModeItem item = (ModeItem)this.lastlist.get(idx);
            modes.append(this.lastmode);
            String mask = item.getMask();
            masks.append(mask);
            if ("b".compareTo(this.lastmode) == 0) {
                ChannelLoader.getInstance().getBanManager().removeTimedBan(this.channel, mask);
            }
            masks.append(' ');
        }
        ChannelCentralDialog.execCommand("/mode " + this.channel + " " + modes + " " + masks.toString().trim());
        this.refreshLast();
    }

    public static void setState(JComponent cmp, boolean state) {
        cmp.setEnabled(state);
        if (cmp.getComponentCount() > 0) {
            Component[] cmps = cmp.getComponents();
            for (int i = 0; i < cmps.length; ++i) {
                Component component = cmps[i];
                if (!(component instanceof JComponent)) continue;
                ChannelCentralDialog.setState((JComponent)component, state);
            }
        }
    }

    private void recodeTopic() {
        if (this.cbraw.isSelected()) {
            this.ourTopic.setText(IRCStringUtils.ircUnescape(this.ourTopic.getText()));
        } else {
            this.ourTopic.setText(IRCStringUtils.ircEscape(this.ourTopic.getText()));
        }
    }

    public void refreshLast() {
        if ("b".equals(this.lastmode)) {
            this.refreshBans();
        } else if ("e".equals(this.lastmode)) {
            this.refreshExcepts();
        } else if ("I".equals(this.lastmode)) {
            this.refreshInvites();
        }
    }

    public static void execCommand(String cmd) {
        ChannelLoader.getInstance().execCommand(cmd);
    }

    private int addMode(StringBuffer b, JCheckBox cb, char mode) {
        boolean newmode;
        int res = -1;
        GenericMode gm = this.ourChn.getMode();
        boolean oldmode = gm.isSet(mode);
        if (oldmode == (newmode = cb.isSelected())) {
            return res;
        }
        if (newmode) {
            b.append('+');
            res = 1;
        } else {
            res = 0;
            b.append('-');
        }
        b.append(mode);
        return res;
    }

    private void onOK() {
        String newmodes;
        int ilimit;
        GenericMode gm = this.ourChn.getMode();
        String oldtopic = this.ourChn.getTopic();
        String newtopic = this.ourTopic.getText();
        newtopic = StringUtils.replace(newtopic, "\n", " ");
        newtopic = IRCStringUtils.ircUnescape(newtopic.trim());
        if ((ChannelLoader.getInstance().isOp(this.channel) || !gm.isSet('t')) && newtopic.compareTo(oldtopic) != 0) {
            if (newtopic.length() > 0) {
                ChannelLoader.getInstance().execCommand("/topic " + this.channel + " " + newtopic);
            } else {
                ChannelLoader.getInstance().execCommand("/ut");
            }
        }
        if (this.fldkey.getText().trim().length() == 0) {
            this.cbmk.setSelected(false);
        }
        String limit = this.fldlimit.getText().trim();
        try {
            ilimit = Integer.parseInt(limit);
        }
        catch (NumberFormatException e) {
            ilimit = 0;
        }
        if (limit.length() == 0 || ilimit == 0) {
            this.cbml.setSelected(false);
        }
        StringBuffer finalModes = new StringBuffer();
        this.addMode(finalModes, this.cbmt, 't');
        this.addMode(finalModes, this.cbmn, 'n');
        this.addMode(finalModes, this.cbmi, 'i');
        this.addMode(finalModes, this.cbmm, 'm');
        this.addMode(finalModes, this.cbmp, 'p');
        this.addMode(finalModes, this.cbms, 's');
        int res = this.addMode(finalModes, this.cbml, 'l');
        boolean addlimit = false;
        if (res == -1 && this.cbml.isSelected() && this.ourChn.getLimit() != ilimit) {
            finalModes.append("+l");
            addlimit = true;
        }
        if (res == 1) {
            addlimit = true;
        }
        boolean addkey = false;
        res = this.addMode(finalModes, this.cbmk, 'k');
        String newkey = this.fldkey.getText().trim();
        String oldkey = this.ourChn.getKey();
        String keytoadd = newkey;
        if (res == -1 && this.cbmk.isSelected() && oldkey.compareTo(newkey) != 0) {
            finalModes.append("+k");
            addkey = true;
            keytoadd = newkey;
        }
        if (res == 0) {
            addkey = true;
            keytoadd = oldkey;
        }
        if (res == 1) {
            addkey = true;
            keytoadd = newkey;
        }
        if (addlimit) {
            finalModes.append(' ');
            finalModes.append(ilimit);
        }
        if (addkey && keytoadd != null) {
            finalModes.append(' ');
            finalModes.append(keytoadd);
        }
        if ((newmodes = finalModes.toString()).length() > 0) {
            ChannelLoader.getInstance().execCommand("/mode " + this.channel + " " + newmodes);
        }
        this.setClosed();
        this.dispose();
    }

    private void onCancel() {
        this.setClosed();
        this.dispose();
    }

    private void setClosed() {
        KeyBindings.is_dialog_active = false;
        ChannelLoader.getInstance().setGlobalVariable("CHANNEL_DLG_OPENED", "0");
    }

    private void showDialog() {
        GenericMode mode;
        this.setTitle("jIRCii Channel Central " + this.channel);
        HashMap supportInfo = ChannelLoader.getInstance().getInternalDataList().getSupportInfo();
        if (supportInfo.containsKey("TOPICLEN")) {
            this.MAX_TOPIC = Integer.parseInt((String)supportInfo.get("TOPICLEN"));
        }
        if ((mode = this.ourChn.getMode()).isSet('k')) {
            this.cbmk.setSelected(true);
            this.fldkey.setText(this.ourChn.getKey());
        }
        if (mode.isSet('l')) {
            this.cbml.setSelected(true);
            this.fldlimit.setText(Integer.toString(this.ourChn.getLimit()));
        }
        this.cbmt.setSelected(mode.isSet('t'));
        this.cbmn.setSelected(mode.isSet('n'));
        this.cbmi.setSelected(mode.isSet('i'));
        this.cbmm.setSelected(mode.isSet('m'));
        this.cbmp.setSelected(mode.isSet('p'));
        this.cbms.setSelected(mode.isSet('s'));
        String topic = this.ourChn.getTopic();
        this.ourTopic.setText(topic);
        ChannelLoader cl = ChannelLoader.getInstance();
        cl.getHistory().addTopic(this.channel, topic);
        this.ourTopicHistory = cl.getHistory().getTopicHistory(this.channel);
        if (this.ourTopicHistory.size() > 0) {
            String lasttopic = (String)this.ourTopicHistory.get(0);
            if (lasttopic.compareTo(topic) != 0) {
                this.ourTopicHistory.add(0, topic);
            }
        } else {
            this.ourTopicHistory.add(0, topic);
        }
        this.histidx = 0;
        if (this.ourTopicHistory.size() > 1) {
            this.btnhdown.setEnabled(true);
        }
        this.oldForeColor = this.info.getForeground();
        this.addUpdateListeners();
        this.updateInfo();
        this.refreshBans();
        this.recodeTopic();
        this.pack();
        this.setLocationRelativeTo(GlobalCapabilities.frame);
        KeyBindings.is_dialog_active = true;
        this.setVisible(true);
    }

    private void addUpdateListeners() {
        this.ourTopic.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ChannelCentralDialog.this.updateInfo();
            }

            public void removeUpdate(DocumentEvent e) {
                ChannelCentralDialog.this.updateInfo();
            }

            public void changedUpdate(DocumentEvent e) {
                ChannelCentralDialog.this.updateInfo();
            }
        });
        this.ourTopic.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                ChannelCentralDialog.this.updateInfo();
                return true;
            }
        });
    }

    public void updateInfo() {
        String maxlen = this.MAX_TOPIC == 0 ? "???" : Integer.toString(this.MAX_TOPIC);
        String histinfo = "Topic history (" + (this.histidx + 1) + " of " + this.ourTopicHistory.size() + "):";
        String unescaped = IRCStringUtils.ircUnescape(this.ourTopic.getText());
        int curlen = unescaped.length();
        String text = curlen + " of " + maxlen + " max chars";
        if (this.MAX_TOPIC != 0) {
            if (curlen > this.MAX_TOPIC) {
                this.info.setForeground(Color.RED);
            } else {
                this.info.setForeground(this.oldForeColor);
            }
        }
        this.lblhist.setText(histinfo);
        this.info.setText(text);
    }

    private void refreshBans() {
        this.refreshStarted();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChannelCentralDialog.this.lastlist = new ArrayList();
                ChannelCentralDialog.this.refreshMode("b", "367", "368", ChannelCentralDialog.this.lastlist);
            }
        });
    }

    private void refreshExcepts() {
        this.refreshStarted();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChannelCentralDialog.this.lastlist = new ArrayList();
                ChannelCentralDialog.this.refreshMode("e", "348", "349", ChannelCentralDialog.this.lastlist);
            }
        });
    }

    private void refreshInvites() {
        this.refreshStarted();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChannelCentralDialog.this.lastlist = new ArrayList();
                ChannelCentralDialog.this.refreshMode("I", "346", "347", ChannelCentralDialog.this.lastlist);
            }
        });
    }

    public void refreshStarted() {
        this.ourCatchTableEvents = false;
        this.btnBans.setEnabled(false);
        this.btnExcepts.setEnabled(false);
        this.btnInvites.setEnabled(false);
        this.ourDataModel.setRowCount(0);
        this.ourTable.setEnabled(false);
    }

    public void refreshFinished(String mode, ArrayList data) {
        this.lastmode = mode;
        if (mode.equals("b")) {
            this.lblType.setText("Bans list:");
        } else if (mode.equals("e")) {
            this.lblType.setText("Excepts list:");
        } else if (mode.equals("I")) {
            this.lblType.setText("Invites list:");
        }
        this.btnBans.setEnabled(true);
        this.btnExcepts.setEnabled(true);
        this.btnInvites.setEnabled(true);
        this.btnRemove.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.ourTable.setEnabled(true);
        int row = 0;
        this.ourDataModel.setRowCount(data.size());
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            ModeItem modeItem = (ModeItem)iterator.next();
            this.ourDataModel.setValueAt(modeItem.getMask(), row, 0);
            this.ourDataModel.setValueAt(modeItem.getSetby(), row, 1);
            this.ourDataModel.setValueAt(modeItem.getDate(), row, 2);
            ++row;
        }
        this.ourCatchTableEvents = true;
    }

    private void showDialogAndContinue() {
        new Thread(new Runnable(){

            public void run() {
                ChannelCentralDialog.this.showDialog();
            }
        }).start();
    }

    public void refreshMode(final String mode, final String catchEvent, final String stopEvent, final ArrayList list) {
        ChannelLoader.getInstance().getSessionCapabilities().addTemporaryListener(new ChatListener(){

            public int fireChatEvent(HashMap eventDescription) {
                String event = (String)eventDescription.get("$event");
                if (event.equalsIgnoreCase(stopEvent) || event.equalsIgnoreCase("482")) {
                    ChannelCentralDialog.this.refreshFinished(mode, list);
                    return 7;
                }
                if (event.equalsIgnoreCase(catchEvent)) {
                    String param = eventDescription.get("$parms").toString();
                    list.add(new ModeItem(param, mode));
                }
                return 2;
            }

            public boolean isChatEvent(String eventId, HashMap eventDescription) {
                return eventId.equalsIgnoreCase(catchEvent) || eventId.equalsIgnoreCase(stopEvent) || eventId.equalsIgnoreCase("482");
            }
        });
        ChannelCentralDialog.execCommand("/mode " + this.channel + " +" + mode);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        JButton jButton;
        JButton jButton2;
        JTextArea jTextArea;
        JScrollPane jScrollPane;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel;
        JButton jButton3;
        JButton jButton4;
        JLabel jLabel3;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.btnRemove = jButton9 = new JButton();
        jButton9.setLabel("Remove");
        jButton9.setText("Remove");
        jButton9.setMnemonic('R');
        jButton9.setDisplayedMnemonicIndex(0);
        jButton9.setFocusPainted(false);
        jPanel4.add((Component)jButton9, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnEdit = jButton8 = new JButton();
        jButton8.setLabel("Edit");
        jButton8.setText("Edit");
        jButton8.setMnemonic('D');
        jButton8.setDisplayedMnemonicIndex(1);
        jButton8.setFocusPainted(false);
        jPanel4.add((Component)jButton8, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnInvites = jButton7 = new JButton();
        jButton7.setLabel("Invites");
        jButton7.setText("Invites");
        jButton7.setMnemonic('I');
        jButton7.setDisplayedMnemonicIndex(0);
        jButton7.setFocusPainted(false);
        jPanel4.add((Component)jButton7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnExcepts = jButton6 = new JButton();
        jButton6.setLabel("Excepts");
        jButton6.setText("Excepts");
        jButton6.setMnemonic('E');
        jButton6.setDisplayedMnemonicIndex(0);
        jButton6.setFocusPainted(false);
        jPanel4.add((Component)jButton6, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnBans = jButton5 = new JButton();
        jButton5.setLabel("Bans");
        jButton5.setText("Bans");
        jButton5.setMnemonic('B');
        jButton5.setDisplayedMnemonicIndex(0);
        jButton5.setFocusPainted(false);
        jPanel4.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.lblType = jLabel3 = new JLabel();
        jLabel3.setIconTextGap(4);
        jLabel3.setText("Bans list:");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton4 = new JButton();
        jButton4.setText("OK");
        jButton4.setMnemonic('O');
        jButton4.setDisplayedMnemonicIndex(0);
        jButton4.setFocusPainted(true);
        jPanel6.add((Component)jButton4, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton3 = new JButton();
        jButton3.setText("Cancel");
        jButton3.setMnemonic('C');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.modesPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.cbmt = jCheckBox9 = new JCheckBox();
        jCheckBox9.setFocusable(false);
        jCheckBox9.setText("Only ops set topic");
        jCheckBox9.setMnemonic('S');
        jCheckBox9.setDisplayedMnemonicIndex(9);
        jPanel7.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbmn = jCheckBox8 = new JCheckBox();
        jCheckBox8.setFocusable(false);
        jCheckBox8.setText("No external messages");
        jCheckBox8.setMnemonic('N');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jCheckBox8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbmi = jCheckBox7 = new JCheckBox();
        jCheckBox7.setFocusable(false);
        jCheckBox7.setText("Invite only");
        jCheckBox7.setMnemonic('V');
        jCheckBox7.setDisplayedMnemonicIndex(2);
        jPanel7.add((Component)jCheckBox7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbmm = jCheckBox6 = new JCheckBox();
        jCheckBox6.setFocusable(false);
        jCheckBox6.setText("Moderated");
        jCheckBox6.setMnemonic('M');
        jCheckBox6.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.cbmk = jCheckBox5 = new JCheckBox();
        jCheckBox5.setFocusable(false);
        jCheckBox5.setText("Key:");
        jCheckBox5.setMnemonic('K');
        jCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbml = jCheckBox4 = new JCheckBox();
        jCheckBox4.setFocusable(false);
        jCheckBox4.setText("Limit to:");
        jCheckBox4.setMnemonic('L');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbmp = jCheckBox3 = new JCheckBox();
        jCheckBox3.setFocusable(false);
        jCheckBox3.setText("Private");
        jCheckBox3.setMnemonic('P');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbms = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        jCheckBox2.setText("Secret");
        jCheckBox2.setMnemonic('T');
        jCheckBox2.setDisplayedMnemonicIndex(5);
        jPanel8.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.fldkey = jTextField2 = new JTextField();
        jTextField2.setFocusable(true);
        jTextField2.setRequestFocusEnabled(true);
        jPanel8.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.fldlimit = jTextField = new JTextField();
        jTextField.setFocusable(true);
        jTextField.setRequestFocusEnabled(true);
        jPanel8.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(40, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("users");
        jPanel8.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.ourScroll = jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(100, 100), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 2, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel9.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 1, null, null, null));
        this.ourTopic = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setTabSize(2);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setRequestFocusEnabled(true);
        jTextArea.setMargin(new Insets(0, 2, 0, 2));
        jScrollPane2.setViewportView(jTextArea);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.btnhup = jButton2 = new JButton();
        jButton2.setLabel("");
        jButton2.setText("");
        jButton2.setFocusable(false);
        jButton2.setMargin(new Insets(3, 3, 3, 3));
        jButton2.setIconTextGap(0);
        jPanel10.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnhdown = jButton = new JButton();
        jButton.setLabel("");
        jButton.setText("");
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(3, 3, 3, 3));
        jButton.setIconTextGap(0);
        jPanel10.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel10.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel10.add((Component)spacer5, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(1, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.lblhist = jLabel2 = new JLabel();
        jLabel2.setIconTextGap(4);
        jLabel2.setText("Topic history (1 of 10):");
        jLabel2.setDisplayedMnemonic('H');
        jLabel2.setDisplayedMnemonicIndex(6);
        jPanel11.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.info = jLabel = new JLabel();
        jLabel.setText("10 of 300 max");
        jPanel12.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel12.add((Component)spacer6, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.cbraw = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setText("Raw codes");
        jCheckBox.setMnemonic('W');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel12.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jScrollPane);
        jLabel2.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

