/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.ru.amip.channel.ChannelCentralDialog;
import org.ru.amip.channel.ChannelLoader;
import org.ru.amip.channel.ModeItem;
import org.ru.amip.channel.PopUpMenu;
import org.ru.amip.channel.TimedBansManager;

public class MaskEdit
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField fldmask;
    private JCheckBox cbremove;
    private JComboBox tcombo;
    private JPanel removePanel;
    private ModeItem item;
    private static final int[] CHOICES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 60};
    private String ourMode;
    private TimedBansManager ourBanmanager;
    private String ourChannel;

    public MaskEdit(ChannelCentralDialog parent, ModeItem modeItem) {
        super(parent);
        this.item = modeItem;
        this.$$$setupUI$$$();
        this.initDialog();
    }

    private void initDialog() {
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaskEdit.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaskEdit.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MaskEdit.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaskEdit.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        String mask = this.item.getMask();
        this.fldmask.setText(mask);
        this.ourChannel = ChannelCentralDialog.getInstance().getChannel();
        this.ourMode = this.item.getMode();
        if ("b".compareTo(this.ourMode) == 0) {
            this.ourBanmanager = ChannelLoader.getInstance().getBanManager();
            if (this.ourBanmanager.hasTimedBan(this.ourChannel, mask)) {
                this.cbremove.setSelected(true);
                this.tcombo.setEnabled(true);
            }
            int btime = this.ourBanmanager.getBanTime(this.ourChannel, mask);
            this.removePanel.setVisible(true);
            this.initComboBox(btime);
            this.cbremove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MaskEdit.this.cbremove.isSelected()) {
                        MaskEdit.this.tcombo.setEnabled(true);
                    } else {
                        MaskEdit.this.tcombo.setEnabled(false);
                    }
                }
            });
        } else {
            this.removePanel.setVisible(false);
        }
        PopUpMenu.addCopyPasteMenu(this.fldmask);
        String type = "unknown";
        if ("b".compareTo(this.ourMode) == 0) {
            type = "ban";
        } else if ("e".compareTo(this.ourMode) == 0) {
            type = "exception";
        } else if ("I".compareTo(this.ourMode) == 0) {
            type = "invite";
        }
        this.setTitle("Edit " + type + " mask");
    }

    private void initComboBox(int btime) {
        Integer anObject = new Integer(btime);
        boolean present = false;
        for (int i = 0; i < CHOICES.length; ++i) {
            int choice = CHOICES[i];
            if (choice == btime) {
                present = true;
            }
            this.tcombo.addItem(new Integer(choice));
        }
        if (!present) {
            this.tcombo.addItem(anObject);
        }
        this.tcombo.setSelectedItem(anObject);
    }

    private void onOK() {
        String oldmask = this.item.getMask();
        String newmask = this.fldmask.getText().trim();
        String channel = this.ourChannel;
        String mode = this.ourMode;
        if ("b".compareTo(mode) == 0) {
            this.ourBanmanager.removeTimedBan(channel, oldmask);
            int btime = 0;
            try {
                btime = (Integer)this.tcombo.getSelectedItem();
            }
            catch (Exception e) {
                btime = 0;
            }
            if (btime != 0 && this.cbremove.isSelected()) {
                this.ourBanmanager.addTimedBan(channel, newmask, btime);
            }
        }
        MaskEdit.editMask(oldmask, newmask, channel, mode);
        this.dispose();
    }

    public static void editMask(String oldmask, String newmask, String channel, String mode) {
        if (oldmask.compareTo(newmask) != 0) {
            ChannelLoader instance = ChannelLoader.getInstance();
            if (newmask.length() == 0) {
                instance.execCommand("/mode " + channel + " -" + mode + " " + oldmask);
            } else {
                instance.execCommand("/mode " + channel + " -" + mode + "+" + mode + " " + oldmask + " " + newmask);
            }
            ChannelCentralDialog.getInstance().refreshLast();
        }
    }

    private void onCancel() {
        this.dispose();
    }

    public static void showDialog(ChannelCentralDialog parent, ModeItem modeItem) {
        MaskEdit dialog = new MaskEdit(parent, modeItem);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jButton2.setMnemonic('O');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Mask:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fldmask = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.removePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setVisible(true);
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.cbremove = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remove ban in:");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setFocusable(false);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.tcombo = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(false);
        jComboBox.setEditable(true);
        jComboBox.setFocusable(false);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(40, -1), new Dimension(50, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("mins");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

