/*
 * Decompiled with CFR 0.152.
 */
package org.ru.amip.channel;

import java.util.Hashtable;
import java.util.Stack;
import org.ru.amip.channel.ChannelCentralDialog;
import org.ru.amip.channel.TimedBansManager;
import org.ru.amip.channel.TopicHistory;
import rero.client.Capabilities;
import rero.gui.GlobalCapabilities;
import rero.gui.IRCSession;
import rero.gui.SessionManager;
import rero.ircfw.Channel;
import rero.ircfw.InternalDataList;
import rero.script.GlobalVariables;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ChannelLoader
implements Loadable {
    private IRCSession ourSpecificSession;
    private static ChannelLoader instance;
    private ScriptInstance ourScript;
    private TimedBansManager ourBanManager = new TimedBansManager();
    private TopicHistory ourHistory = new TopicHistory();
    static /* synthetic */ Class class$org$ru$amip$channel$ChannelLoader;

    public TopicHistory getHistory() {
        return this.ourHistory;
    }

    public TimedBansManager getBanManager() {
        return this.ourBanManager;
    }

    public IRCSession getSpecificSession() {
        return this.ourSpecificSession;
    }

    public ScriptInstance getScript() {
        return this.ourScript;
    }

    public ChannelLoader() {
        instance = this;
    }

    public static ChannelLoader getInstance() {
        if (instance == null) {
            instance = new ChannelLoader();
        }
        return instance;
    }

    public void scriptLoaded(ScriptInstance script) {
        this.ourScript = script;
        Hashtable environment = script.getScriptEnvironment().getEnvironment();
        environment.put("&showChannelDialog", new ShowChannelDialog());
        environment.put("&logTopic", new LogTopic());
        environment.put("&setLoaderSession", new SetSession());
        this.ourBanManager.startDaemon();
    }

    public void scriptUnloaded(ScriptInstance script) {
        this.ourBanManager.stopDaemon();
    }

    private void setSession(IRCSession specificSession) {
        this.ourSpecificSession = specificSession;
    }

    public boolean isOp(String chan) {
        InternalDataList il = this.getInternalDataList();
        Channel channel = il.getChannel(chan);
        int mode = il.getMyUser().getModeFor(channel);
        return il.getPrefixInfo().isMode(mode, 'o') || il.getPrefixInfo().isMode(mode, 'h');
    }

    public InternalDataList getInternalDataList() {
        Capabilities capabilities = this.getSessionCapabilities();
        return (InternalDataList)capabilities.getDataStructure("clientInformation");
    }

    protected GlobalCapabilities getGlobalCapabilities() {
        return SessionManager.getGlobalCapabilities();
    }

    protected Capabilities getSessionCapabilities() {
        return this.ourSpecificSession.getCapabilities();
    }

    public Object getGlobalVariable(String key) {
        Scalar scalar = this.ourScript.getScriptVariables().getGlobalVariables().getScalar("%GLOBAL");
        return scalar.getHash().getAt(SleepUtils.getScalar((String)key)).objectValue();
    }

    public void execCommand(String cmd) {
        this.ourSpecificSession.executeCommand(cmd);
    }

    public void setGlobalVariable(String key, String value) {
        GlobalVariables gv = (GlobalVariables)this.ourSpecificSession.getCapabilities().getDataStructure("globalVariables");
        Scalar hashScalar = gv.getScalar("%GLOBAL");
        Scalar temp = hashScalar.getHash().getAt(SleepUtils.getScalar((String)key));
        temp.setValue(SleepUtils.getScalar((String)value));
    }

    private class ShowChannelDialog
    implements Function {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ShowChannelDialog() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            String chan = BridgeUtilities.getString((Stack)args, null);
            if (!$assertionsDisabled && chan != null) {
                throw new AssertionError();
            }
            new ChannelCentralDialog(chan);
            return SleepUtils.getEmptyScalar();
        }

        static {
            $assertionsDisabled = !(class$org$ru$amip$channel$ChannelLoader == null ? (class$org$ru$amip$channel$ChannelLoader = ChannelLoader.class$("org.ru.amip.channel.ChannelLoader")) : class$org$ru$amip$channel$ChannelLoader).desiredAssertionStatus();
        }
    }

    private class LogTopic
    implements Function {
        private LogTopic() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            String chan = BridgeUtilities.getString((Stack)args, null);
            String topic = BridgeUtilities.getString((Stack)args, null);
            ChannelLoader.this.ourHistory.addTopic(chan, topic);
            return SleepUtils.getEmptyScalar();
        }
    }

    private class SetSession
    implements Function {
        private SetSession() {
        }

        public Scalar evaluate(String name, ScriptInstance script, Stack args) {
            int session = BridgeUtilities.getInt((Stack)args, (int)0);
            IRCSession specificSession = SessionManager.getGlobalCapabilities().getSessionManager().getSpecificSession(session);
            ChannelLoader.this.setSession(specificSession);
            return SleepUtils.getEmptyScalar();
        }
    }
}

