/*
 * Decompiled with CFR 0.152.
 */
package org.ululatus.sleep.bridges;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ululatus.sleep.bridges.InvalidClasspathException;

public class ExtendingClassLoader
extends ClassLoader {
    private String classpath = "";
    private boolean archive = false;
    private File parentdir = null;
    private ZipFile zipfile = null;
    private byte[] bytes = null;
    String last_error = "";

    public ExtendingClassLoader(String path) throws InvalidClasspathException {
        this.checkPath(path);
    }

    public ExtendingClassLoader(ClassLoader father, String path) throws InvalidClasspathException {
        super(father);
        this.checkPath(path);
    }

    private void checkPath(String path) throws InvalidClasspathException {
        this.classpath = this.getCanonicalPath(new File(path));
        File file = new File(this.classpath);
        if (file.exists()) {
            String lcPath = path.toLowerCase();
            if (file.isDirectory()) {
                this.parentdir = file;
                this.archive = false;
            } else if (lcPath.endsWith(".jar") || lcPath.endsWith(".zip")) {
                try {
                    this.zipfile = new ZipFile(file);
                }
                catch (IOException ioe) {
                    throw new InvalidClasspathException(ioe.toString());
                }
                this.archive = true;
            }
        } else {
            throw new InvalidClasspathException("file not found: " + this.classpath);
        }
    }

    private String getCanonicalPath(File file) throws InvalidClasspathException {
        String result = null;
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new InvalidClasspathException(ioe.toString());
        }
        return result;
    }

    public Class findClass(String name) {
        byte[] b = null;
        b = this.loadClassData(name);
        if (b != null && b.length > 0) {
            Class<?> c_;
            try {
                c_ = this.defineClass(name, b, 0, b.length);
            }
            catch (NoClassDefFoundError nc) {
                this.last_error = "" + nc;
                return null;
            }
            catch (LinkageError le) {
                this.last_error = "" + le;
                return null;
            }
            catch (Exception e) {
                this.last_error = "" + e;
                return null;
            }
            return c_;
        }
        return null;
    }

    public String getLastError() {
        String err = new String(this.last_error);
        this.last_error = "";
        return err;
    }

    public byte[] loadClassData(String classname) {
        if (this.archive) {
            return this.loadFromArchive(this.classAsFilename(classname, true));
        }
        return this.loadFromDirectory(this.classAsFilename(classname, false));
    }

    public byte[] getBytecode() {
        return this.bytes;
    }

    public URL findResource(String resource) {
        URL u = null;
        try {
            if (this.archive) {
                String js = this.locateResource(resource);
                if (js != null) {
                    u = new URL("jar:" + new File(this.classpath).toURL() + "!/" + js);
                }
            } else {
                String f = this.resourceAsFilename(resource);
                File r = new File(f);
                if (r.isAbsolute() && r.getPath().startsWith(this.classpath) && r.exists()) {
                    u = r.toURL();
                } else {
                    File rs = new File(this.parentdir, f);
                    if (rs.exists()) {
                        u = rs.toURL();
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    public String locateResource(String resource) {
        if (this.archive) {
            ZipEntry entry = this.zipfile.getEntry(this.resourceAsEntryname(resource));
            if (entry != null) {
                return this.resourceAsEntryname(resource);
            }
        } else if (new File(this.parentdir, this.resourceAsFilename(resource)).exists()) {
            return this.resourceAsFilename(resource);
        }
        return null;
    }

    public byte[] loadResource(String resource) {
        if (this.archive) {
            return this.loadFromArchive(resource);
        }
        return this.loadFromDirectory(resource);
    }

    private byte[] loadFromArchive(String entryname) {
        this.bytes = null;
        if (this.zipfile != null) {
            try {
                ZipEntry entry = this.zipfile.getEntry(entryname);
                if (entry == null) {
                    return null;
                }
                DataInputStream datastream = new DataInputStream(this.zipfile.getInputStream(entry));
                this.bytes = new byte[(int)entry.getSize()];
                datastream.readFully(this.bytes);
                datastream.close();
                return this.bytes;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private byte[] loadFromDirectory(String filename) {
        byte[] bytes = null;
        try {
            File classfile = new File(this.parentdir, filename);
            if (!classfile.exists()) {
                return null;
            }
            FileInputStream inputstream = new FileInputStream(classfile);
            DataInputStream datastream = new DataInputStream(inputstream);
            bytes = new byte[(int)classfile.length()];
            datastream.readFully(bytes);
            datastream.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String classAsFilename(String classname, boolean zipped) {
        char sep = File.separatorChar;
        if (zipped) {
            sep = '/';
        }
        String result = classname.replace('.', sep) + ".class";
        return result;
    }

    private String fileAsClassname(String classfilename) {
        String result = classfilename.replace('/', '.');
        if (result.endsWith(".class")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    private String resourceAsEntryname(String resource) {
        char sep = File.separatorChar;
        String result = resource;
        if (resource.indexOf("\\") != -1) {
            result = resource.replace('\\', '/');
        }
        return result;
    }

    private String resourceAsFilename(String resource) {
        char sep = File.separatorChar;
        String ssep = File.separator;
        String result = resource;
        if (ssep.equals("/") && resource.indexOf("\\") != -1) {
            result = resource.replace('\\', sep);
        }
        if (ssep.equals("\\") && resource.indexOf("/") != -1) {
            result = resource.replace('/', sep);
        }
        return result;
    }

    String getClasspath() {
        return this.classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile() {
        if (this.zipfile != null) {
            try {
                this.zipfile.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.zipfile = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.zipfile != null) {
            this.closeFile();
        }
    }
}

