/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model.sensor;

import com.philips.lighting.annotations.Bridge;

public class PHSensorConfiguration {
    private String url;
    @Bridge(name="battery")
    private Integer battery;
    @Bridge(name="reachable")
    private Boolean reachable;
    @Bridge(name="on")
    private Boolean on;
    @Bridge(name="alert")
    private PHSensorAlertMode alertMode;
    @Bridge(name="usertest")
    private Boolean userTest;

    public PHSensorConfiguration() {
        this.url = null;
        this.battery = null;
        this.reachable = null;
        this.on = null;
        this.alertMode = null;
        this.userTest = null;
    }

    public PHSensorConfiguration(String url, Integer battery, Boolean reachable, Boolean on) {
        this.url = url;
        this.battery = battery;
        this.reachable = reachable;
        this.on = on;
    }

    public PHSensorConfiguration(String url, Integer battery, Boolean reachable, Boolean on, Boolean userTest, String alertMode) {
        this(url, battery, reachable, on);
        this.userTest = userTest;
        this.alertMode = PHSensorAlertMode.fromValue(alertMode);
    }

    public PHSensorConfiguration(String url, Integer battery, Boolean reachable, Boolean on, Boolean userTest, PHSensorAlertMode alertMode) {
        this(url, battery, reachable, on);
        this.userTest = userTest;
        this.alertMode = alertMode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getBattery() {
        return this.battery;
    }

    public void setBattery(Integer battery) {
        this.battery = battery;
    }

    public Boolean getReachable() {
        return this.reachable;
    }

    public void setReachable(Boolean reachable) {
        this.reachable = reachable;
    }

    public Boolean getOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public PHSensorAlertMode getAlertMode() {
        return this.alertMode;
    }

    public void setAlertMode(PHSensorAlertMode alertMode) {
        this.alertMode = alertMode;
    }

    public Boolean getUserTest() {
        return this.userTest;
    }

    public void setUserTest(Boolean userTest) {
        this.userTest = userTest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alertMode == null ? 0 : this.alertMode.hashCode());
        result = 31 * result + (this.battery == null ? 0 : this.battery.hashCode());
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        result = 31 * result + (this.reachable == null ? 0 : this.reachable.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.userTest == null ? 0 : this.userTest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHSensorConfiguration other = (PHSensorConfiguration)obj;
        if (this.alertMode != other.alertMode) {
            return false;
        }
        if (this.battery == null ? other.battery != null : !this.battery.equals(other.battery)) {
            return false;
        }
        if (this.on == null ? other.on != null : !this.on.equals(other.on)) {
            return false;
        }
        if (this.reachable == null ? other.reachable != null : !this.reachable.equals(other.reachable)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.userTest == null ? other.userTest != null : !this.userTest.equals(other.userTest));
    }

    public static enum PHSensorAlertMode {
        NONE("none"),
        SELECT("select"),
        LONG_SELECT("lselect");

        private String value;

        private PHSensorAlertMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PHSensorAlertMode fromValue(String value) {
            if (value.equals(SELECT.getValue())) {
                return SELECT;
            }
            if (value.equals(LONG_SELECT.getValue())) {
                return LONG_SELECT;
            }
            return NONE;
        }
    }
}

